% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readObject.R
\name{readObject}
\alias{readObject}
\alias{loadObject}
\alias{schemaLocations}
\alias{customloadObjectHelper}
\alias{.loadObjectInternal}
\alias{readObjectFunctionRegistry}
\alias{registerReadObjectFunction}
\title{Read an object from disk}
\usage{
readObject(path, metadata = NULL, ...)

readObjectFunctionRegistry()

registerReadObjectFunction(type, fun, existing = c("old", "new", "error"))
}
\arguments{
\item{path}{String containing a path to a directory, itself created with a \code{\link{saveObject}} method.}

\item{metadata}{Named list containing metadata for the object - most importantly, the \code{type} field that controls dispatch to the correct loading function.
If \code{NULL}, this is automatically read by \code{\link{readObjectFile}(path)}.}

\item{...}{Further arguments to pass to individual methods.}

\item{type}{String specifying the name of type of the object.}

\item{fun}{A loading function that accepts \code{path}, \code{metadata} and \code{...} (in that order), and returns the associated object.
This may also be \code{NULL} to delete an existing entry in the registry.}

\item{existing}{Logical scalar indicating the action to take if a function has already been registered for \code{type} -
keep the old or new function, or throw an error.}
}
\value{
For \code{readObject}, an object created from the on-disk representation in \code{path}.

For \code{readObjectFunctionRegistry}, a named list of functions used to load each object type.

For \code{registerReadObjectFunction}, the function is added to the registry.
}
\description{
Read an object from its on-disk representation.
This is done by dispatching to an appropriate loading function based on the type in the \code{OBJECT} file.
}
\section{Comments for extension developers}{

\code{readObject} uses an internal registry of functions to decide how an object should be loaded into memory.
Developers of alabaster extensions can add extra functions to this registry, usually in the \code{\link{.onLoad}} function of their packages.
Alternatively, extension developers can request the addition of their packages to default registry.

If a loading function makes use of additional arguments in \code{...}, 
those arguments should be prefixed by the name of the object type for each method, e.g., \code{simple_list.parallel}.
This avoids problems with conflicts in the interpretation of identically named arguments between different functions.
Unlike the \code{...} arguments in \code{\link{saveObject}}, we prefix by the object type instead of the output class, as the former is used for dispatch here.

When writing loading functions for complex classes, extension developers may need to load child objects to compose the output object.
In such cases, developers should use \code{\link{altReadObject}} on the child subdirectories, rather than calling \code{readObject} directly.
This ensures that any application-level overrides of the loading functions are respected. 
It is also expected that arguments in \code{...} are forwarded to internal \code{\link{altReadObject}} calls.

Developers can manually control \code{readObject} dispatch by suppling a \code{metadata} list where \code{metadata$type} is set to the desired object type.
This pattern is commonly used inside the loading function for a subclass -
an instance of the base class is first constructed by an internal \code{readObject} call with the modified \code{metadata$type}, after which the subclass-specific slots are added.
(In practice, base construction should be done using \code{\link{altReadObject}} so as to respect application-specific overrides.)
}

\section{Comments for application developers}{

Application developers can override \code{readObject} by specifying a custom function in \code{\link{altReadObject}}.
This can be used to point to a different registry of reading functions, to perform pre- or post-reading actions, etc.
If customization is type-specific, the custom \code{altReadObject} function can read the type from the \code{OBJECT} file to determine the most appropriate course of action;
the \code{OBJECT} metadata can then be passed to the \code{metadata} argument of any internal \code{readObject} calls to avoid a redundant read from the same file.
}

\examples{
library(S4Vectors)
df <- DataFrame(A=1:10, B=LETTERS[1:10])

tmp <- tempfile()
saveObject(df, tmp)
readObject(tmp)

}
\author{
Aaron Lun
}
