% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MultiAssayExperiment-class.R
\name{MultiAssayExperiment}
\alias{MultiAssayExperiment}
\title{Construct a \code{MultiAssayExperiment} object}
\usage{
MultiAssayExperiment(
  experiments = ExperimentList(),
  colData = S4Vectors::DataFrame(),
  sampleMap = S4Vectors::DataFrame(assay = factor(), primary = character(), colname =
    character()),
  metadata = list(),
  drops = list()
)
}
\arguments{
\item{experiments}{A \code{list} or \link{ExperimentList} of all
combined experiments}

\item{colData}{A \code{\linkS4class{DataFrame}} or \code{data.frame} of
characteristics for all biological units}

\item{sampleMap}{A \code{DataFrame} or \code{data.frame} of assay names,
sample identifiers, and colname samples}

\item{metadata}{An optional argument of "ANY" class (usually list) for
content describing the experiments}

\item{drops}{A \code{list} of unmatched information
(included after subsetting)}
}
\value{
A \code{MultiAssayExperiment} object that can store
experiment and phenotype data
}
\description{
The constructor function for the \link{MultiAssayExperiment-class} combines
multiple data elements from the different hierarchies of data
(study, experiments, and samples). It can create instances where neither
a \code{sampleMap} or a \code{colData} set is provided. Please see the
MultiAssayExperiment API documentation for more information.
}
\examples{
## Run the example ExperimentList
example("ExperimentList")

## Create sample maps for each experiment
exprmap <- data.frame(
    primary = c("Jack", "Jill", "Barbara", "Bob"),
    colname = c("array1", "array2", "array3", "array4"),
    stringsAsFactors = FALSE)

methylmap <- data.frame(
    primary = c("Jack", "Jack", "Jill", "Barbara", "Bob"),
    colname = c("methyl1", "methyl2", "methyl3", "methyl4", "methyl5"),
    stringsAsFactors = FALSE)

rnamap <- data.frame(
    primary = c("Jack", "Jill", "Bob", "Barbara"),
    colname = c("samparray1", "samparray2", "samparray3", "samparray4"),
    stringsAsFactors = FALSE)

gistmap <- data.frame(
    primary = c("Jack", "Bob", "Jill"),
    colname = c("samp0", "samp1", "samp2"),
    stringsAsFactors = FALSE)

## Combine as a named list and convert to a DataFrame
maplist <- list(Affy = exprmap, Methyl450k = methylmap,
    RNASeqGene = rnamap, GISTIC = gistmap)

## Create a sampleMap
sampMap <- listToMap(maplist)
## Create an example phenotype data
colDat <- data.frame(sex = c("M", "F", "M", "F"), age = 38:41,
    row.names = c("Jack", "Jill", "Bob", "Barbara"))

## Create a MultiAssayExperiment instance
mae <- MultiAssayExperiment(experiments = ExpList, colData = colDat,
    sampleMap = sampMap)
}
\seealso{
\link{MultiAssayExperiment-class}
}
