# SPDX-License-Identifier: BSD-3-Clause
#
# Copyright 2020 Raritan Inc. All rights reserved.
#
# This file was generated by IdlC from ServerMonitor.idl.

use strict;

package Raritan::RPC::servermon::ServerMonitor_2_0_0;

use parent qw(Raritan::RPC::RemoteObject);

use constant typeId => "servermon.ServerMonitor:2.0.0";

sub new {
    my ($class, $agent, $rid, $typeId) = @_;
    $typeId = $typeId || Raritan::RPC::servermon::ServerMonitor_2_0_0::typeId;
    return $class->SUPER::new($agent, $rid, $typeId);
}

use constant ERR_NO_SUCH_ID => 1;

use constant ERR_INVALID_SETTINGS => 2;

use constant ERR_DUPLICATE_HOSTNAME => 3;

use constant ERR_MAX_SERVERS_REACHED => 4;

use Raritan::RPC::servermon::ServerMonitor_2_0_0::ServerSettings;

sub addServer($$$) {
    my ($self, $id, $settings) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'settings'} = Raritan::RPC::servermon::ServerMonitor_2_0_0::ServerSettings::encode($settings);
    my $rsp = $agent->json_rpc($self->{'rid'}, 'addServer', $args);
    $$id = $rsp->{'id'};
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}

use Raritan::RPC::servermon::ServerMonitor_2_0_0::ServerSettings;

sub modifyServer($$$) {
    my ($self, $id, $settings) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'id'} = 1 * $id;
    $args->{'settings'} = Raritan::RPC::servermon::ServerMonitor_2_0_0::ServerSettings::encode($settings);
    my $rsp = $agent->json_rpc($self->{'rid'}, 'modifyServer', $args);
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}

sub deleteServer($$) {
    my ($self, $id) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'id'} = 1 * $id;
    my $rsp = $agent->json_rpc($self->{'rid'}, 'deleteServer', $args);
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}

use Raritan::RPC::servermon::ServerMonitor_2_0_0::Server;

sub getServer($$$) {
    my ($self, $server, $id) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'id'} = 1 * $id;
    my $rsp = $agent->json_rpc($self->{'rid'}, 'getServer', $args);
    $$server = Raritan::RPC::servermon::ServerMonitor_2_0_0::Server::decode($agent, $rsp->{'server'});
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}

use Raritan::RPC::servermon::ServerMonitor_2_0_0::Server;

sub listServers($) {
    my ($self) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'listServers', $args);
    my $_ret_;
    $_ret_ = {};
    for (my $i0 = 0; $i0 <= $#{$rsp->{'_ret_'}}; $i0++) {
        my $key0 = $rsp->{'_ret_'}->[$i0]->{'key'};
        my $value0 = Raritan::RPC::servermon::ServerMonitor_2_0_0::Server::decode($agent, $rsp->{'_ret_'}->[$i0]->{'value'});
        $_ret_->{$key0} = $value0;
    }
    return $_ret_;
}

Raritan::RPC::Registry::registerProxyClass('servermon.ServerMonitor', 2, 0, 0, 'Raritan::RPC::servermon::ServerMonitor_2_0_0');
1;
