#!/bin/bash

# Test package that computes default database settings

TMP_DIR="${TMPDIR}"

test -z "${LIB_DIR}" && LIB_DIR=lib

SCRIPT_BASE=`basename $0 | sed "s/_[0-9]*\.sh$//"`

BASENAME=$(basename $0 .pm)

#BEGIN DEPEND------------------------------------------------------------------

INPUT_SCRIPT="${LIB_DIR}/${SCRIPT_BASE}"

#END DEPEND--------------------------------------------------------------------

set -ue
## set -x

test -z "${TMP_DIR}" && TMP_DIR="/tmp"
TMP_DIR="${TMP_DIR}/tmp-${BASENAME}-$$"
mkdir "${TMP_DIR}"

# To make the trap portable between bash and dash, we need to trap
# "signal" 0 ("EXIT") and rely on it for the cleanup:
## trap "rm -rf '${TMP_DIR}'" 0 1 2 3 15
trap "rm -rf '${TMP_DIR}'" EXIT
trap "exit 1" HUP INT QUIT TERM

TMP_DB_MAIN="${TMP_DIR}/test4fk.db"
TMP_DB_META="${TMP_DIR}/restful.db"

cp db/test4fk.db ${TMP_DB_MAIN}

sqlite3 ${TMP_DB_MAIN} 'delete from sample;'
sqlite3 ${TMP_DB_MAIN} 'delete from experiment;'
sqlite3 ${TMP_DB_META} < sql/metatables.sql

export TMP_DB_MAIN

perl <<'END'
#! /usr/bin/env perl

use strict;
use warnings;
use utf8;
use Data::Dumper;

use lib 'lib';
use Database;
use Database::Order;
use RestfulDB::JSON qw( json2data );

binmode( STDOUT, "utf8" );

$Data::Dumper::Sortkeys = 1;
$Data::Dumper::Indent   = 1;

my $db_settings = {
    content_db => {
        DB => $ENV{TMP_DB_MAIN},
        engine => 'SQLite'            
    }
};

my $db = Database->new( $db_settings );
$db->connect();

open( my $inp, 'tests/outputs/RestfulDB-JSON.pm_006.out' );
my $json = join '', <$inp>;
close $inp;

my $data = json2data( $json );
$data->[0]{columns}{mine}{sqltype} = 'set';
$db->modify_record_descriptions( $data );
END

sqlite3 -nullvalue NULL ${TMP_DB_MAIN} "select * from sample"

# Temporary directory will be deleted by the trap.
