/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.io.Serializable;
import java.util.HashMap;
import net.sf.saxon.castor.schema.SimpleType;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Name;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.pattern.NoNodeTest;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.xpath.XPathException;

public abstract class Type
implements Serializable {
    private static HashMap hierarchy = new HashMap(100);
    public static final short ELEMENT = 1;
    public static final short ATTRIBUTE = 2;
    public static final short TEXT = 3;
    public static final short PROCESSING_INSTRUCTION = 7;
    public static final short COMMENT = 8;
    public static final short DOCUMENT = 9;
    public static final short NAMESPACE = 13;
    public static final short NODE = 0;
    public static final short ITEM = 88;
    public static final short MAX_NODE_TYPE = 13;
    public static final short EMPTY = 15;
    public static final int ATOMIC = 90;
    public static final int NUMBER = 91;
    public static final int ANY_SIMPLE_TYPE = 92;
    public static final int ANY_TYPE = 93;
    public static final int UNTYPED_ANY = 94;
    public static final int STRING = 101;
    public static final int BOOLEAN = 102;
    public static final int DECIMAL = 103;
    public static final int FLOAT = 104;
    public static final int DOUBLE = 105;
    public static final int DURATION = 106;
    public static final int DATE_TIME = 107;
    public static final int TIME = 108;
    public static final int DATE = 109;
    public static final int G_YEAR_MONTH = 110;
    public static final int G_YEAR = 111;
    public static final int G_MONTH_DAY = 112;
    public static final int G_DAY = 113;
    public static final int G_MONTH = 114;
    public static final int HEX_BINARY = 115;
    public static final int BASE64_BINARY = 116;
    public static final int ANY_URI = 117;
    public static final int QNAME = 118;
    public static final int NOTATION = 119;
    public static final int UNTYPED_ATOMIC = 125;
    public static final int OBJECT = 130;
    public static final int INTEGER = 200;
    public static final int NON_POSITIVE_INTEGER = 201;
    public static final int NEGATIVE_INTEGER = 202;
    public static final int LONG = 203;
    public static final int INT = 204;
    public static final int SHORT = 205;
    public static final int BYTE = 206;
    public static final int NON_NEGATIVE_INTEGER = 207;
    public static final int POSITIVE_INTEGER = 208;
    public static final int UNSIGNED_LONG = 209;
    public static final int UNSIGNED_INT = 210;
    public static final int UNSIGNED_SHORT = 211;
    public static final int UNSIGNED_BYTE = 212;
    public static final int NORMALIZED_STRING = 220;
    public static final int TOKEN = 221;
    public static final int LANGUAGE = 222;
    public static final int NMTOKEN = 223;
    public static final int NMTOKENS = 224;
    public static final int NAME = 225;
    public static final int NCNAME = 226;
    public static final int ID = 227;
    public static final int IDREF = 228;
    public static final int IDREFS = 229;
    public static final int ENTITY = 230;
    public static final int ENTITIES = 231;
    public static final int YEAR_MONTH_DURATION = 240;
    public static final int DAY_TIME_DURATION = 241;
    public static final int SAME_AS_FIRST_ARGUMENT = 999999;
    static String[] typeName = new String[255];
    static AtomicType[] atomicTypeTable = new AtomicType[255];
    static HashMap typeTable = new HashMap(255);
    public static final AtomicType UNTYPED_ATOMIC_TYPE;
    public static final AtomicType ATOMIC_TYPE;
    public static final AtomicType YEAR_MONTH_DURATION_TYPE;
    public static final AtomicType DAY_TIME_DURATION_TYPE;
    public static final AtomicType STRING_TYPE;
    public static final AtomicType BOOLEAN_TYPE;
    public static final AtomicType DECIMAL_TYPE;
    public static final AtomicType FLOAT_TYPE;
    public static final AtomicType DOUBLE_TYPE;
    public static final AtomicType DURATION_TYPE;
    public static final AtomicType DATE_TIME_TYPE;
    public static final AtomicType TIME_TYPE;
    public static final AtomicType DATE_TYPE;
    public static final AtomicType G_YEAR_MONTH_TYPE;
    public static final AtomicType G_YEAR_TYPE;
    public static final AtomicType G_MONTH_DAY_TYPE;
    public static final AtomicType G_DAY_TYPE;
    public static final AtomicType G_MONTH_TYPE;
    public static final AtomicType HEX_BINARY_TYPE;
    public static final AtomicType BASE64_BINARY_TYPE;
    public static final AtomicType ANY_URI_TYPE;
    public static final AtomicType QNAME_TYPE;
    public static final AtomicType NOTATION_TYPE;
    public static final AtomicType INTEGER_TYPE;
    public static final AtomicType NUMBER_TYPE;
    public static final AtomicType OBJECT_TYPE;

    public static boolean isNodeType(int type) {
        return type < 13;
    }

    private static AtomicType defineBuiltInType(int type, String name) {
        Type.typeName[type] = name;
        typeTable.put(name, new Integer(type));
        try {
            String[] parts = Name.getQNameParts(name);
            if (parts[0].equals("xs")) {
                AtomicType a = new AtomicType();
                a.setTypeCode(type);
                a.setLocalName(parts[1]);
                Type.atomicTypeTable[type] = a;
                return a;
            }
            if (parts[0].equals("xdt")) {
                AtomicType a = new AtomicType();
                a.setTypeCode(type);
                a.setLocalName(parts[1]);
                Type.atomicTypeTable[type] = a;
                return a;
            }
            return null;
        }
        catch (QNameException e) {
            throw new AssertionError((Object)("Bad QName. " + e.getMessage()));
        }
    }

    static void defineType(int type, String name) {
        Type.typeName[type] = name;
        typeTable.put(name, new Integer(type));
    }

    public static final String getTypeName(int type) {
        if (type <= 255) {
            return typeName[type];
        }
        return "" + type;
    }

    public static final String displayTypeName(Item item) {
        if (item instanceof NodeInfo) {
            return typeName[((NodeInfo)item).getNodeKind()];
        }
        return ((AtomicValue)item).getItemType().toString();
    }

    public static final String[] getExpandedTypeName(int type) {
        if (type <= 255) {
            try {
                String[] parts = Name.getQNameParts(typeName[type]);
                if ("xs".equals(parts[0])) {
                    parts[0] = "http://www.w3.org/2001/XMLSchema";
                } else if ("xdt".equals(parts[0])) {
                    parts[0] = "http://www.w3.org/2003/11/xpath-datatypes";
                }
                return parts;
            }
            catch (QNameException e) {
                throw new AssertionError((Object)("Bad entry in type table " + typeName[type]));
            }
        }
        return null;
    }

    private static final int getType(String name) throws XPathException {
        Integer t = (Integer)typeTable.get(name);
        if (t == null) {
            throw new XPathException.Static("Unknown type " + name);
        }
        return t;
    }

    public static SimpleType getBuiltInSimpleType(int typeCode) {
        return atomicTypeTable[typeCode];
    }

    public static SimpleType getBuiltInSimpleType(String namespace, String localName) {
        try {
            int t = Type.getCodeForNamedType(namespace, localName);
            return atomicTypeTable[t];
        }
        catch (XPathException err) {
            return null;
        }
    }

    private static void defineSubType(int supertype, int subtype) {
        hierarchy.put(new Integer(subtype), new Integer(supertype));
    }

    private static int getSuperType(int type) {
        Object s = hierarchy.get(new Integer(type));
        if (s == null) {
            throw new IllegalArgumentException("No supertype for type " + type);
        }
        return (Integer)s;
    }

    public static boolean isSubType(ItemType subtype, ItemType supertype) {
        if (subtype == null) {
            return false;
        }
        if (subtype == supertype) {
            return true;
        }
        if (supertype instanceof AnyItemType) {
            return true;
        }
        if (subtype instanceof AnyItemType) {
            return false;
        }
        if (subtype instanceof NoNodeTest) {
            return true;
        }
        return Type.isSubType(subtype.getSuperType(), supertype);
    }

    public static boolean isSubType(int builtInType1, int builtInType2) {
        ItemType t1 = (ItemType)Type.getBuiltInSimpleType(builtInType1);
        ItemType t2 = (ItemType)Type.getBuiltInSimpleType(builtInType2);
        return Type.isSubType(t1, t2);
    }

    public static boolean isPromotable(ItemType sourceType, ItemType targetType) {
        if (Type.isSubType(sourceType, DECIMAL_TYPE)) {
            return targetType == FLOAT_TYPE || targetType == DOUBLE_TYPE;
        }
        if (Type.isSubType(targetType, FLOAT_TYPE)) {
            return targetType == DOUBLE_TYPE;
        }
        return false;
    }

    public static int getPrimitiveType(int type) {
        if (type == 88) {
            throw new IllegalArgumentException("Supplied type " + type + " is not atomic");
        }
        int s = Type.getSuperType(type);
        if (s == 90) {
            return type;
        }
        return Type.getPrimitiveType(s);
    }

    public static final ItemType getCommonSuperType(ItemType t1, ItemType t2) {
        if (t1 instanceof NoNodeTest) {
            return t2;
        }
        if (t2 instanceof NoNodeTest) {
            return t1;
        }
        if (t1 == t2) {
            return t1;
        }
        if (Type.isSubType(t1, t2)) {
            return t2;
        }
        if (Type.isSubType(t2, t1)) {
            return t1;
        }
        return Type.getCommonSuperType(t2.getSuperType(), t1);
    }

    public static int getCodeForNamedType(String uri, String localName) throws XPathException {
        if (uri.equals("http://www.w3.org/2001/XMLSchema") || uri.equals("http://www.w3.org/2001/XMLSchema-datatypes")) {
            return Type.getType("xs:" + localName);
        }
        if (uri.equals("http://www.w3.org/2003/11/xpath-datatypes")) {
            return Type.getType("xdt:" + localName);
        }
        if (uri.equals("http://saxon.sf.net/java-type")) {
            return Type.getType("java:" + localName);
        }
        throw new XPathException.Static("Unknown type " + (uri.equals("") ? "" : "{" + uri + "}") + localName);
    }

    public static int getSystemType(String name) throws XPathException {
        if (name.equals("item")) {
            return 88;
        }
        if (name.equals("document-node")) {
            return 9;
        }
        if (name.equals("element")) {
            return 1;
        }
        if (name.equals("attribute")) {
            return 2;
        }
        if (name.equals("text")) {
            return 3;
        }
        if (name.equals("comment")) {
            return 8;
        }
        if (name.equals("processing-instruction")) {
            return 7;
        }
        if (name.equals("namespace")) {
            return 13;
        }
        if (name.equals("node")) {
            return 0;
        }
        if (name.equals("empty")) {
            return 15;
        }
        throw new XPathException.Static("Unknown type " + name);
    }

    public static boolean isPrimitiveType(int code) {
        return code >= 101 && code <= 130;
    }

    static {
        Type.defineType(88, "item");
        Type.defineType(0, "node");
        Type.defineType(1, "element");
        Type.defineType(9, "document");
        Type.defineType(2, "attribute");
        Type.defineType(3, "text");
        Type.defineType(8, "comment");
        Type.defineType(7, "processing-instruction");
        Type.defineType(13, "namespace");
        Type.defineType(15, "empty");
        Type.defineType(91, "number");
        UNTYPED_ATOMIC_TYPE = Type.defineBuiltInType(125, "xdt:untypedAtomic");
        ATOMIC_TYPE = Type.defineBuiltInType(90, "xdt:anyAtomicType");
        YEAR_MONTH_DURATION_TYPE = Type.defineBuiltInType(240, "xdt:yearMonthDuration");
        DAY_TIME_DURATION_TYPE = Type.defineBuiltInType(241, "xdt:dayTimeDuration");
        STRING_TYPE = Type.defineBuiltInType(101, "xs:string");
        BOOLEAN_TYPE = Type.defineBuiltInType(102, "xs:boolean");
        DECIMAL_TYPE = Type.defineBuiltInType(103, "xs:decimal");
        FLOAT_TYPE = Type.defineBuiltInType(104, "xs:float");
        DOUBLE_TYPE = Type.defineBuiltInType(105, "xs:double");
        DURATION_TYPE = Type.defineBuiltInType(106, "xs:duration");
        DATE_TIME_TYPE = Type.defineBuiltInType(107, "xs:dateTime");
        TIME_TYPE = Type.defineBuiltInType(108, "xs:time");
        DATE_TYPE = Type.defineBuiltInType(109, "xs:date");
        G_YEAR_MONTH_TYPE = Type.defineBuiltInType(110, "xs:gYearMonth");
        G_YEAR_TYPE = Type.defineBuiltInType(111, "xs:gYear");
        G_MONTH_DAY_TYPE = Type.defineBuiltInType(112, "xs:gMonthDay");
        G_DAY_TYPE = Type.defineBuiltInType(113, "xs:gDay");
        G_MONTH_TYPE = Type.defineBuiltInType(114, "xs:gMonth");
        HEX_BINARY_TYPE = Type.defineBuiltInType(115, "xs:hexBinary");
        BASE64_BINARY_TYPE = Type.defineBuiltInType(116, "xs:base64Binary");
        ANY_URI_TYPE = Type.defineBuiltInType(117, "xs:anyURI");
        QNAME_TYPE = Type.defineBuiltInType(118, "xs:QName");
        NOTATION_TYPE = Type.defineBuiltInType(119, "xs:NOTATION");
        INTEGER_TYPE = Type.defineBuiltInType(200, "xs:integer");
        NUMBER_TYPE = null;
        Type.defineBuiltInType(201, "xs:nonPositiveInteger");
        Type.defineBuiltInType(202, "xs:negativeInteger");
        Type.defineBuiltInType(203, "xs:long");
        Type.defineBuiltInType(204, "xs:int");
        Type.defineBuiltInType(205, "xs:short");
        Type.defineBuiltInType(206, "xs:byte");
        Type.defineBuiltInType(207, "xs:nonNegativeInteger");
        Type.defineBuiltInType(208, "xs:positiveInteger");
        Type.defineBuiltInType(209, "xs:unsignedLong");
        Type.defineBuiltInType(210, "xs:unsignedInt");
        Type.defineBuiltInType(211, "xs:unsignedShort");
        Type.defineBuiltInType(212, "xs:unsignedByte");
        Type.defineBuiltInType(220, "xs:normalizedString");
        Type.defineBuiltInType(221, "xs:token");
        Type.defineBuiltInType(222, "xs:language");
        Type.defineBuiltInType(223, "xs:NMTOKEN");
        Type.defineBuiltInType(224, "xs:NMTOKENS");
        Type.defineBuiltInType(225, "xs:Name");
        Type.defineBuiltInType(226, "xs:NCName");
        Type.defineBuiltInType(227, "xs:ID");
        Type.defineBuiltInType(228, "xs:IDREF");
        Type.defineBuiltInType(229, "xs:IDREFS");
        Type.defineBuiltInType(230, "xs:ENTITY");
        Type.defineBuiltInType(231, "xs:ENTITIES");
        OBJECT_TYPE = Type.defineBuiltInType(130, "java:java.lang.Object");
        Type.defineSubType(88, 0);
        Type.defineSubType(0, 1);
        Type.defineSubType(0, 2);
        Type.defineSubType(0, 9);
        Type.defineSubType(0, 3);
        Type.defineSubType(0, 8);
        Type.defineSubType(0, 7);
        Type.defineSubType(0, 13);
        Type.defineSubType(88, 90);
        Type.defineSubType(90, 101);
        Type.defineSubType(90, 102);
        Type.defineSubType(90, 91);
        Type.defineSubType(90, 106);
        Type.defineSubType(90, 107);
        Type.defineSubType(90, 108);
        Type.defineSubType(90, 109);
        Type.defineSubType(90, 110);
        Type.defineSubType(90, 111);
        Type.defineSubType(90, 112);
        Type.defineSubType(90, 113);
        Type.defineSubType(90, 114);
        Type.defineSubType(90, 115);
        Type.defineSubType(90, 116);
        Type.defineSubType(90, 117);
        Type.defineSubType(90, 118);
        Type.defineSubType(90, 119);
        Type.defineSubType(90, 125);
        Type.defineSubType(90, 130);
        Type.defineSubType(91, 103);
        Type.defineSubType(91, 105);
        Type.defineSubType(91, 104);
        Type.defineSubType(103, 200);
        Type.defineSubType(200, 201);
        Type.defineSubType(201, 202);
        Type.defineSubType(200, 203);
        Type.defineSubType(203, 204);
        Type.defineSubType(204, 205);
        Type.defineSubType(205, 206);
        Type.defineSubType(200, 207);
        Type.defineSubType(207, 208);
        Type.defineSubType(207, 209);
        Type.defineSubType(209, 210);
        Type.defineSubType(210, 211);
        Type.defineSubType(211, 212);
        Type.defineSubType(106, 240);
        Type.defineSubType(106, 241);
        Type.defineSubType(101, 220);
        Type.defineSubType(220, 221);
        Type.defineSubType(221, 222);
        Type.defineSubType(221, 225);
        Type.defineSubType(221, 223);
        Type.defineSubType(225, 226);
        Type.defineSubType(226, 227);
        Type.defineSubType(226, 228);
        Type.defineSubType(226, 230);
    }
}

