/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.classfile.attribute;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.cojen.classfile.Attribute;
import org.cojen.classfile.ConstantPool;
import org.cojen.classfile.Modifiers;
import org.cojen.classfile.constant.ConstantClassInfo;
import org.cojen.classfile.constant.ConstantUTFInfo;

public class InnerClassesAttr
extends Attribute {
    private List<Info> mInnerClasses = new ArrayList<Info>();

    public InnerClassesAttr(ConstantPool cp) {
        super(cp, "InnerClasses");
    }

    public InnerClassesAttr(ConstantPool cp, String name) {
        super(cp, name);
    }

    public InnerClassesAttr(ConstantPool cp, String name, int length, DataInput din) throws IOException {
        super(cp, name);
        int size = din.readUnsignedShort();
        for (int i = 0; i < size; ++i) {
            int inner_index = din.readUnsignedShort();
            int outer_index = din.readUnsignedShort();
            int name_index = din.readUnsignedShort();
            int af = din.readUnsignedShort();
            ConstantClassInfo inner = inner_index == 0 ? null : (ConstantClassInfo)cp.getConstant(inner_index);
            ConstantClassInfo outer = outer_index == 0 ? null : (ConstantClassInfo)cp.getConstant(outer_index);
            ConstantUTFInfo innerName = name_index == 0 ? null : (ConstantUTFInfo)cp.getConstant(name_index);
            this.mInnerClasses.add(new Info(inner, outer, innerName, Modifiers.getInstance(af)));
        }
    }

    public void addInnerClass(String inner, String outer, String name, Modifiers modifiers) {
        ConstantClassInfo innerInfo = this.getConstantPool().addConstantClass(inner);
        ConstantClassInfo outerInfo = outer == null ? null : this.getConstantPool().addConstantClass(outer);
        ConstantUTFInfo nameInfo = name == null ? null : this.getConstantPool().addConstantUTF(name);
        this.mInnerClasses.add(new Info(innerInfo, outerInfo, nameInfo, modifiers));
    }

    public Info[] getInnerClassesInfo() {
        return this.mInnerClasses.toArray(new Info[this.mInnerClasses.size()]);
    }

    public int getLength() {
        return 2 + 8 * this.mInnerClasses.size();
    }

    public void writeDataTo(DataOutput dout) throws IOException {
        int size = this.mInnerClasses.size();
        dout.writeShort(size);
        for (int i = 0; i < size; ++i) {
            this.mInnerClasses.get(i).writeTo(dout);
        }
    }

    public static class Info {
        private ConstantClassInfo mInner;
        private ConstantClassInfo mOuter;
        private ConstantUTFInfo mName;
        private Modifiers mModifiers;

        Info(ConstantClassInfo inner, ConstantClassInfo outer, ConstantUTFInfo name, Modifiers modifiers) {
            this.mInner = inner;
            this.mOuter = outer;
            this.mName = name;
            this.mModifiers = modifiers;
        }

        public ConstantClassInfo getInnerClass() {
            return this.mInner;
        }

        public ConstantClassInfo getOuterClass() {
            return this.mOuter;
        }

        public ConstantUTFInfo getInnerClassName() {
            return this.mName;
        }

        public Modifiers getModifiers() {
            return this.mModifiers;
        }

        public void writeTo(DataOutput dout) throws IOException {
            if (this.mInner == null) {
                dout.writeShort(0);
            } else {
                dout.writeShort(this.mInner.getIndex());
            }
            if (this.mOuter == null) {
                dout.writeShort(0);
            } else {
                dout.writeShort(this.mOuter.getIndex());
            }
            if (this.mName == null) {
                dout.writeShort(0);
            } else {
                dout.writeShort(this.mName.getIndex());
            }
            dout.writeShort(this.mModifiers.getBitmask());
        }
    }
}

