/*
 * Decompiled with CFR 0.152.
 */
package thredds.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import thredds.datatype.prefs.DateField;
import thredds.datatype.prefs.DurationField;
import thredds.ui.HelpWindow;
import thredds.viewer.ui.event.ActionSourceListener;
import thredds.viewer.ui.event.ActionValueEvent;
import thredds.viewer.ui.event.ActionValueListener;
import ucar.nc2.units.DateFormatter;
import ucar.nc2.units.DateRange;
import ucar.nc2.units.DateType;
import ucar.nc2.units.DateUnit;
import ucar.nc2.units.TimeDuration;
import ucar.util.prefs.ui.Field;
import ucar.util.prefs.ui.FieldValidator;
import ucar.util.prefs.ui.PrefPanel;

public class RangeDateSelector
extends JPanel
implements FieldValidator {
    public static final String TIME_START = "start";
    public static final String TIME_END = "end";
    public static final String TIME_DURATION = "duration";
    public static final String TIME_RESOLUTION = "resolution";
    private static final int SLIDER_RESOLUTION = 1000;
    private String title;
    private String helpMessage;
    private boolean acceptButton;
    private boolean enableButton;
    private boolean isPointOnly;
    private boolean useLimits;
    private DateType minLimit;
    private DateType maxLimit;
    private DateRange dateRange;
    private Scale scale;
    private JSlider minSlider;
    private JSlider maxSlider;
    private DateField minField;
    private DateField maxField;
    private DurationField durationField;
    private DurationField resolutionField;
    private PrefPanel pp;
    private JLabel minLabel;
    private JLabel maxLabel;
    private JButton helpButton;
    private JToggleButton disableButton;
    private HelpWindow helpWindow;
    private ActionSourceListener actionSource;
    private String actionName = "rangeDateSelection";
    private boolean eventOK = true;
    private static boolean debugEvent = false;
    private static boolean debugEvent2 = false;
    private DateFormatter formatter = new DateFormatter();

    public RangeDateSelector(String title, String start, String end, String durationS, String minInterval, boolean enableButton, boolean acceptButton, String help, boolean pointOnly) throws Exception {
        this(title, new DateRange(start == null ? null : new DateType(start, null, null), end == null ? null : new DateType(end, null, null), durationS == null ? null : new TimeDuration(durationS), minInterval == null ? null : new TimeDuration(minInterval)), enableButton, acceptButton, help, pointOnly, true);
    }

    public RangeDateSelector(String title, DateRange range, boolean enableButton, boolean acceptButton, String help, boolean pointOnly, boolean useLimits) {
        this.title = title;
        this.dateRange = range;
        this.acceptButton = acceptButton;
        this.enableButton = enableButton;
        this.helpMessage = help;
        this.isPointOnly = pointOnly;
        this.useLimits = useLimits;
        this.init();
    }

    private void init() {
        JPanel topPanel = null;
        topPanel = new JPanel(new BorderLayout());
        JPanel butts = new JPanel();
        if (this.title != null) {
            topPanel.add("West", new JLabel("  " + this.title + ":"));
        }
        if (this.helpMessage != null) {
            this.helpButton = new JButton("help");
            this.helpButton.addActionListener(new AbstractAction(){

                public void actionPerformed(ActionEvent e) {
                    if (RangeDateSelector.this.helpWindow == null) {
                        RangeDateSelector.this.helpWindow = new HelpWindow(null, "Help on " + RangeDateSelector.this.title, RangeDateSelector.this.helpMessage);
                    }
                    RangeDateSelector.this.helpWindow.show(RangeDateSelector.this.helpButton);
                }
            });
            butts.add(this.helpButton);
        }
        if (this.acceptButton) {
            JButton okButton = new JButton("accept");
            okButton.addActionListener(new AbstractAction(){

                public void actionPerformed(ActionEvent e) {
                    RangeDateSelector.this.pp.accept();
                    RangeDateSelector.this.sendEvent();
                }
            });
            butts.add(okButton);
            this.acceptButton = false;
        }
        if (this.enableButton) {
            this.disableButton = new JToggleButton("disable", false);
            this.disableButton.addActionListener(new AbstractAction(){

                public void actionPerformed(ActionEvent e) {
                    boolean b = !RangeDateSelector.this.disableButton.getModel().isSelected();
                    RangeDateSelector.this.minField.setEnabled(b);
                    RangeDateSelector.this.maxField.setEnabled(b);
                    RangeDateSelector.this.durationField.setEnabled(b);
                    RangeDateSelector.this.minSlider.setEnabled(b);
                    RangeDateSelector.this.maxSlider.setEnabled(b);
                }
            });
            butts.add(this.disableButton);
        }
        topPanel.add("East", butts);
        JPanel sliderPanel = new JPanel();
        sliderPanel.setLayout(new BoxLayout(sliderPanel, 1));
        sliderPanel.setBorder(new LineBorder(Color.black, 1, true));
        this.minSlider = new JSlider(0, 0, 1000, 0);
        this.maxSlider = new JSlider(0, 0, 1000, 1000);
        Border b = BorderFactory.createEmptyBorder(0, 15, 0, 15);
        this.minSlider.setBorder(b);
        this.maxSlider.setBorder(b);
        this.minLabel = new JLabel();
        this.maxLabel = new JLabel();
        this.minField = new DateField(TIME_START, this.isPointOnly ? "value" : TIME_START, this.dateRange.getStart(), null);
        this.maxField = new DateField(TIME_END, TIME_END, this.dateRange.getEnd(), null);
        this.durationField = new DurationField(TIME_DURATION, TIME_DURATION, this.dateRange.getDuration(), null);
        this.resolutionField = new DurationField(TIME_RESOLUTION, TIME_RESOLUTION, this.dateRange.getResolution(), null);
        this.minField.addValidator(this);
        this.maxField.addValidator(this);
        this.durationField.addValidator(this);
        this.setDateRange(this.dateRange);
        JPanel labelPanel = new JPanel(new BorderLayout());
        labelPanel.add((Component)this.minLabel, "West");
        labelPanel.add((Component)this.maxLabel, "East");
        this.pp = new PrefPanel(null, null);
        int row = 0;
        if (this.isPointOnly) {
            this.pp.addField(this.minField, 0, row++, null);
        } else {
            this.pp.addField(this.minField, 0, row++, null);
            this.pp.addField(this.maxField, 0, row++, null);
            this.pp.addField(this.durationField, 0, row++, null);
            this.pp.addField(this.resolutionField, 0, row++, null);
        }
        this.pp.finish(this.acceptButton, "East");
        this.setLayout(new BorderLayout());
        if (topPanel != null) {
            sliderPanel.add(topPanel);
        }
        sliderPanel.add(this.pp);
        if (this.useLimits) {
            if (!this.isPointOnly) {
                sliderPanel.add(this.maxSlider);
            }
            sliderPanel.add(this.minSlider);
            sliderPanel.add(labelPanel);
        }
        this.add((Component)sliderPanel, "North");
        this.maxSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                if (debugEvent2) {
                    System.out.println("maxSlider event= " + RangeDateSelector.this.maxSlider.getValue());
                }
                if (!RangeDateSelector.this.eventOK) {
                    return;
                }
                int pos = RangeDateSelector.this.maxSlider.getValue();
                RangeDateSelector.this.dateRange.setEnd(RangeDateSelector.this.scale.slider2world(pos));
                RangeDateSelector.this.synchUI(false);
                if (RangeDateSelector.this.dateRange.isPoint()) {
                    RangeDateSelector.this.minSlider.setValue(pos);
                }
            }
        });
        this.minSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                if (debugEvent2) {
                    System.out.println("minSlider event= " + RangeDateSelector.this.minSlider.getValue());
                }
                if (!RangeDateSelector.this.eventOK) {
                    return;
                }
                int pos = RangeDateSelector.this.minSlider.getValue();
                RangeDateSelector.this.dateRange.setStart(RangeDateSelector.this.scale.slider2world(pos));
                RangeDateSelector.this.synchUI(false);
                if (RangeDateSelector.this.dateRange.isPoint() && !RangeDateSelector.this.isPointOnly) {
                    RangeDateSelector.this.maxSlider.setValue(pos);
                }
            }
        });
        this.minField.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                if (debugEvent) {
                    System.out.println("minField event= " + e.getNewValue() + " " + e.getNewValue().getClass().getName());
                }
                if (!RangeDateSelector.this.eventOK) {
                    return;
                }
                DateType val = (DateType)RangeDateSelector.this.minField.getValue();
                RangeDateSelector.this.dateRange.setStart(val);
                RangeDateSelector.this.synchUI(true);
            }
        });
        if (this.maxField != null) {
            this.maxField.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent e) {
                    if (debugEvent) {
                        System.out.println("maxField event= " + e.getNewValue());
                    }
                    if (!RangeDateSelector.this.eventOK) {
                        return;
                    }
                    DateType val = (DateType)RangeDateSelector.this.maxField.getValue();
                    RangeDateSelector.this.dateRange.setEnd(val);
                    RangeDateSelector.this.synchUI(true);
                }
            });
        }
        if (this.durationField != null) {
            this.durationField.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent e) {
                    if (debugEvent) {
                        System.out.println("durationField event= " + e.getNewValue());
                    }
                    if (!RangeDateSelector.this.eventOK) {
                        return;
                    }
                    TimeDuration val = RangeDateSelector.this.durationField.getTimeDuration();
                    RangeDateSelector.this.dateRange.setDuration(val);
                    RangeDateSelector.this.synchUI(true);
                }
            });
        }
        if (this.resolutionField != null) {
            this.resolutionField.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent e) {
                    if (debugEvent) {
                        System.out.println("resolutionField event= " + e.getNewValue());
                    }
                    if (!RangeDateSelector.this.eventOK) {
                        return;
                    }
                    TimeDuration val = RangeDateSelector.this.resolutionField.getTimeDuration();
                    RangeDateSelector.this.dateRange.setResolution(val);
                }
            });
        }
        this.actionSource = new ActionSourceListener(this.actionName){

            public void actionPerformed(ActionValueEvent e) {
                if (debugEvent) {
                    System.out.println(" actionSource event " + e);
                }
            }
        };
    }

    public boolean validate(Field fld, Object editValue, StringBuffer errMessages) {
        if (!this.useLimits) {
            return true;
        }
        DateType checkVal = null;
        if (fld == this.durationField) {
            TimeDuration duration = (TimeDuration)editValue;
            checkVal = this.dateRange.getEnd().isPresent() ? this.dateRange.getEnd().subtract(duration) : this.dateRange.getStart().add(duration);
        } else {
            checkVal = (DateType)editValue;
        }
        Date d = checkVal.getDate();
        if (d.after(this.maxLimit.getDate()) || d.before(this.minLimit.getDate())) {
            errMessages.append("Date ");
            errMessages.append(this.formatter.toDateTimeString(d));
            errMessages.append(" must be between ");
            errMessages.append(this.minLimit.getText());
            errMessages.append(" and ");
            errMessages.append(this.maxLimit.getText());
            return false;
        }
        return true;
    }

    private void synchUI(boolean slidersOK) {
        this.eventOK = false;
        if (slidersOK) {
            this.minSlider.setValue(this.scale.world2slider(this.dateRange.getStart()));
        }
        this.minField.setValue(this.dateRange.getStart());
        if (this.maxField != null) {
            if (slidersOK) {
                this.maxSlider.setValue(this.scale.world2slider(this.dateRange.getEnd()));
            }
            this.maxField.setValue(this.dateRange.getEnd());
        }
        if (this.durationField != null) {
            this.durationField.setValue(this.dateRange.getDuration());
        }
        this.eventOK = true;
    }

    public void setDateRange(DateRange dateRange) {
        this.dateRange = dateRange;
        this.minLimit = new DateType(dateRange.getStart());
        this.maxLimit = new DateType(dateRange.getEnd());
        this.scale = new Scale(dateRange);
        this.minLabel.setText(" " + this.minLimit.getText() + " ");
        this.maxLabel.setText(" " + this.maxLimit.getText() + " ");
        if (this.isPointOnly) {
            this.minField.setValue(dateRange.getStart());
        } else {
            this.minField.setValue(dateRange.getStart());
            this.maxField.setValue(dateRange.getEnd());
            this.durationField.setValue(dateRange.getDuration());
            this.resolutionField.setValue(dateRange.getResolution());
        }
    }

    public DateField getMinDateField() {
        return this.minField;
    }

    public DateField getMaxDateField() {
        return this.maxField;
    }

    public DurationField getDurationField() {
        return this.durationField;
    }

    public DurationField getResolutionField() {
        return this.resolutionField;
    }

    public boolean isEnabled() {
        return null == this.disableButton || !this.disableButton.getModel().isSelected();
    }

    public DateRange getDateRange() {
        if (!this.pp.accept()) {
            return null;
        }
        return this.dateRange;
    }

    public void sendEvent() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                System.out.println("event range= " + RangeDateSelector.this.dateRange);
                RangeDateSelector.this.actionSource.fireActionValueEvent(RangeDateSelector.this.actionName, this);
            }
        });
    }

    public void addActionValueListener(ActionValueListener l) {
        this.actionSource.addActionValueListener(l);
    }

    public void removeActionValueListener(ActionValueListener l) {
        this.actionSource.removeActionValueListener(l);
    }

    public static void main(String[] args) throws Exception {
        JFrame frame = new JFrame("Test Date Range Selector");
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        RangeDateSelector rs1 = new RangeDateSelector("Date Range", "1990-01-01T01:00:00", "1990-01-02T02:00:00", null, "15 minute", true, true, "i think im fallin", false);
        RangeDateSelector rs2 = new RangeDateSelector("Date", "1990-01-01", "1991-01-01", null, "1 day", false, true, "i think im fallin\n in love with youuuu ", false);
        RangeDateSelector rs3 = new RangeDateSelector("Date", "1990-01-01", "1991-01-01", null, "10 days", true, true, null, false);
        RangeDateSelector rs4 = new RangeDateSelector("Date", "1990-01-01", "1991-01-01", null, "10 days", false, false, null, true);
        RangeDateSelector rs5 = new RangeDateSelector("Date", null, "present", "10 days", "1 day", true, false, null, false);
        DateRange range = null;
        try {
            range = new DateRange();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        RangeDateSelector rs6 = new RangeDateSelector(null, range, false, true, null, false, false);
        DateUnit start = new DateUnit("0 secs since 2005-05-02 23:00:00");
        DateUnit end = new DateUnit("0 secs since 2005-05-02 23:59:59");
        rs6.setDateRange(new DateRange(start.getDate(), end.getDate()));
        Box main = new Box(1);
        frame.getContentPane().add(main);
        main.add(rs1);
        main.add(rs6);
        frame.pack();
        frame.setLocation(400, 300);
        frame.setVisible(true);
    }

    private class Scale {
        private double min;
        private double scale;

        Scale(DateRange dateRange) {
            this.min = 0.001 * (double)dateRange.getStart().getDate().getTime();
            this.scale = 1000.0 / dateRange.getDuration().getValueInSeconds();
        }

        private int world2slider(DateType val) {
            double msecs = 0.001 * (double)val.getDate().getTime() - this.min;
            return (int)(this.scale * msecs);
        }

        private DateType slider2world(int pval) {
            double val = (double)pval / this.scale;
            double msecs = 1000.0 * (this.min + val);
            return new DateType(false, new Date((long)msecs));
        }
    }
}

