/*
 * Decompiled with CFR 0.152.
 */
package visad.data.fits;

import java.awt.Cursor;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.rmi.RemoteException;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import visad.ConstantMap;
import visad.Data;
import visad.DataReferenceImpl;
import visad.Display;
import visad.DisplayImpl;
import visad.FunctionImpl;
import visad.FunctionType;
import visad.MathType;
import visad.RealTupleType;
import visad.RealType;
import visad.ScalarMap;
import visad.Tuple;
import visad.VisADException;
import visad.data.DefaultFamily;
import visad.java3d.DisplayImplJ3D;

public class Spasm {
    private Data data;
    public static int WIDTH = 600;
    public static int HEIGHT = 600;

    public Spasm(String filename) throws VisADException, RemoteException, IOException {
        Data data;
        DefaultFamily dflt = new DefaultFamily("Default");
        try {
            data = dflt.open(filename);
        }
        catch (VisADException e) {
            e.printStackTrace();
            System.exit(1);
            return;
        }
        if (data instanceof Tuple) {
            boolean discard = false;
            Tuple t = (Tuple)data;
            try {
                Data d;
                int i = 0;
                do {
                    d = t.getComponent(i);
                    if (discard) {
                        System.err.println("Discarding VisAD Data object #" + i + ": " + d.getType());
                    } else if (d instanceof FunctionImpl) {
                        data = d;
                        discard = true;
                    }
                    ++i;
                } while (d != null);
            }
            catch (VisADException e) {
            }
            catch (ArrayIndexOutOfBoundsException e) {
                // empty catch block
            }
            if (discard) {
                System.err.println("");
            }
        }
        this.data = data;
    }

    public String toString() {
        try {
            return this.data.getType().toString();
        }
        catch (Exception e) {
            return e.getClass().toString() + ": " + e.getMessage();
        }
    }

    private void linkData(DisplayImpl display) throws VisADException, RemoteException {
        RealType rg;
        RealType rz;
        FunctionType ftype = (FunctionType)this.data.getType();
        RealTupleType dtype = ftype.getDomain();
        int dims = dtype.getDimension();
        display.addMap(new ScalarMap((RealType)dtype.getComponent(0), Display.XAxis));
        if (dims > 1) {
            display.addMap(new ScalarMap((RealType)dtype.getComponent(1), Display.YAxis));
            if (dims > 2) {
                display.addMap(new ScalarMap((RealType)dtype.getComponent(2), Display.ZAxis));
            }
        }
        display.addMap(new ConstantMap(0.5, Display.Red));
        display.addMap(new ConstantMap(0.0, Display.Blue));
        MathType rtype = ftype.getRange();
        if (rtype instanceof RealType) {
            rg = rz = (RealType)rtype;
        } else if (rtype instanceof RealTupleType) {
            rg = (RealType)((RealTupleType)rtype).getComponent(0);
            rz = ((RealTupleType)rtype).getDimension() > 1 ? (RealType)((RealTupleType)rtype).getComponent(1) : rg;
        } else {
            rz = null;
            rg = null;
        }
        if (rg != null) {
            display.addMap(new ScalarMap(rg, Display.Green));
        }
        if (dims <= 2 && rz != null) {
            display.addMap(new ScalarMap(rz, Display.ZAxis));
        }
        System.out.println(this.data.getType());
        System.out.println(display);
        DataReferenceImpl ref = new DataReferenceImpl("SpazData");
        ref.setData(this.data);
        display.addReference(ref, null);
    }

    public void showApp() throws VisADException, RemoteException {
        DisplayImplJ3D display = new DisplayImplJ3D("display", 3);
        this.linkData(display);
    }

    private JFrame mainFrame(String frameName) {
        JFrame frame = new JFrame(frameName);
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        frame.setCursor(Cursor.getPredefinedCursor(0));
        return frame;
    }

    private JPanel textPanel() {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        p.setAlignmentY(0.0f);
        p.setAlignmentX(0.0f);
        p.add(new JLabel("Silly file viewer"));
        p.add(new JLabel("using VisAD  -  see:"));
        p.add(new JLabel("  "));
        p.add(new JLabel("  http://www.ssec.wisc.edu/~billh/visad.html"));
        p.add(new JLabel("  "));
        p.add(new JLabel("for more information about VisAD."));
        p.add(new JLabel("  "));
        return p;
    }

    private void showSwing(String frameName) throws VisADException, RemoteException {
        DisplayImplJ3D display = new DisplayImplJ3D("display");
        this.linkData(display);
        JFrame frame = this.mainFrame(frameName);
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 0));
        mainPanel.setAlignmentY(0.0f);
        mainPanel.setAlignmentX(0.0f);
        frame.getContentPane().add(mainPanel);
        mainPanel.add(this.textPanel());
        JPanel displayPanel = (JPanel)display.getComponent();
        CompoundBorder etchedBorder10 = new CompoundBorder(new EtchedBorder(), new EmptyBorder(10, 10, 10, 10));
        displayPanel.setBorder(etchedBorder10);
        mainPanel.add(displayPanel);
        frame.pack();
        frame.setVisible(true);
    }

    public static void main(String[] args) throws VisADException, RemoteException, IOException {
        if (args.length != 1) {
            System.err.println("Usage: Spasm file");
            System.exit(1);
            return;
        }
        Spasm spaz = new Spasm(args[0]);
        try {
            System.out.println("Spasm: " + spaz);
        }
        catch (Exception e) {
            System.err.println(args[0] + " print threw " + e.getMessage());
            e.printStackTrace(System.err);
            System.exit(1);
            return;
        }
        spaz.showSwing("Spasm");
    }
}

