/*
 * Decompiled with CFR 0.152.
 */
package visad.meteorology;

import visad.CoordinateSystem;
import visad.Data;
import visad.DateTime;
import visad.FlatField;
import visad.FunctionType;
import visad.MathType;
import visad.RealTupleType;
import visad.RealType;
import visad.Set;
import visad.VisADException;
import visad.georef.NavigatedCoordinateSystem;
import visad.georef.NavigatedField;
import visad.georef.TrivialNavigation;
import visad.meteorology.SingleBandedImageImpl;

public class NavigatedImage
extends SingleBandedImageImpl
implements NavigatedField {
    private NavigatedCoordinateSystem navigation;

    public NavigatedImage(FunctionType function, Set domain, DateTime startTime, String desc) throws VisADException {
        this(new FlatField(function, domain), startTime, desc);
    }

    public NavigatedImage(FlatField image, DateTime startTime, String desc) throws VisADException {
        this(image, startTime, desc, true);
    }

    public NavigatedImage(FlatField image, DateTime startTime, String desc, boolean copyData) throws VisADException {
        super(image, startTime, desc);
        this.vetDomain();
    }

    public NavigatedCoordinateSystem getNavigation() {
        return this.navigation;
    }

    private void vetDomain() throws VisADException {
        CoordinateSystem cs = this.getDomainCoordinateSystem();
        if (cs != null && !(cs instanceof NavigatedCoordinateSystem)) {
            throw new VisADException("NavigatedImage: Domain CoordinateSystem must be a NavigatedCoordinateSystem");
        }
        if (cs == null) {
            if (this.getDomainSet().getDimension() < 2 || !this.hasLatLon((RealTupleType)this.getDomainSet().getType())) {
                throw new VisADException("NavigatedImage: Domain set must have a Lat/Lon reference");
            }
            cs = new TrivialNavigation(((FunctionType)this.getType()).getDomain());
        }
        this.navigation = (NavigatedCoordinateSystem)cs;
    }

    private boolean hasLatLon(RealTupleType type) {
        return type.getIndex(RealType.Latitude) > -1 && type.getIndex(RealType.Longitude) > -1;
    }

    public boolean isNavigated() {
        return true;
    }

    public Data unary(int op, MathType new_type, int sampling_mode, int error_mode) throws VisADException {
        return new NavigatedImage((FlatField)super.unary(op, new_type, sampling_mode, error_mode), this.getStartTime(), this.getDescription(), false);
    }
}

