/*
 * Decompiled with CFR 0.152.
 */
package visad.ss;

import java.rmi.RemoteException;
import java.util.Vector;
import visad.CellImpl;
import visad.Data;
import visad.DataReferenceImpl;
import visad.Real;
import visad.RealType;
import visad.ScalarType;
import visad.VisADException;
import visad.formula.FormulaManager;
import visad.formula.VRealType;
import visad.ss.BasicSSCell;
import visad.ss.SSCellChangeEvent;
import visad.ss.SSCellData;
import visad.util.DataUtility;

public class SSCellImpl
extends CellImpl {
    public static final Real TRUE = new Real(1.0);
    public static final Real FALSE = new Real(0.0);
    private SSCellData cellData;
    private DataReferenceImpl ref;
    private String cellName;
    private String varName;
    private String[] errors;
    private FormulaManager fm;
    private boolean inited = false;
    private int skipNotify = 1;
    private int skipErrors = 0;

    public SSCellImpl(SSCellData cellData, DataReferenceImpl ref, String varName, boolean checkErrors) throws VisADException, RemoteException {
        this.cellData = cellData;
        this.ref = ref;
        this.cellName = cellData.ssCell.getName();
        this.varName = varName;
        this.fm = cellData.ssCell.getFormulaManager();
        this.inited = false;
        if (!checkErrors) {
            this.skipNextErrors();
        }
        this.addReference(ref);
    }

    public boolean isInited() {
        return this.inited;
    }

    String[] getErrors() {
        return this.errors;
    }

    void skipNextNotify() {
        ++this.skipNotify;
    }

    void skipNextErrors() {
        ++this.skipErrors;
    }

    public synchronized void doAction() {
        Data data = this.ref.getData();
        if (this.skipErrors == 0) {
            this.cellData.setErrors(this.fm.getErrors(this.varName), true, false);
        } else {
            --this.skipErrors;
        }
        if (data != null) {
            Vector v;
            block17: {
                this.cellData.ssCell.updateDisplay(true);
                v = new Vector();
                try {
                    DataUtility.getScalarTypes(new Data[]{data}, v, false, true);
                }
                catch (VisADException exc) {
                    if (BasicSSCell.DEBUG) {
                        exc.printStackTrace();
                    }
                }
                catch (RemoteException exc) {
                    if (!BasicSSCell.DEBUG) break block17;
                    exc.printStackTrace();
                }
            }
            int len = v.size();
            for (int i = 0; i < len; ++i) {
                ScalarType st = (ScalarType)v.elementAt(i);
                if (!(st instanceof RealType)) continue;
                RealType rt = (RealType)st;
                try {
                    this.fm.setThing(rt.getName(), VRealType.get(rt));
                    continue;
                }
                catch (VisADException exc) {
                    if (!BasicSSCell.DEBUG) continue;
                    exc.printStackTrace();
                    continue;
                }
                catch (RemoteException exc) {
                    if (!BasicSSCell.DEBUG) continue;
                    exc.printStackTrace();
                }
            }
            if (this.skipNotify == 0) {
                try {
                    this.cellData.ssCell.sendMessage(6, this.varName, data);
                }
                catch (RemoteException exc) {
                    if (BasicSSCell.DEBUG) {
                        exc.printStackTrace();
                    }
                }
            } else {
                --this.skipNotify;
            }
        } else {
            this.cellData.ssCell.updateDisplay();
        }
        SSCellData sSCellData = this.cellData;
        sSCellData.ssCell.updateDependencies();
        this.cellData.ssCell.notifySSCellListeners(SSCellChangeEvent.DATA_CHANGE, this.varName);
        this.inited = true;
    }
}

