/*
 * Decompiled with CFR 0.152.
 */
package visad.util;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import visad.VisADException;
import visad.util.CodeEditor;
import visad.util.TextFrame;
import visad.util.Util;

public class CodeFrame
extends TextFrame {
    public CodeFrame(CodeEditor editor) {
        super(editor);
        this.addMenuItem("Command", "Run", "commandRun", 'r');
        this.addMenuItem("Command", "Compile", "commandCompile", 'c');
    }

    protected void layoutGUI() {
        JPanel pane = new JPanel();
        pane.setLayout(new BoxLayout(pane, 1));
        this.setContentPane(pane);
        JPanel immediate = new JPanel();
        immediate.setLayout(new BoxLayout(immediate, 0));
        final JTextField textLine = new JTextField();
        Util.adjustTextField(textLine);
        textLine.setToolTipText("Enter a command and press enter to execute it immediately; up/down arrows recall commands");
        final CodeEditor fTextPane = (CodeEditor)this.textPane;
        final Vector<Integer> stack = new Vector<Integer>();
        stack.addElement(new Integer(-1));
        textLine.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    String cmd = textLine.getText();
                    fTextPane.exec(cmd);
                    int sp = (Integer)stack.elementAt(0);
                    if (sp < 0 || sp >= stack.size() || !cmd.equals((String)stack.elementAt(sp))) {
                        stack.addElement(textLine.getText());
                        stack.setElementAt(new Integer(stack.size()), 0);
                    }
                    textLine.setText("");
                }
                catch (VisADException exc) {
                    CodeFrame.this.showError(exc.getMessage());
                }
            }
        });
        textLine.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyTyped(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                int spoint = (Integer)stack.elementAt(0);
                if (spoint < 0) {
                    return;
                }
                int kc = e.getKeyCode();
                if (kc == 38) {
                    if (--spoint < 1) {
                        spoint = stack.size() - 1;
                    }
                    textLine.setText((String)stack.elementAt(spoint));
                    stack.setElementAt(new Integer(spoint), 0);
                } else if (kc == 40) {
                    if (++spoint >= stack.size()) {
                        spoint = 1;
                    }
                    textLine.setText((String)stack.elementAt(spoint));
                    stack.setElementAt(new Integer(spoint), 0);
                }
            }
        });
        immediate.add(new JLabel("Immediate: "));
        immediate.add(textLine);
        pane.add(this.textPane);
        pane.add(immediate);
        this.setTitle("VisAD Source Code Editor");
    }

    public final void commandRun() {
        try {
            ((CodeEditor)this.textPane).run();
        }
        catch (VisADException exc) {
            this.showError(exc.getMessage());
        }
    }

    public void commandCompile() {
        try {
            ((CodeEditor)this.textPane).compile();
        }
        catch (VisADException exc) {
            this.showError(exc.getMessage());
        }
    }
}

