package internal

import (
	"testing"

	"github.com/cloudflare/circl/sign/dilithium/internal/common"
)

// Tests specific to the current mode

func TestVectorDeriveUniformLeqEta(t *testing.T) {
	var p common.Poly
	var seed [32]byte
	p2 := common.Poly{
		4, 8380412, 8380414, 8380415, 1, 1, 0, 6, 8380412, 8380413, 3,
		7, 3, 8380415, 8380414, 7, 8380414, 1, 0, 8380414, 8380411, 6,
		3, 3, 8380416, 8380415, 8380411, 8380415, 1, 6, 0, 6, 0, 1,
		8380414, 4, 8380414, 6, 4, 8380413, 1, 7, 0, 8380411, 8380411,
		8380414, 8380412, 2, 8380410, 5, 1, 7, 1, 6, 8380413, 5, 8380415,
		6, 8380414, 3, 4, 8380413, 8380415, 8380412, 1, 8380411, 8380411,
		8380415, 5, 7, 8380415, 8380413, 8380416, 8380412, 8380411,
		8380416, 4, 2, 8380414, 6, 8380414, 3, 8380414, 8380412, 8380415,
		8380410, 8380412, 2, 8380415, 8380415, 6, 3, 2, 8380415, 0, 6,
		2, 8380410, 8380416, 8380415, 5, 4, 6, 8380412, 8380414, 0, 2,
		8380410, 8380416, 7, 6, 8380415, 8380413, 8380411, 8380413, 3,
		3, 8380412, 8380416, 0, 5, 5, 5, 5, 8380414, 8380413, 2, 0, 5,
		8380410, 8380416, 8380414, 8380412, 8380413, 8380416, 8380414,
		8380413, 4, 8380414, 1, 8380411, 5, 8380414, 4, 2, 5, 3, 8380412,
		2, 8380412, 8380410, 8380413, 5, 8380415, 2, 8380416, 4, 8380410,
		8380412, 8380412, 4, 2, 7, 1, 8380416, 7, 6, 2, 0, 3, 8380413,
		5, 7, 7, 1, 5, 8380412, 6, 2, 8380412, 2, 5, 2, 2, 8380412, 5,
		7, 8380414, 8380416, 8380414, 7, 5, 8380410, 1, 7, 7, 6, 1, 3,
		8380410, 7, 7, 8380413, 8380411, 3, 7, 8380413, 5, 8380416, 3,
		3, 0, 8380413, 0, 4, 8380411, 4, 8380416, 2, 8380410, 8380413,
		8380415, 8380412, 8380413, 5, 8380416, 7, 8380415, 2, 6, 2, 1,
		1, 5, 3, 8380414, 4, 8380411, 8380415, 8380415, 8380412, 2,
		8380416, 6, 4, 8380410, 8380411, 8380410, 7, 4, 2, 3, 8380414,
		8380414, 8380413, 8380410,
	}
	for i := 0; i < 32; i++ {
		seed[i] = byte(i)
	}
	PolyDeriveUniformLeqEta(&p, &seed, 30000)
	p.Normalize()
	if p != p2 {
		t.Fatalf("%v != %v", p, p2)
	}
}
