//------------------------------------------------------------------------------
// <auto-generated />
//
// This file was automatically generated by SWIG (http://www.swig.org).
// Version 3.0.12
//
// Do not make changes to this file unless you know what you are doing--modify
// the SWIG interface file instead.
//------------------------------------------------------------------------------

namespace libsbml {

 using System;
 using System.Runtime.InteropServices;

/** 
 * @sbmlpackage{core}
 *
@htmlinclude pkg-marker-core.html An SBML model.
 *
 * In an SBML model definition, a single object of class Model serves as
 * the overall container for the lists of the various model components.
 * All of the lists are optional, but if a given list container is present
 * within the model, the list must not be empty; that is, it must have
 * length one or more.  The following are the components and lists
 * permitted in different Levels and Versions of SBML in
 * version @htmlinclude libsbml-version.html
 * of libSBML:
 * <ul>
 * <li> In SBML Level 1, the components are: UnitDefinition, Compartment,
 * Species, Parameter, Rule, and Reaction.  Instances of the classes are
 * placed inside instances of classes ListOfUnitDefinitions,
 * ListOfCompartments, ListOfSpecies, ListOfParameters, ListOfRules, and
 * ListOfReactions.
 *
 * <li> In SBML Level 2 Version 1, the components are: FunctionDefinition,
 * UnitDefinition, Compartment, Species, Parameter, Rule, Reaction and
 * Event.  Instances of the classes are placed inside instances of classes
 * ListOfFunctionDefinitions, ListOfUnitDefinitions, ListOfCompartments,
 * ListOfSpecies, ListOfParameters, ListOfRules, ListOfReactions, and
 * ListOfEvents.
 *
 * <li> In SBML Level 2 Versions 2, 3 and 4, the components are:
 * FunctionDefinition, UnitDefinition, CompartmentType, SpeciesType,
 * Compartment, Species, Parameter, InitialAssignment, Rule, Constraint,
 * Reaction and Event.  Instances of the classes are placed inside
 * instances of classes ListOfFunctionDefinitions, ListOfUnitDefinitions,
 * ListOfCompartmentTypes, ListOfSpeciesTypes, ListOfCompartments,
 * ListOfSpecies, ListOfParameters, ListOfInitialAssignments, ListOfRules,
 * ListOfConstraints, ListOfReactions, and ListOfEvents.
 *
 * <li> In SBML Level 3 Version 1, the components are: FunctionDefinition,
 * UnitDefinition, Compartment, Species, Parameter, InitialAssignment,
 * Rule, Constraint, Reaction and Event.  Instances of the classes are
 * placed inside instances of classes ListOfFunctionDefinitions,
 * ListOfUnitDefinitions, ListOfCompartments, ListOfSpecies,
 * ListOfParameters, ListOfInitialAssignments, ListOfRules,
 * ListOfConstraints, ListOfReactions, and ListOfEvents.  
 * </ul>
 *
 * Although all the lists are optional, there are dependencies between SBML
 * components such that defining some components requires defining others.
 * An example is that defining a species requires defining a compartment,
 * and defining a reaction requires defining a species.  The dependencies
 * are explained in more detail in the SBML specifications.
 *
 * In addition to the above lists and attributes, the Model class in both
 * SBML Level&nbsp;2 and Level&nbsp;3 has the usual two attributes of 'id'
 * and 'name', and both are optional.  As is the case for other SBML
 * components with 'id' and 'name' attributes, they must be used according
 * to the guidelines described in the SBML specifications.  (Within the
 * frameworks of SBML Level&nbsp;2 and Level&nbsp;3, a
 * Model object identifier has no assigned meaning, but extension packages
 * planned for SBML Level&nbsp;3 are likely to make use of this
 * identifier.)
 *
 * Finally, SBML Level&nbsp;3 has introduced a number of additional Model
 * attributes.  They are discussed in a separate section below.
 *
 *
 * @section approaches Approaches to creating objects using the libSBML API
 *
 * LibSBML provides two main mechanisms for creating objects: class
 * constructors
 * (e.g., @if java <a href='org/sbml/libsbml/Species.html'>Species()</a> @else Species::Species() @endif), 
 * and <code>create<span class='placeholder-nospace'><em>Object</em></span>()</code>
 * methods (such as Model::createSpecies()) provided by certain <span
 * class='placeholder-nospace'><em>Object</em></span> classes such as Model.  These
 * multiple mechanisms are provided by libSBML for flexibility and to
 * support different use-cases, but they also have different implications
 * for the overall model structure.
 *
 * In general, the recommended approach is to use the <code>create<span
 * class='placeholder-nospace'><em>Object</em></span>()</code> methods.  These
 * methods both create an object @em and link it to the parent in one step.
 * Here is an example:@if clike
 * @code{.cpp}
// Create an SBMLDocument object in Level 3 Version 1 format:

SBMLDocument sbmlDoc = new SBMLDocument(3, 1);

// Create a Model object inside the SBMLDocument object and set
// its identifier.  The call returns a pointer to the Model object
// created, and methods called on that object affect the attributes
// of the object attached to the model (as expected).

Model model = sbmlDoc->createModel();
model->setId('BestModelEver');

// Create a Species object inside the Model and set its identifier.
// Similar to the lines above, this call returns a pointer to the Species
// object created, and methods called on that object affect the attributes
// of the object attached to the model (as expected).

Species sp = model->createSpecies();
sp->setId('MySpecies');
@endcode
 * @endif@if java
@code{.java}
// Create an SBMLDocument object in Level 3 Version 1 format:

SBMLDocument sbmlDoc = new SBMLDocument(3, 1);

// Create a Model object inside the SBMLDocument object and set
// its identifier.  The call returns a pointer to the Model object
// created, and methods called on that object affect the attributes
// of the object attached to the model (as expected).  Note that
// the call to setId() returns a status code, and a real program
// should check this status code to make sure everything went okay.

Model model = sbmlDoc.createModel();
model.setId(&#34;BestModelEver&#34;);

// Create a Species object inside the Model and set its identifier.
// Similar to the lines above, this call returns a pointer to the Species
// object created, and methods called on that object affect the attributes
// of the object attached to the model (as expected).  Note that, like
// with Model, the call to setId() returns a status code, and a real program
// should check this status code to make sure everything went okay.

Species sp = model.createSpecies();
sp.setId(&#34;BestSpeciesEver&#34;);
@endcode
 * @endif@if python
@code{.py}
# Create an SBMLDocument object in Level 3 Version 1 format.
# Make sure to check for possible failures.

try:
  sbmlDoc = SBMLDocument(3, 1)
except ValueError:
  print('Could not create SBMLDocument object')
  sys.exit(1)

# Create a Model object inside the SBMLDocument object and set its
# identifier, checking the returned values.  The call to setId() returns a
# status code to indicate whether the assignment was successful.

model = sbmlDoc.createModel()
if model == None:
  # Do something to handle the error here.
  print('Unable to create Model object.')
  sys.exit(1)

status = model.setId('BestModelEver')
if status != LIBSBML_OPERATION_SUCCESS:
  # Do something to handle the error here.
  print('Unable to set identifier on the Model object')
  sys.exit(1)

# Create a Species object inside the Model and set its identifier.
# Again, the setId() returns a status code to indicate whether the
# assignment was successful.

sp = model.createSpecies()
if sp == None:
  # Do something to handle the error here.
  print('Unable to create Species object.')
  sys.exit(1)

status = sp.setId('BestSpeciesEver')
if status != LIBSBML_OPERATION_SUCCESS:
  # Do something to handle the error here.
  print('Unable to set identifier on the Species object')
  sys.exit(1)
@endcode
 * @endif@if csharp
@code
// Create an SBMLDocument object in Level 3 Version 1 format:

SBMLDocument sbmlDoc = new SBMLDocument(3, 1);

// Create a Model object inside the SBMLDocument object and set
// its identifier.  The call returns a pointer to the Model object
// created, and methods called on that object affect the attributes
// of the object attached to the model (as expected).

Model model = sbmlDoc.createModel();
model.setId('BestModelEver');

// Create a Species object inside the Model and set its identifier.
// Similar to the lines above, this call returns a pointer to the Species
// object created, and methods called on that object affect the attributes
// of the object attached to the model (as expected).

Species sp = model.createSpecies();
sp.setId('MySpecies');
@endcode
 * @endif
 *
 * The <code>create<span
 * class='placeholder-nospace'><em>Object</em></span>()</code> methods return a
 * pointer to the object created, but they also add the object to the
 * relevant list of object instances contained in the parent.  (These lists
 * become the <code>&lt;listOf<span
 * class='placeholder-nospace'><em>Object</em></span>s&gt;</code> elements in the
 * finished XML rendition of SBML.)  In the example above,
 * Model::createSpecies() adds the created species directly to the
 * <code>&lt;listOfSpeciesgt;</code> list in the model.  Subsequently,
 * methods called on the species change the species in the model (which is
 * what is expected in most situations).
 *
 * @section model-checking Consistency and adherence to SBML specifications
 *
 * To make it easier for applications to do whatever they need,
 * libSBML version @htmlinclude libsbml-version.html
 * is relatively lax when it comes to enforcing correctness and
 * completeness of models @em during model construction and editing.
 * Essentially, libSBML @em will @em not in most cases check automatically
 * that a model's components have valid attribute values, or that the
 * overall model is consistent and free of errors---even obvious errors
 * such as duplication of identifiers.  This allows applications great
 * leeway in how they build their models, but it means that software
 * authors must take deliberate steps to ensure that the model will be, in
 * the end, valid SBML.  These steps include such things as keeping track
 * of the identifiers used in a model, manually performing updates in
 * certain situations where an entity is referenced in more than one place
 * (e.g., a species that is referenced by multiple SpeciesReference
 * objects), and so on.
 *
 * That said, libSBML does provide powerful features for deliberately
 * performing validation of SBML when an application decides it is time to
 * do so.  The interfaces to these facilities are on the SBMLDocument
 * class, in the form of SBMLDocument::checkInternalConsistency() and
 * SBMLDocument::checkConsistency().  Please refer to the documentation for
 * SBMLDocument for more information about this.
 *
 * While applications may play fast and loose and live like free spirits
 * during the construction and editing of SBML models, they should always
 * make sure to call SBMLDocument::checkInternalConsistency() and/or
 * SBMLDocument::checkConsistency() before writing out the final version of
 * an SBML model.
 *
 *
 * @section model-l3-attrib Model attributes introduced in SBML Level&nbsp;3
 *
 * As mentioned above, the Model class has a number of optional attributes
 * in SBML Level&nbsp;3.  These are 'substanceUnits',
 * 'timeUnits', 'volumeUnits', 'areaUnits', 'lengthUnits', 'extentUnits',
 * and 'conversionFactor.  The following provide more information about
 * them.
 *
 * @subsection model-l3-substanceunits The 'substanceUnits' attribute
 *
 * The 'substanceUnits' attribute is used to specify the unit of
 * measurement associated with substance quantities of Species objects that
 * do not specify units explicitly.  If a given Species object definition
 * does not specify its unit of substance quantity via the 'substanceUnits'
 * attribute on the Species object instance, then that species inherits the
 * value of the Model 'substanceUnits' attribute.  If the Model does not
 * define a value for this attribute, then there is no unit to inherit, and
 * all species that do not specify individual 'substanceUnits' attribute
 * values then have <em>no</em> declared units for their quantities.  The
 * SBML Level&nbsp;3 specifications provide more details.
 *
 * Note that when the identifier of a species appears in a model's
 * mathematical expressions, the unit of measurement associated with that
 * identifier is <em>not solely determined</em> by setting 'substanceUnits'
 * on Model or Species.  Please see the discussion about units given in
 * the documentation for the Species class.
 *
 *
 * @subsection model-l3-timeunits The 'timeUnits' attribute
 *
 * The 'timeUnits' attribute on SBML Level&nbsp;3's Model object is used to
 * specify the unit in which time is measured in the model.  This attribute
 * on Model is the <em>only</em> way to specify a unit for time in a model.
 * It is a global attribute; time is measured in the model everywhere in
 * the same way.  This is particularly relevant to Reaction and RateRule
 * objects in a model: all Reaction and RateRule objects in SBML define
 * per-time values, and the unit of time is given by the 'timeUnits'
 * attribute on the Model object instance.  If the Model 'timeUnits'
 * attribute has no value, it means that the unit of time is not defined
 * for the model's reactions and rate rules.  Leaving it unspecified in an
 * SBML model does not result in an invalid model in SBML Level&nbsp;3;
 * however, as a matter of best practice, we strongly recommend that all
 * models specify units of measurement for time.
 *
 *
 * @subsection model-l3-voletc The 'volumeUnits', 'areaUnits', and 'lengthUnits' attributes
 *
 * The attributes 'volumeUnits', 'areaUnits' and 'lengthUnits' together are
 * used to set the units of measurements for the sizes of Compartment
 * objects in an SBML Level&nbsp;3 model when those objects do not
 * otherwise specify units.  The three attributes correspond to the most
 * common cases of compartment dimensions: 'volumeUnits' for compartments
 * having a 'spatialDimensions' attribute value of @c '3', 'areaUnits' for
 * compartments having a 'spatialDimensions' attribute value of @c '2', and
 * 'lengthUnits' for compartments having a 'spatialDimensions' attribute
 * value of @c '1'.  The attributes are not applicable to compartments
 * whose 'spatialDimensions' attribute values are @em not one of @c '1',
 * @c '2' or @c '3'.
 *
 * If a given Compartment object instance does not provide a value for its
 * 'units' attribute, then the unit of measurement of that compartment's
 * size is inherited from the value specified by the Model 'volumeUnits',
 * 'areaUnits' or 'lengthUnits' attribute, as appropriate based on the
 * Compartment object's 'spatialDimensions' attribute value.  If the Model
 * object does not define the relevant attribute, then there are no units
 * to inherit, and all Compartment objects that do not set a value for
 * their 'units' attribute then have <em>no</em> units associated with
 * their compartment sizes.
 *
 * The use of three separate attributes is a carry-over from SBML
 * Level&nbsp;2.  Note that it is entirely possible for a model to define a
 * value for two or more of the attributes 'volumeUnits', 'areaUnits' and
 * 'lengthUnits' simultaneously, because SBML models may contain
 * compartments with different numbers of dimensions.
 *
 *
 * @subsection model-l3-extentunits The 'extentUnits' attribute
 *
 * Reactions are processes that occur over time.  These processes involve
 * events of some sort, where a single ``reaction event'' is one in which
 * some set of entities (known as reactants, products and modifiers in
 * SBML) interact, once.  The <em>extent</em> of a reaction is a measure of
 * how many times the reaction has occurred, while the time derivative of
 * the extent gives the instantaneous rate at which the reaction is
 * occurring.  Thus, what is colloquially referred to as the 'rate of the
 * reaction' is in fact equal to the rate of change of reaction extent.
 *
 * In SBML Level&nbsp;3, the combination of 'extentUnits' and 'timeUnits'
 * defines the units of kinetic laws in SBML and establishes how the
 * numerical value of each KineticLaw object's mathematical formula is
 * meant to be interpreted in a model.  The units of the kinetic laws are
 * taken to be 'extentUnits' divided by 'timeUnits'.
 *
 * Note that this embodies an important principle in SBML Level&nbsp;3
 * models: <em>all reactions in an SBML model must have the same units</em>
 * for the rate of change of extent.  In other words, the units of all
 * reaction rates in the model <em>must be the same</em>.  There is only
 * one global value for 'extentUnits' and one global value for 'timeUnits'.
 *
 *
 * @subsection model-l3-convfactor The 'conversionFactor' attribute
 *
 * The attribute 'conversionFactor' in SBML Level&nbsp;3's Model object
 * defines a global value inherited by all Species object instances that do
 * not define separate values for their 'conversionFactor' attributes.  The
 * value of this attribute must refer to a Parameter object instance
 * defined in the model.  The Parameter object in question must be a
 * constant; ie it must have its 'constant' attribute value set to
 * @c 'true'.
 *
 * If a given Species object definition does not specify a conversion
 * factor via the 'conversionFactor' attribute on Species, then the species
 * inherits the conversion factor specified by the Model 'conversionFactor'
 * attribute.  If the Model does not define a value for this attribute,
 * then there is no conversion factor to inherit.  More information about
 * conversion factors is provided in the SBML Level&nbsp;3
 * specifications.
 */

public class Model : SBase {
	private HandleRef swigCPtr;
	
	internal Model(IntPtr cPtr, bool cMemoryOwn) : base(libsbmlPINVOKE.Model_SWIGUpcast(cPtr), cMemoryOwn)
	{
		//super(libsbmlPINVOKE.ModelUpcast(cPtr), cMemoryOwn);
		swigCPtr = new HandleRef(this, cPtr);
	}
	
	internal static HandleRef getCPtr(Model obj)
	{
		return (obj == null) ? new HandleRef(null, IntPtr.Zero) : obj.swigCPtr;
	}
	
	internal static HandleRef getCPtrAndDisown (Model obj)
	{
		HandleRef ptr = new HandleRef(null, IntPtr.Zero);
		
		if (obj != null)
		{
			ptr             = obj.swigCPtr;
			obj.swigCMemOwn = false;
		}
		
		return ptr;
	}

  ~Model() {
    Dispose();
  }

  public override void Dispose() {
    lock(this) {
      if (swigCPtr.Handle != global::System.IntPtr.Zero) {
        if (swigCMemOwn) {
          swigCMemOwn = false;
          libsbmlPINVOKE.delete_Model(swigCPtr);
        }
        swigCPtr = new global::System.Runtime.InteropServices.HandleRef(null, global::System.IntPtr.Zero);
      }
      global::System.GC.SuppressFinalize(this);
      base.Dispose();
    }
  }

  
/**
   * Creates a new Model using the given SBML @p level and @p version
   * values.
   *
   * @param level a long integer, the SBML Level to assign to this Model.
   *
   * @param version a long integer, the SBML Version to assign to this
   * Model.
   *
   *
 * @throws SBMLConstructorException
 * Thrown if the given @p level and @p version combination are invalid
 * or if this object is incompatible with the given level and version.
 *
 *
   *
   *
 * @note Attempting to add an object to an SBMLDocument having a different
 * combination of SBML Level, Version and XML namespaces than the object
 * itself will result in an error at the time a caller attempts to make the
 * addition.  A parent object must have compatible Level, Version and XML
 * namespaces.  (Strictly speaking, a parent may also have more XML
 * namespaces than a child, but the reverse is not permitted.)  The
 * restriction is necessary to ensure that an SBML model has a consistent
 * overall structure.  This requires callers to manage their objects
 * carefully, but the benefit is increased flexibility in how models can be
 * created by permitting callers to create objects bottom-up if desired.  In
 * situations where objects are not yet attached to parents (e.g.,
 * SBMLDocument), knowledge of the intented SBML Level and Version help
 * libSBML determine such things as whether it is valid to assign a
 * particular value to an attribute.
 *
 *
   */ public
 Model(long level, long version) : this(libsbmlPINVOKE.new_Model__SWIG_0(level, version), true) {
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

  
/**
   * Creates a new Model using the given SBMLNamespaces object
   * @p sbmlns.
   *
   *
 * 
 * The SBMLNamespaces object encapsulates SBML Level/Version/namespaces
 * information.  It is used to communicate the SBML Level, Version, and (in
 * Level&nbsp;3) packages used in addition to SBML Level&nbsp;3 Core.  A
 * common approach to using libSBML's SBMLNamespaces facilities is to create an
 * SBMLNamespaces object somewhere in a program once, then hand that object
 * as needed to object constructors that accept SBMLNamespaces as arguments.
 *
 *
   *
   * @param sbmlns an SBMLNamespaces object.
   *
   *
 * @throws SBMLConstructorException
 * Thrown if the given @p sbmlns is inconsistent or incompatible
 * with this object.
 *
 *
   *
   *
 * @note Attempting to add an object to an SBMLDocument having a different
 * combination of SBML Level, Version and XML namespaces than the object
 * itself will result in an error at the time a caller attempts to make the
 * addition.  A parent object must have compatible Level, Version and XML
 * namespaces.  (Strictly speaking, a parent may also have more XML
 * namespaces than a child, but the reverse is not permitted.)  The
 * restriction is necessary to ensure that an SBML model has a consistent
 * overall structure.  This requires callers to manage their objects
 * carefully, but the benefit is increased flexibility in how models can be
 * created by permitting callers to create objects bottom-up if desired.  In
 * situations where objects are not yet attached to parents (e.g.,
 * SBMLDocument), knowledge of the intented SBML Level and Version help
 * libSBML determine such things as whether it is valid to assign a
 * particular value to an attribute.
 *
 *
   */ public
 Model(SBMLNamespaces sbmlns) : this(libsbmlPINVOKE.new_Model__SWIG_1(SBMLNamespaces.getCPtr(sbmlns)), true) {
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

  
/**
   * Copy constructor; creates a (deep) copy of the given Model object.
   *
   * @param orig the object to copy.
   */ public
 Model(Model orig) : this(libsbmlPINVOKE.new_Model__SWIG_2(Model.getCPtr(orig)), true) {
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

  
/**
   * Creates and returns a deep copy of this Model object.
   *
   * @return the (deep) copy of this Model object.
   */ public new
 Model clone() {
    global::System.IntPtr cPtr = libsbmlPINVOKE.Model_clone(swigCPtr);
    Model ret = (cPtr == global::System.IntPtr.Zero) ? null : new Model(cPtr, true);
    return ret;
  }

  
/**
   * Returns the first child element found that has the given @p id.
   *
   * This operation searches the model-wide <code>SId</code> identifier
   * type namespace
   *
   * @param id string representing the id of the object to find.
   *
   * @return pointer to the first element found with the given @p id, or
   * @c null if no such object is found.
   */ public new
 SBase getElementBySId(string id) {
	SBase ret = (SBase) libsbml.DowncastSBase(libsbmlPINVOKE.Model_getElementBySId(swigCPtr, id), false);
	return ret;
}

  
/**
   * Returns the first child element it can find with the given @p metaid.
   *
   * @param metaid string representing the meta-identifier of the object to
   * find.
   *
   * @return pointer to the first element found with the given @p metaid, or
   * null if no such object is found.
   */ public new
 SBase getElementByMetaId(string metaid) {
	SBase ret = (SBase) libsbml.DowncastSBase(libsbmlPINVOKE.Model_getElementByMetaId(swigCPtr, metaid), false);
	return ret;
}

  
/**
   * Returns the value of the 'id' attribute of this Model.
   *
   * @note Because of the inconsistent behavior of this function with 
   * respect to assignments and rules, it is now recommended to
   * use the getIdAttribute() function instead.
   *
   *
 * 
 * The identifier given by an object's 'id' attribute value
 * is used to identify the object within the SBML model definition.
 * Other objects can refer to the component using this identifier.  The
 * data type of 'id' is always <code>SId</code> or a type derived
 * from that, such as <code>UnitSId</code>, depending on the object in 
 * question.  All data types are defined as follows:
 * <pre style='margin-left: 2em; border: none; font-weight: bold; color: black'>
 *   letter ::= 'a'..'z','A'..'Z'
 *   digit  ::= '0'..'9'
 *   idChar ::= letter | digit | '_'
 *   SId    ::= ( letter | '_' ) idChar*
 * </pre>
 *
 * The characters <code>(</code> and <code>)</code> are used for grouping, the
 * character <code>*</code> 'zero or more times', and the character
 * <code>|</code> indicates logical 'or'.  The equality of SBML identifiers is
 * determined by an exact character sequence match; i.e., comparisons must be
 * performed in a case-sensitive manner.  This applies to all uses of <code>SId</code>, 
 * <code>SIdRef</code>, and derived types.
 *
 * In SBML Level&nbsp;3 Version&nbsp;2, the 'id' and 'name' attributes were
 * moved to SBase directly, instead of being defined individually for many
 * (but not all) objects.  Libsbml has for a long time provided functions
 * defined on SBase itself to get, set, check, and unset those attributes, which 
 * would fail or otherwise return empty strings if executed on any object 
 * for which those attributes were not defined.  Now that all SBase objects 
 * define those attributes, those functions now succeed for any object with 
 * the appropriate level and version.
 *
 * The exception to this rule is that for InitialAssignment, EventAssignment, 
 * AssignmentRule, and RateRule objects, the getId() function and the isSetId() 
 * functions (though not the setId() or unsetId() functions) would instead 
 * reference the value of the 'variable' attribute (for the rules and event 
 * assignments) or the 'symbol' attribute (for initial assignments).  
 * The AlgebraicRule fell into this category as well, though because it 
 * contained neither a 'variable' nor a 'symbol' attribute, getId() would 
 * always return an empty string, and isSetId() would always return @c false.
 * For this reason, four new functions are now provided 
 * (getIdAttribute(), setIdAttribute(@if java String@endif), 
 * isSetIdAttribute(), and unsetIdAttribute()) that will always
 * act on the actual 'id' attribute, regardless of the object's type.  The
 * new functions should be used instead of the old ones unless the old behavior
 * is somehow necessary.
 * 
 * Regardless of the level and version of the SBML, these functions allow
 * client applications to use more generalized code in some situations 
 * (for instance, when manipulating objects that are all known to have 
 * identifiers).  If the object in question does not posess an 'id' attribute 
 * according to the SBML specification for the Level and Version in use,
 * libSBML will not allow the identifier to be set, nor will it read or 
 * write 'id' attributes for those objects.
 *
 *
   *
   * @return the id of this Model.
   *
   * @see getIdAttribute()
   * @see setIdAttribute(string sid)
   * @see isSetIdAttribute()
   * @see unsetIdAttribute()
   */ public new
 string getId() {
    string ret = libsbmlPINVOKE.Model_getId(swigCPtr);
    return ret;
  }

  
/**
   * Returns the value of the 'name' attribute of this Model object.
   *
   *
 *
 * 
 * In SBML Level&nbsp;3 Version&nbsp;2, the 'id' and 'name' attributes were
 * moved to SBase directly, instead of being defined individually for many
 * (but not all) objects.  Libsbml has for a long time provided functions
 * defined on SBase itself to get, set, and unset those attributes, which 
 * would fail or otherwise return empty strings if executed on any object 
 * for which those attributes were not defined.  Now that all SBase objects 
 * define those attributes, those functions now succeed for any object with 
 * the appropriate level and version.
 *
 * The 'name' attribute is
 * optional and is not intended to be used for cross-referencing purposes
 * within a model.  Its purpose instead is to provide a human-readable
 * label for the component.  The data type of 'name' is the type
 * <code>string</code> defined in XML Schema.  SBML imposes no
 * restrictions as to the content of 'name' attributes beyond those
 * restrictions defined by the <code>string</code> type in XML Schema.
 *
 * The recommended practice for handling 'name' is as follows.  If a
 * software tool has the capability for displaying the content of 'name'
 * attributes, it should display this content to the user as a
 * component's label instead of the component's 'id'.  If the user
 * interface does not have this capability (e.g., because it cannot
 * display or use special characters in symbol names), or if the 'name'
 * attribute is missing on a given component, then the user interface
 * should display the value of the 'id' attribute instead.  (Script
 * language interpreters are especially likely to display 'id' instead of
 * 'name'.)
 * 
 * As a consequence of the above, authors of systems that automatically
 * generate the values of 'id' attributes should be aware some systems
 * may display the 'id''s to the user.  Authors therefore may wish to
 * take some care to have their software create 'id' values that are: (a)
 * reasonably easy for humans to type and read; and (b) likely to be
 * meaningful, for example by making the 'id' attribute be an abbreviated
 * form of the name attribute value.
 * 
 * An additional point worth mentioning is although there are
 * restrictions on the uniqueness of 'id' values, there are no
 * restrictions on the uniqueness of 'name' values in a model.  This
 * allows software applications leeway in assigning component identifiers.
 *
 * Regardless of the level and version of the SBML, these functions allow
 * client applications to use more generalized code in some situations 
 * (for instance, when manipulating objects that are all known to have 
 * names).  If the object in question does not posess a 'name' attribute 
 * according to the SBML specification for the Level and Version in use,
 * libSBML will not allow the name to be set, nor will it read or 
 * write 'name' attributes for those objects.
 *
 *
 *
 * @return the name of this SBML object, or the empty string if not set or unsettable.
 *
 * @see getIdAttribute()
 * @see isSetName()
 * @see setName(string sid)
 * @see unsetName()
 * 
 *
   */ public new
 string getName() {
    string ret = libsbmlPINVOKE.Model_getName(swigCPtr);
    return ret;
  }

  
/**
   * Returns the value of the 'substanceUnits' attribute of this Model.
   *
   * @return the substanceUnits of this Model.
   *
   * @note The 'substanceUnits' attribute is available in
   * SBML Level&nbsp;3 but is not present on Model in lower Levels of SBML.
   */ public
 string getSubstanceUnits() {
    string ret = libsbmlPINVOKE.Model_getSubstanceUnits(swigCPtr);
    return ret;
  }

  
/**
   * Returns the value of the 'timeUnits' attribute of this Model.
   *
   * @return the timeUnits of this Model.
   *
   * @note The 'timeUnits' attribute is available in 
   * SBML Level&nbsp;3 but is not present on Model in lower Levels of SBML.
   */ public
 string getTimeUnits() {
    string ret = libsbmlPINVOKE.Model_getTimeUnits(swigCPtr);
    return ret;
  }

  
/**
   * Returns the value of the 'volumeUnits' attribute of this Model.
   *
   * @return the volumeUnits of this Model.
   *
   * @note The 'volumeUnits' attribute is available in 
   * SBML Level&nbsp;3 but is not present on Model in lower Levels of SBML.
   */ public
 string getVolumeUnits() {
    string ret = libsbmlPINVOKE.Model_getVolumeUnits(swigCPtr);
    return ret;
  }

  
/**
   * Returns the value of the 'areaUnits' attribute of this Model.
   *
   * @return the areaUnits of this Model.
   *
   * @note The 'areaUnits' attribute is available in 
   * SBML Level&nbsp;3 but is not present on Model in lower Levels of SBML.
   */ public
 string getAreaUnits() {
    string ret = libsbmlPINVOKE.Model_getAreaUnits(swigCPtr);
    return ret;
  }

  
/**
   * Returns the value of the 'lengthUnits' attribute of this Model.
   *
   * @return the lengthUnits of this Model.
   *
   * @note The 'lengthUnits' attribute is available in 
   * SBML Level&nbsp;3 but is not present on Model in lower Levels of SBML.
   */ public
 string getLengthUnits() {
    string ret = libsbmlPINVOKE.Model_getLengthUnits(swigCPtr);
    return ret;
  }

  
/**
   * Returns the value of the 'extentUnits' attribute of this Model.
   *
   * @return the extentUnits of this Model.
   *
   * @note The 'extentUnits' attribute is available in 
   * SBML Level&nbsp;3 but is not present on Model in lower Levels of SBML.
   */ public
 string getExtentUnits() {
    string ret = libsbmlPINVOKE.Model_getExtentUnits(swigCPtr);
    return ret;
  }

  
/**
   * Returns the value of the 'conversionFactor' attribute of this Model.
   *
   * @return the conversionFactor of this Model.
   *
   * @note The 'conversionFactor' attribute is available in 
   * SBML Level&nbsp;3 but is not present on Model in lower Levels of SBML.
   */ public
 string getConversionFactor() {
    string ret = libsbmlPINVOKE.Model_getConversionFactor(swigCPtr);
    return ret;
  }

  
/**
   * Predicate returning @c true if this
   * Model's 'id' attribute is set.
   *
   *
 * @note Because of the inconsistent behavior of this function with 
 * respect to assignments and rules, it is now recommended to
 * use the isSetIdAttribute() function instead.
 *
 *
 * 
 * The identifier given by an object's 'id' attribute value
 * is used to identify the object within the SBML model definition.
 * Other objects can refer to the component using this identifier.  The
 * data type of 'id' is always <code>SId</code> or a type derived
 * from that, such as <code>UnitSId</code>, depending on the object in 
 * question.  All data types are defined as follows:
 * <pre style='margin-left: 2em; border: none; font-weight: bold; color: black'>
 *   letter ::= 'a'..'z','A'..'Z'
 *   digit  ::= '0'..'9'
 *   idChar ::= letter | digit | '_'
 *   SId    ::= ( letter | '_' ) idChar*
 * </pre>
 *
 * The characters <code>(</code> and <code>)</code> are used for grouping, the
 * character <code>*</code> 'zero or more times', and the character
 * <code>|</code> indicates logical 'or'.  The equality of SBML identifiers is
 * determined by an exact character sequence match; i.e., comparisons must be
 * performed in a case-sensitive manner.  This applies to all uses of <code>SId</code>, 
 * <code>SIdRef</code>, and derived types.
 *
 * In SBML Level&nbsp;3 Version&nbsp;2, the 'id' and 'name' attributes were
 * moved to SBase directly, instead of being defined individually for many
 * (but not all) objects.  Libsbml has for a long time provided functions
 * defined on SBase itself to get, set, check, and unset those attributes, which 
 * would fail or otherwise return empty strings if executed on any object 
 * for which those attributes were not defined.  Now that all SBase objects 
 * define those attributes, those functions now succeed for any object with 
 * the appropriate level and version.
 *
 * The exception to this rule is that for InitialAssignment, EventAssignment, 
 * AssignmentRule, and RateRule objects, the getId() function and the isSetId() 
 * functions (though not the setId() or unsetId() functions) would instead 
 * reference the value of the 'variable' attribute (for the rules and event 
 * assignments) or the 'symbol' attribute (for initial assignments).  
 * The AlgebraicRule fell into this category as well, though because it 
 * contained neither a 'variable' nor a 'symbol' attribute, getId() would 
 * always return an empty string, and isSetId() would always return @c false.
 * For this reason, four new functions are now provided 
 * (getIdAttribute(), setIdAttribute(@if java String@endif), 
 * isSetIdAttribute(), and unsetIdAttribute()) that will always
 * act on the actual 'id' attribute, regardless of the object's type.  The
 * new functions should be used instead of the old ones unless the old behavior
 * is somehow necessary.
 * 
 * Regardless of the level and version of the SBML, these functions allow
 * client applications to use more generalized code in some situations 
 * (for instance, when manipulating objects that are all known to have 
 * identifiers).  If the object in question does not posess an 'id' attribute 
 * according to the SBML specification for the Level and Version in use,
 * libSBML will not allow the identifier to be set, nor will it read or 
 * write 'id' attributes for those objects.
 *
 *
 * 
 * @return @c true if the 'id' attribute of this SBML object is
 * set, @c false otherwise.
 *
 * @see getIdAttribute()
 * @see setIdAttribute(string sid)
 * @see unsetIdAttribute()
 * @see isSetIdAttribute()
 *
 *
   */ public new
 bool isSetId() {
    bool ret = libsbmlPINVOKE.Model_isSetId(swigCPtr);
    return ret;
  }

  
/**
   * Predicate returning @c true if this
   * Model's 'name' attribute is set.
   *
   *
 *
 * 
 * In SBML Level&nbsp;3 Version&nbsp;2, the 'id' and 'name' attributes were
 * moved to SBase directly, instead of being defined individually for many
 * (but not all) objects.  Libsbml has for a long time provided functions
 * defined on SBase itself to get, set, and unset those attributes, which 
 * would fail or otherwise return empty strings if executed on any object 
 * for which those attributes were not defined.  Now that all SBase objects 
 * define those attributes, those functions now succeed for any object with 
 * the appropriate level and version.
 *
 * The 'name' attribute is
 * optional and is not intended to be used for cross-referencing purposes
 * within a model.  Its purpose instead is to provide a human-readable
 * label for the component.  The data type of 'name' is the type
 * <code>string</code> defined in XML Schema.  SBML imposes no
 * restrictions as to the content of 'name' attributes beyond those
 * restrictions defined by the <code>string</code> type in XML Schema.
 *
 * The recommended practice for handling 'name' is as follows.  If a
 * software tool has the capability for displaying the content of 'name'
 * attributes, it should display this content to the user as a
 * component's label instead of the component's 'id'.  If the user
 * interface does not have this capability (e.g., because it cannot
 * display or use special characters in symbol names), or if the 'name'
 * attribute is missing on a given component, then the user interface
 * should display the value of the 'id' attribute instead.  (Script
 * language interpreters are especially likely to display 'id' instead of
 * 'name'.)
 * 
 * As a consequence of the above, authors of systems that automatically
 * generate the values of 'id' attributes should be aware some systems
 * may display the 'id''s to the user.  Authors therefore may wish to
 * take some care to have their software create 'id' values that are: (a)
 * reasonably easy for humans to type and read; and (b) likely to be
 * meaningful, for example by making the 'id' attribute be an abbreviated
 * form of the name attribute value.
 * 
 * An additional point worth mentioning is although there are
 * restrictions on the uniqueness of 'id' values, there are no
 * restrictions on the uniqueness of 'name' values in a model.  This
 * allows software applications leeway in assigning component identifiers.
 *
 * Regardless of the level and version of the SBML, these functions allow
 * client applications to use more generalized code in some situations 
 * (for instance, when manipulating objects that are all known to have 
 * names).  If the object in question does not posess a 'name' attribute 
 * according to the SBML specification for the Level and Version in use,
 * libSBML will not allow the name to be set, nor will it read or 
 * write 'name' attributes for those objects.
 *
 *
 * 
 * @return @c true if the 'name' attribute of this SBML object is
 * set, @c false otherwise.
 *
 * @see getName()
 * @see setName(string sid)
 * @see unsetName()
 *
 *
   */ public new
 bool isSetName() {
    bool ret = libsbmlPINVOKE.Model_isSetName(swigCPtr);
    return ret;
  }

  
/**
   * Predicate returning @c true if this
   * Model's 'substanceUnits' attribute is set.
   *
   * @return @c true if the 'substanceUnits' attribute of this Model is
   * set, @c false otherwise.
   *
   * @note The 'substanceUnits' attribute is available in 
   * SBML Level&nbsp;3 but is not present on Model in lower Levels of SBML.
   */ public
 bool isSetSubstanceUnits() {
    bool ret = libsbmlPINVOKE.Model_isSetSubstanceUnits(swigCPtr);
    return ret;
  }

  
/**
   * Predicate returning @c true if this
   * Model's 'timeUnits' attribute is set.
   *
   * @return @c true if the 'timeUnits' attribute of this Model is
   * set, @c false otherwise.
   *
   * @note The 'substanceUnits' attribute is available in 
   * SBML Level&nbsp;3 but is not present on Model in lower Levels of SBML.
   */ public
 bool isSetTimeUnits() {
    bool ret = libsbmlPINVOKE.Model_isSetTimeUnits(swigCPtr);
    return ret;
  }

  
/**
   * Predicate returning @c true if this
   * Model's 'volumeUnits' attribute is set.
   *
   * @return @c true if the 'volumeUnits' attribute of this Model is
   * set, @c false otherwise.
   *
   * @note The 'volumeUnits' attribute is available in 
   * SBML Level&nbsp;3 but is not present on Model in lower Levels of SBML.
   */ public
 bool isSetVolumeUnits() {
    bool ret = libsbmlPINVOKE.Model_isSetVolumeUnits(swigCPtr);
    return ret;
  }

  
/**
   * Predicate returning @c true if this
   * Model's 'areaUnits' attribute is set.
   *
   * @return @c true if the 'areaUnits' attribute of this Model is
   * set, @c false otherwise.
   *
   * @note The 'areaUnits' attribute is available in 
   * SBML Level&nbsp;3 but is not present on Model in lower Levels of SBML.
   */ public
 bool isSetAreaUnits() {
    bool ret = libsbmlPINVOKE.Model_isSetAreaUnits(swigCPtr);
    return ret;
  }

  
/**
   * Predicate returning @c true if this
   * Model's 'lengthUnits' attribute is set.
   *
   * @return @c true if the 'lengthUnits' attribute of this Model is
   * set, @c false otherwise.
   *
   * @note The 'lengthUnits' attribute is available in 
   * SBML Level&nbsp;3 but is not present on Model in lower Levels of SBML.
   */ public
 bool isSetLengthUnits() {
    bool ret = libsbmlPINVOKE.Model_isSetLengthUnits(swigCPtr);
    return ret;
  }

  
/**
   * Predicate returning @c true if this
   * Model's 'extentUnits' attribute is set.
   *
   * @return @c true if the 'extentUnits' attribute of this Model is
   * set, @c false otherwise.
   *
   * @note The 'extentUnits' attribute is available in 
   * SBML Level&nbsp;3 but is not present on Model in lower Levels of SBML.
   */ public
 bool isSetExtentUnits() {
    bool ret = libsbmlPINVOKE.Model_isSetExtentUnits(swigCPtr);
    return ret;
  }

  
/**
   * Predicate returning @c true if this
   * Model's 'conversionFactor' attribute is set.
   *
   * @return @c true if the 'conversionFactor' attribute of this Model is
   * set, @c false otherwise.
   *
   * @note The 'conversionFactor' attribute is available in 
   * SBML Level&nbsp;3 but is not present on Model in lower Levels of SBML.
   */ public
 bool isSetConversionFactor() {
    bool ret = libsbmlPINVOKE.Model_isSetConversionFactor(swigCPtr);
    return ret;
  }

  
/**
   * Sets the value of the 'id' attribute of this Model.
   *
   *
 * 
 * The string @p sid is copied.
 *
 *
 * 
 * The identifier given by an object's 'id' attribute value
 * is used to identify the object within the SBML model definition.
 * Other objects can refer to the component using this identifier.  The
 * data type of 'id' is always <code>SId</code> or a type derived
 * from that, such as <code>UnitSId</code>, depending on the object in 
 * question.  All data types are defined as follows:
 * <pre style='margin-left: 2em; border: none; font-weight: bold; color: black'>
 *   letter ::= 'a'..'z','A'..'Z'
 *   digit  ::= '0'..'9'
 *   idChar ::= letter | digit | '_'
 *   SId    ::= ( letter | '_' ) idChar*
 * </pre>
 *
 * The characters <code>(</code> and <code>)</code> are used for grouping, the
 * character <code>*</code> 'zero or more times', and the character
 * <code>|</code> indicates logical 'or'.  The equality of SBML identifiers is
 * determined by an exact character sequence match; i.e., comparisons must be
 * performed in a case-sensitive manner.  This applies to all uses of <code>SId</code>, 
 * <code>SIdRef</code>, and derived types.
 *
 * In SBML Level&nbsp;3 Version&nbsp;2, the 'id' and 'name' attributes were
 * moved to SBase directly, instead of being defined individually for many
 * (but not all) objects.  Libsbml has for a long time provided functions
 * defined on SBase itself to get, set, check, and unset those attributes, which 
 * would fail or otherwise return empty strings if executed on any object 
 * for which those attributes were not defined.  Now that all SBase objects 
 * define those attributes, those functions now succeed for any object with 
 * the appropriate level and version.
 *
 * The exception to this rule is that for InitialAssignment, EventAssignment, 
 * AssignmentRule, and RateRule objects, the getId() function and the isSetId() 
 * functions (though not the setId() or unsetId() functions) would instead 
 * reference the value of the 'variable' attribute (for the rules and event 
 * assignments) or the 'symbol' attribute (for initial assignments).  
 * The AlgebraicRule fell into this category as well, though because it 
 * contained neither a 'variable' nor a 'symbol' attribute, getId() would 
 * always return an empty string, and isSetId() would always return @c false.
 * For this reason, four new functions are now provided 
 * (getIdAttribute(), setIdAttribute(@if java String@endif), 
 * isSetIdAttribute(), and unsetIdAttribute()) that will always
 * act on the actual 'id' attribute, regardless of the object's type.  The
 * new functions should be used instead of the old ones unless the old behavior
 * is somehow necessary.
 * 
 * Regardless of the level and version of the SBML, these functions allow
 * client applications to use more generalized code in some situations 
 * (for instance, when manipulating objects that are all known to have 
 * identifiers).  If the object in question does not posess an 'id' attribute 
 * according to the SBML specification for the Level and Version in use,
 * libSBML will not allow the identifier to be set, nor will it read or 
 * write 'id' attributes for those objects.
 *
 *
 * 
 * @param sid the string to use as the identifier of this object.
 *
 *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
 * @li @link libsbml#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE@endlink
 * @li @link libsbml#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink
 *
 * @see getIdAttribute()
 * @see setIdAttribute(string sid)
 * @see isSetIdAttribute()
 * @see unsetIdAttribute()
 * 
 *
   */ public new
 int setId(string sid) {
    int ret = libsbmlPINVOKE.Model_setId(swigCPtr, sid);
    return ret;
  }

  
/**
   * Sets the value of the 'name' attribute of this Model.
   *
   *
 * 
 *
 * The string in @p name is copied.
 *
 * @param name the new name for the SBML object.
 *
 *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
 * @li @link libsbml#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE@endlink
 *
 *
   */ public new
 int setName(string name) {
    int ret = libsbmlPINVOKE.Model_setName(swigCPtr, name);
    return ret;
  }

  
/**
   * Sets the value of the 'substanceUnits' attribute of this Model.
   *
   * The string in @p units is copied.
   *
   * @param units the new substanceUnits for the Model.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink
   * @li @link libsbml#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE@endlink
   *
   * @note The 'substanceUnits' attribute is available in 
   * SBML Level&nbsp;3 but is not present on Model in lower Levels of SBML.
   */ public
 int setSubstanceUnits(string units) {
    int ret = libsbmlPINVOKE.Model_setSubstanceUnits(swigCPtr, units);
    return ret;
  }

  
/**
   * Sets the value of the 'timeUnits' attribute of this Model.
   *
   * The string in @p units is copied.
   *
   * @param units the new timeUnits for the Model.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink
   * @li @link libsbml#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE@endlink
   *
   * @note The 'timeUnits' attribute is available in 
   * SBML Level&nbsp;3 but is not present on Model in lower Levels of SBML.
   */ public
 int setTimeUnits(string units) {
    int ret = libsbmlPINVOKE.Model_setTimeUnits(swigCPtr, units);
    return ret;
  }

  
/**
   * Sets the value of the 'volumeUnits' attribute of this Model.
   *
   * The string in @p units is copied.
   *
   * @param units the new volumeUnits for the Model.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink
   * @li @link libsbml#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE@endlink
   *
   * @note The 'volumeUnits' attribute is available in 
   * SBML Level&nbsp;3 but is not present on Model in lower Levels of SBML.
   */ public
 int setVolumeUnits(string units) {
    int ret = libsbmlPINVOKE.Model_setVolumeUnits(swigCPtr, units);
    return ret;
  }

  
/**
   * Sets the value of the 'areaUnits' attribute of this Model.
   *
   * The string in @p units is copied.
   *
   * @param units the new areaUnits for the Model.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink
   * @li @link libsbml#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE@endlink
   *
   * @note The 'areaUnits' attribute is available in 
   * SBML Level&nbsp;3 but is not present on Model in lower Levels of SBML.
   */ public
 int setAreaUnits(string units) {
    int ret = libsbmlPINVOKE.Model_setAreaUnits(swigCPtr, units);
    return ret;
  }

  
/**
   * Sets the value of the 'lengthUnits' attribute of this Model.
   *
   * The string in @p units is copied.
   *
   * @param units the new lengthUnits for the Model.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink
   * @li @link libsbml#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE@endlink
   *
   * @note The 'lengthUnits' attribute is available in 
   * SBML Level&nbsp;3 but is not present on Model in lower Levels of SBML.
   */ public
 int setLengthUnits(string units) {
    int ret = libsbmlPINVOKE.Model_setLengthUnits(swigCPtr, units);
    return ret;
  }

  
/**
   * Sets the value of the 'extentUnits' attribute of this Model.
   *
   * The string in @p units is copied.
   *
   * @param units the new extentUnits for the Model.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink
   * @li @link libsbml#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE@endlink
   *
   * @note The 'extentUnits' attribute is available in 
   * SBML Level&nbsp;3 but is not present on Model in lower Levels of SBML.
   */ public
 int setExtentUnits(string units) {
    int ret = libsbmlPINVOKE.Model_setExtentUnits(swigCPtr, units);
    return ret;
  }

  
/**
   * Sets the value of the 'conversionFactor' attribute of this Model.
   *
   * The string in @p units is copied.
   *
   * @param units the new conversionFactor for the Model.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink
   * @li @link libsbml#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE@endlink
   *
   * @note The 'conversionFactor' attribute is available in 
   * SBML Level&nbsp;3 but is not present on Model in lower Levels of SBML.
   */ public
 int setConversionFactor(string units) {
    int ret = libsbmlPINVOKE.Model_setConversionFactor(swigCPtr, units);
    return ret;
  }

  
/**
   * Unsets the value of the 'id' attribute of this Model.
   *
   *
 *
 * 
 * The identifier given by an object's 'id' attribute value
 * is used to identify the object within the SBML model definition.
 * Other objects can refer to the component using this identifier.  The
 * data type of 'id' is always <code>SId</code> or a type derived
 * from that, such as <code>UnitSId</code>, depending on the object in 
 * question.  All data types are defined as follows:
 * <pre style='margin-left: 2em; border: none; font-weight: bold; color: black'>
 *   letter ::= 'a'..'z','A'..'Z'
 *   digit  ::= '0'..'9'
 *   idChar ::= letter | digit | '_'
 *   SId    ::= ( letter | '_' ) idChar*
 * </pre>
 *
 * The characters <code>(</code> and <code>)</code> are used for grouping, the
 * character <code>*</code> 'zero or more times', and the character
 * <code>|</code> indicates logical 'or'.  The equality of SBML identifiers is
 * determined by an exact character sequence match; i.e., comparisons must be
 * performed in a case-sensitive manner.  This applies to all uses of <code>SId</code>, 
 * <code>SIdRef</code>, and derived types.
 *
 * In SBML Level&nbsp;3 Version&nbsp;2, the 'id' and 'name' attributes were
 * moved to SBase directly, instead of being defined individually for many
 * (but not all) objects.  Libsbml has for a long time provided functions
 * defined on SBase itself to get, set, check, and unset those attributes, which 
 * would fail or otherwise return empty strings if executed on any object 
 * for which those attributes were not defined.  Now that all SBase objects 
 * define those attributes, those functions now succeed for any object with 
 * the appropriate level and version.
 *
 * The exception to this rule is that for InitialAssignment, EventAssignment, 
 * AssignmentRule, and RateRule objects, the getId() function and the isSetId() 
 * functions (though not the setId() or unsetId() functions) would instead 
 * reference the value of the 'variable' attribute (for the rules and event 
 * assignments) or the 'symbol' attribute (for initial assignments).  
 * The AlgebraicRule fell into this category as well, though because it 
 * contained neither a 'variable' nor a 'symbol' attribute, getId() would 
 * always return an empty string, and isSetId() would always return @c false.
 * For this reason, four new functions are now provided 
 * (getIdAttribute(), setIdAttribute(@if java String@endif), 
 * isSetIdAttribute(), and unsetIdAttribute()) that will always
 * act on the actual 'id' attribute, regardless of the object's type.  The
 * new functions should be used instead of the old ones unless the old behavior
 * is somehow necessary.
 * 
 * Regardless of the level and version of the SBML, these functions allow
 * client applications to use more generalized code in some situations 
 * (for instance, when manipulating objects that are all known to have 
 * identifiers).  If the object in question does not posess an 'id' attribute 
 * according to the SBML specification for the Level and Version in use,
 * libSBML will not allow the identifier to be set, nor will it read or 
 * write 'id' attributes for those objects.
 *
 *
 * 
 *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
 * @li @link libsbml#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
 *
 * @see getIdAttribute()
 * @see setIdAttribute(string sid)
 * @see isSetIdAttribute()
 * @see unsetIdAttribute()
 *
 *
   */ public new
 int unsetId() {
    int ret = libsbmlPINVOKE.Model_unsetId(swigCPtr);
    return ret;
  }

  
/**
   * Unsets the value of the 'name' attribute of this Model.
   *
   *
 *
 * 
 * In SBML Level&nbsp;3 Version&nbsp;2, the 'id' and 'name' attributes were
 * moved to SBase directly, instead of being defined individually for many
 * (but not all) objects.  Libsbml has for a long time provided functions
 * defined on SBase itself to get, set, and unset those attributes, which 
 * would fail or otherwise return empty strings if executed on any object 
 * for which those attributes were not defined.  Now that all SBase objects 
 * define those attributes, those functions now succeed for any object with 
 * the appropriate level and version.
 *
 * The 'name' attribute is
 * optional and is not intended to be used for cross-referencing purposes
 * within a model.  Its purpose instead is to provide a human-readable
 * label for the component.  The data type of 'name' is the type
 * <code>string</code> defined in XML Schema.  SBML imposes no
 * restrictions as to the content of 'name' attributes beyond those
 * restrictions defined by the <code>string</code> type in XML Schema.
 *
 * The recommended practice for handling 'name' is as follows.  If a
 * software tool has the capability for displaying the content of 'name'
 * attributes, it should display this content to the user as a
 * component's label instead of the component's 'id'.  If the user
 * interface does not have this capability (e.g., because it cannot
 * display or use special characters in symbol names), or if the 'name'
 * attribute is missing on a given component, then the user interface
 * should display the value of the 'id' attribute instead.  (Script
 * language interpreters are especially likely to display 'id' instead of
 * 'name'.)
 * 
 * As a consequence of the above, authors of systems that automatically
 * generate the values of 'id' attributes should be aware some systems
 * may display the 'id''s to the user.  Authors therefore may wish to
 * take some care to have their software create 'id' values that are: (a)
 * reasonably easy for humans to type and read; and (b) likely to be
 * meaningful, for example by making the 'id' attribute be an abbreviated
 * form of the name attribute value.
 * 
 * An additional point worth mentioning is although there are
 * restrictions on the uniqueness of 'id' values, there are no
 * restrictions on the uniqueness of 'name' values in a model.  This
 * allows software applications leeway in assigning component identifiers.
 *
 * Regardless of the level and version of the SBML, these functions allow
 * client applications to use more generalized code in some situations 
 * (for instance, when manipulating objects that are all known to have 
 * names).  If the object in question does not posess a 'name' attribute 
 * according to the SBML specification for the Level and Version in use,
 * libSBML will not allow the name to be set, nor will it read or 
 * write 'name' attributes for those objects.
 *
 *
 * 
 *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
 * @li @link libsbml#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
 *
 * @see getName()
 * @see setName(string sid)
 * @see isSetName()
 *
 *
   */ public new
 int unsetName() {
    int ret = libsbmlPINVOKE.Model_unsetName(swigCPtr);
    return ret;
  }

  
/**
   * Unsets the value of the 'substanceUnits' attribute of this Model.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
   *
   * @note The 'substanceUnits' attribute is available in 
   * SBML Level&nbsp;3 but is not present on Model in lower Levels of SBML.
   */ public
 int unsetSubstanceUnits() {
    int ret = libsbmlPINVOKE.Model_unsetSubstanceUnits(swigCPtr);
    return ret;
  }

  
/**
   * Unsets the value of the 'timeUnits' attribute of this Model.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
   *
   * @note The 'timeUnits' attribute is available in 
   * SBML Level&nbsp;3 but is not present on Model in lower Levels of SBML.
   */ public
 int unsetTimeUnits() {
    int ret = libsbmlPINVOKE.Model_unsetTimeUnits(swigCPtr);
    return ret;
  }

  
/**
   * Unsets the value of the 'volumeUnits' attribute of this Model.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
   *
   * @note The 'volumeUnits' attribute is available in 
   * SBML Level&nbsp;3 but is not present on Model in lower Levels of SBML.
   */ public
 int unsetVolumeUnits() {
    int ret = libsbmlPINVOKE.Model_unsetVolumeUnits(swigCPtr);
    return ret;
  }

  
/**
   * Unsets the value of the 'areaUnits' attribute of this Model.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink
   * @li @link libsbml#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
   *
   * @note The 'areaUnits' attribute is available in 
   * SBML Level&nbsp;3 but is not present on Model in lower Levels of SBML.
   */ public
 int unsetAreaUnits() {
    int ret = libsbmlPINVOKE.Model_unsetAreaUnits(swigCPtr);
    return ret;
  }

  
/**
   * Unsets the value of the 'lengthUnits' attribute of this Model.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink
   * @li @link libsbml#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
   *
   * @note The 'lengthUnits' attribute is available in 
   * SBML Level&nbsp;3 but is not present on Model in lower Levels of SBML.
   */ public
 int unsetLengthUnits() {
    int ret = libsbmlPINVOKE.Model_unsetLengthUnits(swigCPtr);
    return ret;
  }

  
/**
   * Unsets the value of the 'extentUnits' attribute of this Model.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink
   * @li @link libsbml#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
   *
   * @note The 'extentUnits' attribute is available in 
   * SBML Level&nbsp;3 but is not present on Model in lower Levels of SBML.
   */ public
 int unsetExtentUnits() {
    int ret = libsbmlPINVOKE.Model_unsetExtentUnits(swigCPtr);
    return ret;
  }

  
/**
   * Unsets the value of the 'conversionFactor' attribute of this Model.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink
   * @li @link libsbml#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
   *
   * @note The 'conversionFactor' attribute is available in 
   * SBML Level&nbsp;3 but is not present on Model in lower Levels of SBML.
   */ public
 int unsetConversionFactor() {
    int ret = libsbmlPINVOKE.Model_unsetConversionFactor(swigCPtr);
    return ret;
  }

  
/**
   * Adds a copy of the given FunctionDefinition object to this Model.
   *
   * @param fd the FunctionDefinition to add.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_LEVEL_MISMATCH LIBSBML_LEVEL_MISMATCH@endlink
   * @li @link libsbml#LIBSBML_VERSION_MISMATCH LIBSBML_VERSION_MISMATCH@endlink
   * @li @link libsbml#LIBSBML_DUPLICATE_OBJECT_ID LIBSBML_DUPLICATE_OBJECT_ID@endlink
   * @li @link libsbml#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT@endlink
   * @li @link libsbml#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
   *
   *
 * @note This method should be used with some caution.  The fact that this
 * method @em copies the object passed to it means that the caller will be
 * left holding a physically different object instance than the one contained
 * inside this object.  Changes made to the original object instance (such as
 * resetting attribute values) will <em>not affect the instance in this
 * object</em>.  In addition, the caller should make sure to free the
 * original object if it is no longer being used, or else a memory leak will
 * result.  Please see other methods on this class (particularly a
 * corresponding method whose name begins with the word <code>create</code>)
 * for alternatives that do not lead to these issues.
 *
 * 
   *
   * @see createFunctionDefinition()
   */ public
 int addFunctionDefinition(FunctionDefinition fd) {
    int ret = libsbmlPINVOKE.Model_addFunctionDefinition(swigCPtr, FunctionDefinition.getCPtr(fd));
    return ret;
  }

  
/**
   * Adds a copy of the given UnitDefinition object to this Model.
   *
   * @param ud the UnitDefinition object to add.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_LEVEL_MISMATCH LIBSBML_LEVEL_MISMATCH@endlink
   * @li @link libsbml#LIBSBML_VERSION_MISMATCH LIBSBML_VERSION_MISMATCH@endlink
   * @li @link libsbml#LIBSBML_DUPLICATE_OBJECT_ID LIBSBML_DUPLICATE_OBJECT_ID@endlink
   * @li @link libsbml#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT@endlink
   * @li @link libsbml#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
   *
   *
 * @note This method should be used with some caution.  The fact that this
 * method @em copies the object passed to it means that the caller will be
 * left holding a physically different object instance than the one contained
 * inside this object.  Changes made to the original object instance (such as
 * resetting attribute values) will <em>not affect the instance in this
 * object</em>.  In addition, the caller should make sure to free the
 * original object if it is no longer being used, or else a memory leak will
 * result.  Please see other methods on this class (particularly a
 * corresponding method whose name begins with the word <code>create</code>)
 * for alternatives that do not lead to these issues.
 *
 * 
   *
   * @see createUnitDefinition()
   */ public
 int addUnitDefinition(UnitDefinition ud) {
    int ret = libsbmlPINVOKE.Model_addUnitDefinition(swigCPtr, UnitDefinition.getCPtr(ud));
    return ret;
  }

  
/**
   * Adds a copy of the given CompartmentType object to this Model.
   *
   * @param ct the CompartmentType object to add.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_LEVEL_MISMATCH LIBSBML_LEVEL_MISMATCH@endlink
   * @li @link libsbml#LIBSBML_VERSION_MISMATCH LIBSBML_VERSION_MISMATCH@endlink
   * @li @link libsbml#LIBSBML_DUPLICATE_OBJECT_ID LIBSBML_DUPLICATE_OBJECT_ID@endlink
   * @li @link libsbml#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT@endlink
   * @li @link libsbml#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
   *
   *
 * @note This method should be used with some caution.  The fact that this
 * method @em copies the object passed to it means that the caller will be
 * left holding a physically different object instance than the one contained
 * inside this object.  Changes made to the original object instance (such as
 * resetting attribute values) will <em>not affect the instance in this
 * object</em>.  In addition, the caller should make sure to free the
 * original object if it is no longer being used, or else a memory leak will
 * result.  Please see other methods on this class (particularly a
 * corresponding method whose name begins with the word <code>create</code>)
 * for alternatives that do not lead to these issues.
 *
 * 
   *
   * @note The CompartmentType object class is only available in SBML
   * Level&nbsp;2 Versions&nbsp;2&ndash;4.  It is not available in
   * Level&nbsp;1 nor Level&nbsp;3.
   *
   * @see createCompartmentType()
   */ public
 int addCompartmentType(CompartmentType ct) {
    int ret = libsbmlPINVOKE.Model_addCompartmentType(swigCPtr, CompartmentType.getCPtr(ct));
    return ret;
  }

  
/**
   * Adds a copy of the given SpeciesType object to this Model.
   *
   * @param st the SpeciesType object to add.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_LEVEL_MISMATCH LIBSBML_LEVEL_MISMATCH@endlink
   * @li @link libsbml#LIBSBML_VERSION_MISMATCH LIBSBML_VERSION_MISMATCH@endlink
   * @li @link libsbml#LIBSBML_DUPLICATE_OBJECT_ID LIBSBML_DUPLICATE_OBJECT_ID@endlink
   * @li @link libsbml#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT@endlink
   * @li @link libsbml#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
   *
   *
 * @note This method should be used with some caution.  The fact that this
 * method @em copies the object passed to it means that the caller will be
 * left holding a physically different object instance than the one contained
 * inside this object.  Changes made to the original object instance (such as
 * resetting attribute values) will <em>not affect the instance in this
 * object</em>.  In addition, the caller should make sure to free the
 * original object if it is no longer being used, or else a memory leak will
 * result.  Please see other methods on this class (particularly a
 * corresponding method whose name begins with the word <code>create</code>)
 * for alternatives that do not lead to these issues.
 *
 * 
   *
   * @note The SpeciesType object class is only available in SBML
   * Level&nbsp;2 Versions&nbsp;2&ndash;4.  It is not available in
   * Level&nbsp;1 nor Level&nbsp;3.
   *
   * @see createSpeciesType()
   */ public
 int addSpeciesType(SpeciesType st) {
    int ret = libsbmlPINVOKE.Model_addSpeciesType(swigCPtr, SpeciesType.getCPtr(st));
    return ret;
  }

  
/**
   * Adds a copy of the given Compartment object to this Model.
   *
   * @param c the Compartment object to add.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_LEVEL_MISMATCH LIBSBML_LEVEL_MISMATCH@endlink
   * @li @link libsbml#LIBSBML_VERSION_MISMATCH LIBSBML_VERSION_MISMATCH@endlink
   * @li @link libsbml#LIBSBML_DUPLICATE_OBJECT_ID LIBSBML_DUPLICATE_OBJECT_ID@endlink
   * @li @link libsbml#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT@endlink
   * @li @link libsbml#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
   *
   *
 * @note This method should be used with some caution.  The fact that this
 * method @em copies the object passed to it means that the caller will be
 * left holding a physically different object instance than the one contained
 * inside this object.  Changes made to the original object instance (such as
 * resetting attribute values) will <em>not affect the instance in this
 * object</em>.  In addition, the caller should make sure to free the
 * original object if it is no longer being used, or else a memory leak will
 * result.  Please see other methods on this class (particularly a
 * corresponding method whose name begins with the word <code>create</code>)
 * for alternatives that do not lead to these issues.
 *
 * 
   *
   * @see createCompartment()
   */ public
 int addCompartment(Compartment c) {
    int ret = libsbmlPINVOKE.Model_addCompartment(swigCPtr, Compartment.getCPtr(c));
    return ret;
  }

  
/**
   * Adds a copy of the given Species object to this Model.
   *
   * @param s the Species object to add.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_LEVEL_MISMATCH LIBSBML_LEVEL_MISMATCH@endlink
   * @li @link libsbml#LIBSBML_VERSION_MISMATCH LIBSBML_VERSION_MISMATCH@endlink
   * @li @link libsbml#LIBSBML_DUPLICATE_OBJECT_ID LIBSBML_DUPLICATE_OBJECT_ID@endlink
   * @li @link libsbml#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT@endlink
   * @li @link libsbml#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
   *
   *
 * @note This method should be used with some caution.  The fact that this
 * method @em copies the object passed to it means that the caller will be
 * left holding a physically different object instance than the one contained
 * inside this object.  Changes made to the original object instance (such as
 * resetting attribute values) will <em>not affect the instance in this
 * object</em>.  In addition, the caller should make sure to free the
 * original object if it is no longer being used, or else a memory leak will
 * result.  Please see other methods on this class (particularly a
 * corresponding method whose name begins with the word <code>create</code>)
 * for alternatives that do not lead to these issues.
 *
 * 
   *
   * @see createSpecies()
   */ public
 int addSpecies(Species s) {
    int ret = libsbmlPINVOKE.Model_addSpecies(swigCPtr, Species.getCPtr(s));
    return ret;
  }

  
/**
   * Adds a copy of the given Parameter object to this Model.
   *
   * @param p the Parameter object to add.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_LEVEL_MISMATCH LIBSBML_LEVEL_MISMATCH@endlink
   * @li @link libsbml#LIBSBML_VERSION_MISMATCH LIBSBML_VERSION_MISMATCH@endlink
   * @li @link libsbml#LIBSBML_DUPLICATE_OBJECT_ID LIBSBML_DUPLICATE_OBJECT_ID@endlink
   * @li @link libsbml#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT@endlink
   * @li @link libsbml#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
   *
   *
 * @note This method should be used with some caution.  The fact that this
 * method @em copies the object passed to it means that the caller will be
 * left holding a physically different object instance than the one contained
 * inside this object.  Changes made to the original object instance (such as
 * resetting attribute values) will <em>not affect the instance in this
 * object</em>.  In addition, the caller should make sure to free the
 * original object if it is no longer being used, or else a memory leak will
 * result.  Please see other methods on this class (particularly a
 * corresponding method whose name begins with the word <code>create</code>)
 * for alternatives that do not lead to these issues.
 *
 * 
   *
   * @see createParameter()
   */ public
 int addParameter(Parameter p) {
    int ret = libsbmlPINVOKE.Model_addParameter(swigCPtr, Parameter.getCPtr(p));
    return ret;
  }

  
/**
   * Adds a copy of the given InitialAssignment object to this Model.
   *
   * @param ia the InitialAssignment object to add.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_LEVEL_MISMATCH LIBSBML_LEVEL_MISMATCH@endlink
   * @li @link libsbml#LIBSBML_VERSION_MISMATCH LIBSBML_VERSION_MISMATCH@endlink
   * @li @link libsbml#LIBSBML_DUPLICATE_OBJECT_ID LIBSBML_DUPLICATE_OBJECT_ID@endlink
   * @li @link libsbml#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT@endlink
   * @li @link libsbml#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
   *
   *
 * @note This method should be used with some caution.  The fact that this
 * method @em copies the object passed to it means that the caller will be
 * left holding a physically different object instance than the one contained
 * inside this object.  Changes made to the original object instance (such as
 * resetting attribute values) will <em>not affect the instance in this
 * object</em>.  In addition, the caller should make sure to free the
 * original object if it is no longer being used, or else a memory leak will
 * result.  Please see other methods on this class (particularly a
 * corresponding method whose name begins with the word <code>create</code>)
 * for alternatives that do not lead to these issues.
 *
 * 
   *
   * @see createInitialAssignment()
   */ public
 int addInitialAssignment(InitialAssignment ia) {
    int ret = libsbmlPINVOKE.Model_addInitialAssignment(swigCPtr, InitialAssignment.getCPtr(ia));
    return ret;
  }

  
/**
   * Adds a copy of the given Rule object to this Model.
   *
   * @param r the Rule object to add.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_LEVEL_MISMATCH LIBSBML_LEVEL_MISMATCH@endlink
   * @li @link libsbml#LIBSBML_VERSION_MISMATCH LIBSBML_VERSION_MISMATCH@endlink
   * @li @link libsbml#LIBSBML_DUPLICATE_OBJECT_ID LIBSBML_DUPLICATE_OBJECT_ID@endlink
   * @li @link libsbml#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT@endlink
   * @li @link libsbml#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
   *
   *
 * @note This method should be used with some caution.  The fact that this
 * method @em copies the object passed to it means that the caller will be
 * left holding a physically different object instance than the one contained
 * inside this object.  Changes made to the original object instance (such as
 * resetting attribute values) will <em>not affect the instance in this
 * object</em>.  In addition, the caller should make sure to free the
 * original object if it is no longer being used, or else a memory leak will
 * result.  Please see other methods on this class (particularly a
 * corresponding method whose name begins with the word <code>create</code>)
 * for alternatives that do not lead to these issues.
 *
 * 
   *
   * @see createAlgebraicRule()
   * @see createAssignmentRule()
   * @see createRateRule()
   */ public
 int addRule(Rule r) {
    int ret = libsbmlPINVOKE.Model_addRule(swigCPtr, Rule.getCPtr(r));
    return ret;
  }

  
/**
   * Adds a copy of the given Constraint object to this Model.
   *
   * @param c the Constraint object to add.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_LEVEL_MISMATCH LIBSBML_LEVEL_MISMATCH@endlink
   * @li @link libsbml#LIBSBML_VERSION_MISMATCH LIBSBML_VERSION_MISMATCH@endlink
   * @li @link libsbml#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT@endlink
   * @li @link libsbml#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
   *
   *
 * @note This method should be used with some caution.  The fact that this
 * method @em copies the object passed to it means that the caller will be
 * left holding a physically different object instance than the one contained
 * inside this object.  Changes made to the original object instance (such as
 * resetting attribute values) will <em>not affect the instance in this
 * object</em>.  In addition, the caller should make sure to free the
 * original object if it is no longer being used, or else a memory leak will
 * result.  Please see other methods on this class (particularly a
 * corresponding method whose name begins with the word <code>create</code>)
 * for alternatives that do not lead to these issues.
 *
 * 
   *
   * @see createConstraint()
   */ public
 int addConstraint(Constraint c) {
    int ret = libsbmlPINVOKE.Model_addConstraint(swigCPtr, Constraint.getCPtr(c));
    return ret;
  }

  
/**
   * Adds a copy of the given Reaction object to this Model.
   *
   * @param r the Reaction object to add.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_LEVEL_MISMATCH LIBSBML_LEVEL_MISMATCH@endlink
   * @li @link libsbml#LIBSBML_VERSION_MISMATCH LIBSBML_VERSION_MISMATCH@endlink
   * @li @link libsbml#LIBSBML_DUPLICATE_OBJECT_ID LIBSBML_DUPLICATE_OBJECT_ID@endlink
   * @li @link libsbml#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT@endlink
   * @li @link libsbml#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
   *
   *
 * @note This method should be used with some caution.  The fact that this
 * method @em copies the object passed to it means that the caller will be
 * left holding a physically different object instance than the one contained
 * inside this object.  Changes made to the original object instance (such as
 * resetting attribute values) will <em>not affect the instance in this
 * object</em>.  In addition, the caller should make sure to free the
 * original object if it is no longer being used, or else a memory leak will
 * result.  Please see other methods on this class (particularly a
 * corresponding method whose name begins with the word <code>create</code>)
 * for alternatives that do not lead to these issues.
 *
 * 
   *
   * @see createReaction()
   */ public
 int addReaction(Reaction r) {
    int ret = libsbmlPINVOKE.Model_addReaction(swigCPtr, Reaction.getCPtr(r));
    return ret;
  }

  
/**
   * Adds a copy of the given Event object to this Model.
   *
   * @param e the Event object to add.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_LEVEL_MISMATCH LIBSBML_LEVEL_MISMATCH@endlink
   * @li @link libsbml#LIBSBML_VERSION_MISMATCH LIBSBML_VERSION_MISMATCH@endlink
   * @li @link libsbml#LIBSBML_DUPLICATE_OBJECT_ID LIBSBML_DUPLICATE_OBJECT_ID@endlink
   * @li @link libsbml#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT@endlink
   * @li @link libsbml#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
   *
   *
 * @note This method should be used with some caution.  The fact that this
 * method @em copies the object passed to it means that the caller will be
 * left holding a physically different object instance than the one contained
 * inside this object.  Changes made to the original object instance (such as
 * resetting attribute values) will <em>not affect the instance in this
 * object</em>.  In addition, the caller should make sure to free the
 * original object if it is no longer being used, or else a memory leak will
 * result.  Please see other methods on this class (particularly a
 * corresponding method whose name begins with the word <code>create</code>)
 * for alternatives that do not lead to these issues.
 *
 * 
   *
   * @see createEvent()
   */ public
 int addEvent(Event e) {
    int ret = libsbmlPINVOKE.Model_addEvent(swigCPtr, Event.getCPtr(e));
    return ret;
  }

  
/**
   * Creates a new FunctionDefinition inside this Model and returns it.
   *
   * The SBML Level and Version of the enclosing Model object, as well as
   * any SBML package namespaces, are used to initialize this
   * object's corresponding attributes.
   *
   * @return the FunctionDefinition object created.
   *
   * @see addFunctionDefinition(FunctionDefinition fd)
   */ public
 FunctionDefinition createFunctionDefinition() {
    global::System.IntPtr cPtr = libsbmlPINVOKE.Model_createFunctionDefinition(swigCPtr);
    FunctionDefinition ret = (cPtr == global::System.IntPtr.Zero) ? null : new FunctionDefinition(cPtr, false);
    return ret;
  }

  
/**
   * Creates a new UnitDefinition inside this Model and returns it.
   *
   * The SBML Level and Version of the enclosing Model object, as well as
   * any SBML package namespaces, are used to initialize this
   * object's corresponding attributes.
   *
   * @return the UnitDefinition object created.
   *
   * @see addUnitDefinition(UnitDefinition ud)
   */ public
 UnitDefinition createUnitDefinition() {
    global::System.IntPtr cPtr = libsbmlPINVOKE.Model_createUnitDefinition(swigCPtr);
    UnitDefinition ret = (cPtr == global::System.IntPtr.Zero) ? null : new UnitDefinition(cPtr, false);
    return ret;
  }

  
/**
   * Creates a new Unit object within the last UnitDefinition object
   * created in this model and returns a pointer to it.
   *
   * The SBML Level and Version of the enclosing Model object, as well as
   * any SBML package namespaces, are used to initialize this
   * object's corresponding attributes.
   *
   * The mechanism by which the UnitDefinition was created is not
   * significant.  If a UnitDefinition object does not exist in this model,
   * a new Unit is @em not created and @c null is returned instead.
   *
   * @return the Unit object created.
   *
   * @see addUnitDefinition(UnitDefinition ud)
   */ public
 Unit createUnit() {
    global::System.IntPtr cPtr = libsbmlPINVOKE.Model_createUnit(swigCPtr);
    Unit ret = (cPtr == global::System.IntPtr.Zero) ? null : new Unit(cPtr, false);
    return ret;
  }

  
/**
   * Creates a new CompartmentType inside this Model and returns it.
   *
   * The SBML Level and Version of the enclosing Model object, as well as
   * any SBML package namespaces, are used to initialize this
   * object's corresponding attributes.
   *
   * @return the CompartmentType object created.
   *
   * @note The CompartmentType object class is only available in SBML
   * Level&nbsp;2 Versions&nbsp;2&ndash;4.  It is not available in
   * Level&nbsp;1 nor Level&nbsp;3.
   *
   * @see addCompartmentType(CompartmentType ct)
   */ public
 CompartmentType createCompartmentType() {
    global::System.IntPtr cPtr = libsbmlPINVOKE.Model_createCompartmentType(swigCPtr);
    CompartmentType ret = (cPtr == global::System.IntPtr.Zero) ? null : new CompartmentType(cPtr, false);
    return ret;
  }

  
/**
   * Creates a new SpeciesType inside this Model and returns it.
   *
   * The SBML Level and Version of the enclosing Model object, as well as
   * any SBML package namespaces, are used to initialize this
   * object's corresponding attributes.
   *
   * @return the SpeciesType object created.
   *
   * @note The SpeciesType object class is only available in SBML
   * Level&nbsp;2 Versions&nbsp;2&ndash;4.  It is not available in
   * Level&nbsp;1 nor Level&nbsp;3.
   *
   * @see addSpeciesType(SpeciesType st)
   */ public
 SpeciesType createSpeciesType() {
    global::System.IntPtr cPtr = libsbmlPINVOKE.Model_createSpeciesType(swigCPtr);
    SpeciesType ret = (cPtr == global::System.IntPtr.Zero) ? null : new SpeciesType(cPtr, false);
    return ret;
  }

  
/**
   * Creates a new Compartment inside this Model and returns it.
   *
   * The SBML Level and Version of the enclosing Model object, as well as
   * any SBML package namespaces, are used to initialize this
   * object's corresponding attributes.
   *
   * @return the Compartment object created.
   *
   * @see addCompartment(Compartment c)
   */ public
 Compartment createCompartment() {
    global::System.IntPtr cPtr = libsbmlPINVOKE.Model_createCompartment(swigCPtr);
    Compartment ret = (cPtr == global::System.IntPtr.Zero) ? null : new Compartment(cPtr, false);
    return ret;
  }

  
/**
   * Creates a new Species inside this Model and returns it.
   *
   * The SBML Level and Version of the enclosing Model object, as well as
   * any SBML package namespaces, are used to initialize this
   * object's corresponding attributes.
   *
   * @return the Species object created.
   *
   * @see addSpecies(Species s)
   */ public
 Species createSpecies() {
    global::System.IntPtr cPtr = libsbmlPINVOKE.Model_createSpecies(swigCPtr);
    Species ret = (cPtr == global::System.IntPtr.Zero) ? null : new Species(cPtr, false);
    return ret;
  }

  
/**
   * Creates a new Parameter inside this Model and returns it.
   *
   * The SBML Level and Version of the enclosing Model object, as well as
   * any SBML package namespaces, are used to initialize this
   * object's corresponding attributes.
   *
   * @return the Parameter object created.
   *
   * @see addParameter(Parameter p)
   */ public
 Parameter createParameter() {
    global::System.IntPtr cPtr = libsbmlPINVOKE.Model_createParameter(swigCPtr);
    Parameter ret = (cPtr == global::System.IntPtr.Zero) ? null : new Parameter(cPtr, false);
    return ret;
  }

  
/**
   * Creates a new InitialAssignment inside this Model and returns it.
   *
   * The SBML Level and Version of the enclosing Model object, as well as
   * any SBML package namespaces, are used to initialize this
   * object's corresponding attributes.
   *
   * @return the InitialAssignment object created.
   *
   * @see addInitialAssignment(InitialAssignment ia)
   */ public
 InitialAssignment createInitialAssignment() {
    global::System.IntPtr cPtr = libsbmlPINVOKE.Model_createInitialAssignment(swigCPtr);
    InitialAssignment ret = (cPtr == global::System.IntPtr.Zero) ? null : new InitialAssignment(cPtr, false);
    return ret;
  }

  
/**
   * Creates a new AlgebraicRule inside this Model and returns it.
   *
   * The SBML Level and Version of the enclosing Model object, as well as
   * any SBML package namespaces, are used to initialize this
   * object's corresponding attributes.
   *
   * @return the AlgebraicRule object created.
   *
   * @see addRule(Rule r)
   */ public
 AlgebraicRule createAlgebraicRule() {
    global::System.IntPtr cPtr = libsbmlPINVOKE.Model_createAlgebraicRule(swigCPtr);
    AlgebraicRule ret = (cPtr == global::System.IntPtr.Zero) ? null : new AlgebraicRule(cPtr, false);
    return ret;
  }

  
/**
   * Creates a new AssignmentRule inside this Model and returns it.
   *
   * The SBML Level and Version of the enclosing Model object, as well as
   * any SBML package namespaces, are used to initialize this
   * object's corresponding attributes.
   *
   * @return the AssignmentRule object created.
   *
   * @see addRule(Rule r)
   */ public
 AssignmentRule createAssignmentRule() {
    global::System.IntPtr cPtr = libsbmlPINVOKE.Model_createAssignmentRule(swigCPtr);
    AssignmentRule ret = (cPtr == global::System.IntPtr.Zero) ? null : new AssignmentRule(cPtr, false);
    return ret;
  }

  
/**
   * Creates a new RateRule inside this Model and returns it.
   *
   * The SBML Level and Version of the enclosing Model object, as well as
   * any SBML package namespaces, are used to initialize this
   * object's corresponding attributes.
   *
   * @return the RateRule object created.
   *
   * @see addRule(Rule r)
   */ public
 RateRule createRateRule() {
    global::System.IntPtr cPtr = libsbmlPINVOKE.Model_createRateRule(swigCPtr);
    RateRule ret = (cPtr == global::System.IntPtr.Zero) ? null : new RateRule(cPtr, false);
    return ret;
  }

  
/**
   * Creates a new Constraint inside this Model and returns it.
   *
   * The SBML Level and Version of the enclosing Model object, as well as
   * any SBML package namespaces, are used to initialize this
   * object's corresponding attributes.
   *
   * @return the Constraint object created.
   *
   * @see addConstraint(Constraint c)
   */ public
 Constraint createConstraint() {
    global::System.IntPtr cPtr = libsbmlPINVOKE.Model_createConstraint(swigCPtr);
    Constraint ret = (cPtr == global::System.IntPtr.Zero) ? null : new Constraint(cPtr, false);
    return ret;
  }

  
/**
   * Creates a new Reaction inside this Model and returns it.
   *
   * The SBML Level and Version of the enclosing Model object, as well as
   * any SBML package namespaces, are used to initialize this
   * object's corresponding attributes.
   *
   * @return the Reaction object created.
   *
   * @see addReaction(Reaction r)
   */ public
 Reaction createReaction() {
	Reaction ret = (Reaction) libsbml.DowncastSBase(libsbmlPINVOKE.Model_createReaction(swigCPtr), false);
	return ret;
}

  
/**
   * Creates a new SpeciesReference object for a reactant inside the last
   * Reaction object in this Model, and returns a pointer to it.
   *
   * The SBML Level and Version of the enclosing Model object, as well as
   * any SBML package namespaces, are used to initialize this
   * object's corresponding attributes.
   *
   *
 * 
 * The mechanism by which the last Reaction object was created and added
 * to this Model is not significant.  It could have been created in a
 * variety of ways, for example using createReaction().  If a Reaction
 * does not exist for this model, a new SpeciesReference is @em not
 * created and @c null is returned instead.
 *
 *
   *
   * @return the SpeciesReference object created.  If a Reaction does not
   * exist for this model, a new SpeciesReference is @em not created and
   * @c null is returned.
   */ public
 SpeciesReference createReactant() {
	SpeciesReference ret
	    = (SpeciesReference) libsbml.DowncastSBase(libsbmlPINVOKE.Model_createReactant(swigCPtr), false);
	return ret;
}

  
/**
   * Creates a new SpeciesReference object for a product inside the last
   * Reaction object in this Model, and returns a pointer to it.
   *
   * The SBML Level and Version of the enclosing Model object, as well as
   * any SBML package namespaces, are used to initialize this
   * object's corresponding attributes.
   *
   *
 * 
 * The mechanism by which the last Reaction object was created and added
 * to this Model is not significant.  It could have been created in a
 * variety of ways, for example using createReaction().  If a Reaction
 * does not exist for this model, a new SpeciesReference is @em not
 * created and @c null is returned instead.
 *
 *
   *
   * @return the SpeciesReference object created. If a Reaction does not
   * exist for this model, a new SpeciesReference is @em not created and
   * @c null is returned.
   */ public
 SpeciesReference createProduct() {
	SpeciesReference ret
	    = (SpeciesReference) libsbml.DowncastSBase(libsbmlPINVOKE.Model_createProduct(swigCPtr), false);
	return ret;
}

  
/**
   * Creates a new ModifierSpeciesReference object for a modifier species
   * inside the last Reaction object in this Model, and returns a pointer
   * to it.
   *
   * The SBML Level and Version of the enclosing Model object, as well as
   * any SBML package namespaces, are used to initialize this
   * object's corresponding attributes.
   *
   *
 * 
 * The mechanism by which the last Reaction object was created and added
 * to this Model is not significant.  It could have been created in a
 * variety of ways, for example using createReaction().  If a Reaction
 * does not exist for this model, a new SpeciesReference is @em not
 * created and @c null is returned instead.
 *
 *
   *
   * @return the SpeciesReference object created.  If a Reaction does not
   * exist for this model, a new SpeciesReference is @em not created and
   * @c null is returned.
   */ public
 ModifierSpeciesReference createModifier() {
    global::System.IntPtr cPtr = libsbmlPINVOKE.Model_createModifier(swigCPtr);
    ModifierSpeciesReference ret = (cPtr == global::System.IntPtr.Zero) ? null : new ModifierSpeciesReference(cPtr, false);
    return ret;
  }

  
/**
   * Creates a new KineticLaw inside the last Reaction object created in
   * this Model, and returns a pointer to it.
   *
   * The SBML Level and Version of the enclosing Model object, as well as
   * any SBML package namespaces, are used to initialize this
   * object's corresponding attributes.
   *
   *
 * 
 * The mechanism by which the last Reaction object was created and added
 * to this Model is not significant.  It could have been created in a
 * variety of ways, for example using createReaction().  If a Reaction
 * does not exist for this model, a new SpeciesReference is @em not
 * created and @c null is returned instead.
 *
 *
   *
   * @return the KineticLaw object created.  If a Reaction does not exist for
   * this model, or a Reaction does exist but already has a KineticLaw, a new
   * KineticLaw is @em not created and @c null is returned.
   */ public
 KineticLaw createKineticLaw() {
    global::System.IntPtr cPtr = libsbmlPINVOKE.Model_createKineticLaw(swigCPtr);
    KineticLaw ret = (cPtr == global::System.IntPtr.Zero) ? null : new KineticLaw(cPtr, false);
    return ret;
  }

  
/**
   * Creates a new local Parameter inside the KineticLaw object of the last
   * Reaction created inside this Model, and returns a pointer to it.
   *
   * The SBML Level and Version of the enclosing Model object, as well as
   * any SBML package namespaces, are used to initialize this
   * object's corresponding attributes.
   *
   *
 * 
 * The last KineticLaw object in this Model could have been created in a
 * variety of ways.  For example, it could have been added using
 * createKineticLaw(), or it could be the result of using
 * Reaction::createKineticLaw() on the Reaction object created by a
 * createReaction().  If a Reaction does not exist for this model, or the
 * last Reaction does not contain a KineticLaw object, a new Parameter is
 * @em not created and @c null is returned instead.
 *
 *
   *
   * @return the Parameter object created.  If a Reaction does not exist for
   * this model, or a KineticLaw for the Reaction does not exist, a new
   * Parameter is @em not created and @c null is returned.
   */ public
 Parameter createKineticLawParameter() {
    global::System.IntPtr cPtr = libsbmlPINVOKE.Model_createKineticLawParameter(swigCPtr);
    Parameter ret = (cPtr == global::System.IntPtr.Zero) ? null : new Parameter(cPtr, false);
    return ret;
  }

  
/**
   * Creates a new LocalParameter inside the KineticLaw object of the last
   * Reaction created inside this Model, and returns a pointer to it.
   *
   * The SBML Level and Version of the enclosing Model object, as well as
   * any SBML package namespaces, are used to initialize this
   * object's corresponding attributes.
   *
   *
 * 
 * The last KineticLaw object in this Model could have been created in a
 * variety of ways.  For example, it could have been added using
 * createKineticLaw(), or it could be the result of using
 * Reaction::createKineticLaw() on the Reaction object created by a
 * createReaction().  If a Reaction does not exist for this model, or the
 * last Reaction does not contain a KineticLaw object, a new Parameter is
 * @em not created and @c null is returned instead.
 *
 *
   *
   * @return the Parameter object created.  If a Reaction does not exist for
   * this model, or a KineticLaw for the Reaction does not exist, a new
   * Parameter is @em not created and @c null is returned.
   */ public
 LocalParameter createKineticLawLocalParameter() {
    global::System.IntPtr cPtr = libsbmlPINVOKE.Model_createKineticLawLocalParameter(swigCPtr);
    LocalParameter ret = (cPtr == global::System.IntPtr.Zero) ? null : new LocalParameter(cPtr, false);
    return ret;
  }

  
/**
   * Creates a new Event inside this Model and returns it.
   *
   * The SBML Level and Version of the enclosing Model object, as well as
   * any SBML package namespaces, are used to initialize this
   * object's corresponding attributes.
   *
   * @return the Event object created.
   */ public
 Event createEvent() {
    global::System.IntPtr cPtr = libsbmlPINVOKE.Model_createEvent(swigCPtr);
    Event ret = (cPtr == global::System.IntPtr.Zero) ? null : new Event(cPtr, false);
    return ret;
  }

  
/**
   * Creates a new EventAssignment inside the last Event object created in
   * this Model, and returns a pointer to it.
   *
   * The SBML Level and Version of the enclosing Model object, as well as
   * any SBML package namespaces, are used to initialize this
   * object's corresponding attributes.
   *
   *
 * 
 * The mechanism by which the last Event object in this model was created
 * is not significant.  It could have been created in a variety of ways,
 * for example by using createEvent().  If no Event object exists in this
 * Model object, a new EventAssignment is @em not created and @c null is
 * returned instead.
   *
   * @return the EventAssignment object created.
   */ public
 EventAssignment createEventAssignment() {
    global::System.IntPtr cPtr = libsbmlPINVOKE.Model_createEventAssignment(swigCPtr);
    EventAssignment ret = (cPtr == global::System.IntPtr.Zero) ? null : new EventAssignment(cPtr, false);
    return ret;
  }

  
/**
   * Creates a new Trigger inside the last Event object created in
   * this Model, and returns a pointer to it.
   *
   * The SBML Level and Version of the enclosing Model object, as well as
   * any SBML package namespaces, are used to initialize this
   * object's corresponding attributes.
   *
   *
 * 
 * The mechanism by which the last Event object in this model was created
 * is not significant.  It could have been created in a variety of ways,
 * for example by using createEvent().  If no Event object exists in this
 * Model object, a new EventAssignment is @em not created and @c null is
 * returned instead.
   *
   * @return the Trigger object created.
   */ public
 Trigger createTrigger() {
    global::System.IntPtr cPtr = libsbmlPINVOKE.Model_createTrigger(swigCPtr);
    Trigger ret = (cPtr == global::System.IntPtr.Zero) ? null : new Trigger(cPtr, false);
    return ret;
  }

  
/**
   * Creates a new Delay inside the last Event object created in
   * this Model, and returns a pointer to it.
   *
   * The SBML Level and Version of the enclosing Model object, as well as
   * any SBML package namespaces, are used to initialize this
   * object's corresponding attributes.
   *
   *
 * 
 * The mechanism by which the last Event object in this model was created
 * is not significant.  It could have been created in a variety of ways,
 * for example by using createEvent().  If no Event object exists in this
 * Model object, a new EventAssignment is @em not created and @c null is
 * returned instead.
   *
   * @return the Delay object created.
   */ public
 Delay createDelay() {
    global::System.IntPtr cPtr = libsbmlPINVOKE.Model_createDelay(swigCPtr);
    Delay ret = (cPtr == global::System.IntPtr.Zero) ? null : new Delay(cPtr, false);
    return ret;
  }

  
/**
   * Sets the value of the 'annotation' subelement of this SBML object to a
   * copy of @p annotation.
   *
   * Any existing content of the 'annotation' subelement is discarded.
   * Unless you have taken steps to first copy and reconstitute any
   * existing annotations into the @p annotation that is about to be
   * assigned, it is likely that performing such wholesale replacement is
   * unfriendly towards other software applications whose annotations are
   * discarded.  An alternative may be to use appendAnnotation().
   *
   * @param annotation an XML structure that is to be used as the content
   * of the 'annotation' subelement of this object.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif This particular
 * function only does one thing irrespective of user input or 
 * object state, and thus will only return a single value:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   *
   * @see appendAnnotation(XMLNode annotation)
   */ public new
 int setAnnotation(XMLNode annotation) {
    int ret = libsbmlPINVOKE.Model_setAnnotation__SWIG_0(swigCPtr, XMLNode.getCPtr(annotation));
    return ret;
  }

  
/**
   * Sets the value of the 'annotation' subelement of this SBML object to a
   * copy of @p annotation.
   *
   * Any existing content of the 'annotation' subelement is discarded.
   * Unless you have taken steps to first copy and reconstitute any
   * existing annotations into the @p annotation that is about to be
   * assigned, it is likely that performing such wholesale replacement is
   * unfriendly towards other software applications whose annotations are
   * discarded.  An alternative may be to use appendAnnotation().
   *
   * @param annotation an XML string that is to be used as the content
   * of the 'annotation' subelement of this object.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
   *
   * @see appendAnnotation(string annotation)
   */ public new
 int setAnnotation(string annotation) {
    int ret = libsbmlPINVOKE.Model_setAnnotation__SWIG_1(swigCPtr, annotation);
    return ret;
  }

  
/**
   * Appends annotation content to any existing content in the 'annotation'
   * subelement of this object.
   *
   * The content in @p annotation is copied.  Unlike setAnnotation(), this
   * method allows other annotations to be preserved when an application
   * adds its own data.
   *
   * @param annotation an XML structure that is to be copied and appended
   * to the content of the 'annotation' subelement of this object.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
   *
   * @see setAnnotation(XMLNode annotation)
   */ public new
 int appendAnnotation(XMLNode annotation) {
    int ret = libsbmlPINVOKE.Model_appendAnnotation__SWIG_0(swigCPtr, XMLNode.getCPtr(annotation));
    return ret;
  }

  
/**
   * Appends annotation content to any existing content in the 'annotation'
   * subelement of this object.
   *
   * The content in @p annotation is copied.  Unlike setAnnotation(), this 
   * method allows other annotations to be preserved when an application
   * adds its own data.
   *
   * @param annotation an XML string that is to be copied and appended
   * to the content of the 'annotation' subelement of this object.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
   *
   * @see setAnnotation(string annotation)
   */ public new
 int appendAnnotation(string annotation) {
    int ret = libsbmlPINVOKE.Model_appendAnnotation__SWIG_1(swigCPtr, annotation);
    return ret;
  }

  
/**
   * Get the ListOfFunctionDefinitions object in this Model.
   *
   * @return the list of FunctionDefinitions for this Model.
   */ public
 ListOfFunctionDefinitions getListOfFunctionDefinitions() {
    global::System.IntPtr cPtr = libsbmlPINVOKE.Model_getListOfFunctionDefinitions__SWIG_0(swigCPtr);
    ListOfFunctionDefinitions ret = (cPtr == global::System.IntPtr.Zero) ? null : new ListOfFunctionDefinitions(cPtr, false);
    return ret;
  }

  
/**
   * Get the ListOfUnitDefinitions object in this Model.
   *
   * @return the list of UnitDefinitions for this Model.
   */ public
 ListOfUnitDefinitions getListOfUnitDefinitions() {
    global::System.IntPtr cPtr = libsbmlPINVOKE.Model_getListOfUnitDefinitions__SWIG_0(swigCPtr);
    ListOfUnitDefinitions ret = (cPtr == global::System.IntPtr.Zero) ? null : new ListOfUnitDefinitions(cPtr, false);
    return ret;
  }

  
/**
   * Get the ListOfCompartmentTypes object in this Model.
   *
   * @return the list of CompartmentTypes for this Model.
   *
   * @note The CompartmentType object class is only available in SBML
   * Level&nbsp;2 Versions&nbsp;2&ndash;4.  It is not available in
   * Level&nbsp;1 nor Level&nbsp;3.
   */ public
 ListOfCompartmentTypes getListOfCompartmentTypes() {
    global::System.IntPtr cPtr = libsbmlPINVOKE.Model_getListOfCompartmentTypes__SWIG_0(swigCPtr);
    ListOfCompartmentTypes ret = (cPtr == global::System.IntPtr.Zero) ? null : new ListOfCompartmentTypes(cPtr, false);
    return ret;
  }

  
/**
   * Get the ListOfSpeciesTypes object in this Model.
   *
   * @return the list of SpeciesTypes for this Model.
   *
   * @note The SpeciesType object class is only available in SBML
   * Level&nbsp;2 Versions&nbsp;2&ndash;4.  It is not available in
   * Level&nbsp;1 nor Level&nbsp;3.
   */ public
 ListOfSpeciesTypes getListOfSpeciesTypes() {
    global::System.IntPtr cPtr = libsbmlPINVOKE.Model_getListOfSpeciesTypes__SWIG_0(swigCPtr);
    ListOfSpeciesTypes ret = (cPtr == global::System.IntPtr.Zero) ? null : new ListOfSpeciesTypes(cPtr, false);
    return ret;
  }

  
/**
   * Get the ListOfCompartments object in this Model.
   *
   * @return the list of Compartments for this Model.
   */ public
 ListOfCompartments getListOfCompartments() {
    global::System.IntPtr cPtr = libsbmlPINVOKE.Model_getListOfCompartments__SWIG_0(swigCPtr);
    ListOfCompartments ret = (cPtr == global::System.IntPtr.Zero) ? null : new ListOfCompartments(cPtr, false);
    return ret;
  }

  
/**
   * Get the ListOfSpecies object in this Model.
   *
   * @return the list of Species for this Model.
   */ public
 ListOfSpecies getListOfSpecies() {
    global::System.IntPtr cPtr = libsbmlPINVOKE.Model_getListOfSpecies__SWIG_0(swigCPtr);
    ListOfSpecies ret = (cPtr == global::System.IntPtr.Zero) ? null : new ListOfSpecies(cPtr, false);
    return ret;
  }

  
/**
   * Get the ListOfParameters object in this Model.
   *
   * @return the list of Parameters for this Model.
   */ public
 ListOfParameters getListOfParameters() {
    global::System.IntPtr cPtr = libsbmlPINVOKE.Model_getListOfParameters__SWIG_0(swigCPtr);
    ListOfParameters ret = (cPtr == global::System.IntPtr.Zero) ? null : new ListOfParameters(cPtr, false);
    return ret;
  }

  
/**
   * Get the ListOfInitialAssignments object in this Model.
   *
   * @return the list of InitialAssignments for this Model.
   */ public
 ListOfInitialAssignments getListOfInitialAssignments() {
    global::System.IntPtr cPtr = libsbmlPINVOKE.Model_getListOfInitialAssignments__SWIG_0(swigCPtr);
    ListOfInitialAssignments ret = (cPtr == global::System.IntPtr.Zero) ? null : new ListOfInitialAssignments(cPtr, false);
    return ret;
  }

  
/**
   * Get the ListOfRules object in this Model.
   *
   * @return the list of Rules for this Model.
   */ public
 ListOfRules getListOfRules() {
    global::System.IntPtr cPtr = libsbmlPINVOKE.Model_getListOfRules__SWIG_0(swigCPtr);
    ListOfRules ret = (cPtr == global::System.IntPtr.Zero) ? null : new ListOfRules(cPtr, false);
    return ret;
  }

  
/**
   * Get the ListOfConstraints object in this Model.
   *
   * @return the list of Constraints for this Model.
   */ public
 ListOfConstraints getListOfConstraints() {
    global::System.IntPtr cPtr = libsbmlPINVOKE.Model_getListOfConstraints__SWIG_0(swigCPtr);
    ListOfConstraints ret = (cPtr == global::System.IntPtr.Zero) ? null : new ListOfConstraints(cPtr, false);
    return ret;
  }

  
/**
   * Get the ListOfReactions object in this Model.
   *
   * @return the list of Reactions for this Model.
   */ public
 ListOfReactions getListOfReactions() {
    global::System.IntPtr cPtr = libsbmlPINVOKE.Model_getListOfReactions__SWIG_0(swigCPtr);
    ListOfReactions ret = (cPtr == global::System.IntPtr.Zero) ? null : new ListOfReactions(cPtr, false);
    return ret;
  }

  
/**
   * Get the ListOfEvents object in this Model.
   *
   * @return the list of Events for this Model.
   */ public
 ListOfEvents getListOfEvents() {
    global::System.IntPtr cPtr = libsbmlPINVOKE.Model_getListOfEvents__SWIG_0(swigCPtr);
    ListOfEvents ret = (cPtr == global::System.IntPtr.Zero) ? null : new ListOfEvents(cPtr, false);
    return ret;
  }

  
/**
   * Get the nth FunctionDefinitions object in this Model.
   *
   * @param n the index of the object to return.
   *
   * @return the nth FunctionDefinition of this Model.
   */ public
 FunctionDefinition getFunctionDefinition(long n) {
    global::System.IntPtr cPtr = libsbmlPINVOKE.Model_getFunctionDefinition__SWIG_0(swigCPtr, n);
    FunctionDefinition ret = (cPtr == global::System.IntPtr.Zero) ? null : new FunctionDefinition(cPtr, false);
    return ret;
  }

  
/**
   * Get a FunctionDefinition object based on its identifier.
   *
   * @param sid the identifier to search for.
   *
   * @return the FunctionDefinition in this Model with the identifier
   * @p sid or @c null if no such FunctionDefinition exists.
   */ public
 FunctionDefinition getFunctionDefinition(string sid) {
    global::System.IntPtr cPtr = libsbmlPINVOKE.Model_getFunctionDefinition__SWIG_2(swigCPtr, sid);
    FunctionDefinition ret = (cPtr == global::System.IntPtr.Zero) ? null : new FunctionDefinition(cPtr, false);
    return ret;
  }

  
/**
   * Get the nth UnitDefinition object in this Model.
   *
   * @param n the index of the object to return.
   *
   * @return the nth UnitDefinition of this Model.
   */ public
 UnitDefinition getUnitDefinition(long n) {
    global::System.IntPtr cPtr = libsbmlPINVOKE.Model_getUnitDefinition__SWIG_0(swigCPtr, n);
    UnitDefinition ret = (cPtr == global::System.IntPtr.Zero) ? null : new UnitDefinition(cPtr, false);
    return ret;
  }

  
/**
   * Get a UnitDefinition based on its identifier.
   *
   * @param sid the identifier to search for.
   *
   * @return the UnitDefinition in this Model with the identifier @p sid or
   * @c null if no such UnitDefinition exists.
   */ public
 UnitDefinition getUnitDefinition(string sid) {
    global::System.IntPtr cPtr = libsbmlPINVOKE.Model_getUnitDefinition__SWIG_2(swigCPtr, sid);
    UnitDefinition ret = (cPtr == global::System.IntPtr.Zero) ? null : new UnitDefinition(cPtr, false);
    return ret;
  }

  
/**
   * Get the nth CompartmentType object in this Model.
   *
   * @param n the index of the object to return.
   *
   * @return the nth CompartmentType of this Model.
   *
   * @note The CompartmentType object class is only available in SBML
   * Level&nbsp;2 Versions&nbsp;2&ndash;4.  It is not available in
   * Level&nbsp;1 nor Level&nbsp;3.
   */ public
 CompartmentType getCompartmentType(long n) {
    global::System.IntPtr cPtr = libsbmlPINVOKE.Model_getCompartmentType__SWIG_0(swigCPtr, n);
    CompartmentType ret = (cPtr == global::System.IntPtr.Zero) ? null : new CompartmentType(cPtr, false);
    return ret;
  }

  
/**
   * Get a CompartmentType object based on its identifier.
   *
   * @param sid the identifier to search for.
   *
   * @return the CompartmentType in this Model with the identifier @p sid
   * or @c null if no such CompartmentType exists.
   *
   * @note The CompartmentType object class is only available in SBML
   * Level&nbsp;2 Versions&nbsp;2&ndash;4.  It is not available in
   * Level&nbsp;1 nor Level&nbsp;3.
   */ public
 CompartmentType getCompartmentType(string sid) {
    global::System.IntPtr cPtr = libsbmlPINVOKE.Model_getCompartmentType__SWIG_2(swigCPtr, sid);
    CompartmentType ret = (cPtr == global::System.IntPtr.Zero) ? null : new CompartmentType(cPtr, false);
    return ret;
  }

  
/**
   * Get the nth SpeciesType object in this Model.
   *
   * @param n the index of the object to return.
   *
   * @return the nth SpeciesType of this Model.
   *
   * @note The SpeciesType object class is only available in SBML
   * Level&nbsp;2 Versions&nbsp;2&ndash;4.  It is not available in
   * Level&nbsp;1 nor Level&nbsp;3.
   */ public
 SpeciesType getSpeciesType(long n) {
    global::System.IntPtr cPtr = libsbmlPINVOKE.Model_getSpeciesType__SWIG_0(swigCPtr, n);
    SpeciesType ret = (cPtr == global::System.IntPtr.Zero) ? null : new SpeciesType(cPtr, false);
    return ret;
  }

  
/**
   * Get a SpeciesType object based on its identifier.
   *
   * @param sid the identifier to search for.
   *
   * @return the SpeciesType in this Model with the identifier @p sid or
   * @c null if no such SpeciesType exists.
   *
   * @note The SpeciesType object class is only available in SBML
   * Level&nbsp;2 Versions&nbsp;2&ndash;4.  It is not available in
   * Level&nbsp;1 nor Level&nbsp;3.
   */ public
 SpeciesType getSpeciesType(string sid) {
    global::System.IntPtr cPtr = libsbmlPINVOKE.Model_getSpeciesType__SWIG_2(swigCPtr, sid);
    SpeciesType ret = (cPtr == global::System.IntPtr.Zero) ? null : new SpeciesType(cPtr, false);
    return ret;
  }

  
/**
   * Get the nth Compartment object in this Model.
   *
   * @param n the index of the object to return.
   *
   * @return the nth Compartment of this Model.
   */ public
 Compartment getCompartment(long n) {
    global::System.IntPtr cPtr = libsbmlPINVOKE.Model_getCompartment__SWIG_0(swigCPtr, n);
    Compartment ret = (cPtr == global::System.IntPtr.Zero) ? null : new Compartment(cPtr, false);
    return ret;
  }

  
/**
   * Get a Compartment object based on its identifier.
   *
   * @param sid the identifier to search for.
   *
   * @return the Compartment in this Model with the identifier @p sid or
   * @c null if no such Compartment exists.
   */ public
 Compartment getCompartment(string sid) {
    global::System.IntPtr cPtr = libsbmlPINVOKE.Model_getCompartment__SWIG_2(swigCPtr, sid);
    Compartment ret = (cPtr == global::System.IntPtr.Zero) ? null : new Compartment(cPtr, false);
    return ret;
  }

  
/**
   * Get the nth Species object in this Model.
   *
   * @param n the index of the object to return.
   *
   * @return the nth Species of this Model.
   */ public
 Species getSpecies(long n) {
    global::System.IntPtr cPtr = libsbmlPINVOKE.Model_getSpecies__SWIG_0(swigCPtr, n);
    Species ret = (cPtr == global::System.IntPtr.Zero) ? null : new Species(cPtr, false);
    return ret;
  }

  
/**
   * Get a Species object based on its identifier.
   *
   * @param sid the identifier to search for.
   *
   * @return the Species in this Model with the identifier @p sid or @c null
   * if no such Species exists.
   */ public
 Species getSpecies(string sid) {
    global::System.IntPtr cPtr = libsbmlPINVOKE.Model_getSpecies__SWIG_2(swigCPtr, sid);
    Species ret = (cPtr == global::System.IntPtr.Zero) ? null : new Species(cPtr, false);
    return ret;
  }

  
/**
   * Get the nth Parameter object in this Model.
   *
   * @param n the index of the object to return.
   *
   * @return the nth Parameter of this Model.
   */ public
 Parameter getParameter(long n) {
    global::System.IntPtr cPtr = libsbmlPINVOKE.Model_getParameter__SWIG_0(swigCPtr, n);
    Parameter ret = (cPtr == global::System.IntPtr.Zero) ? null : new Parameter(cPtr, false);
    return ret;
  }

  
/**
   * Get a Parameter object based on its identifier.
   *
   * @param sid the identifier to search for.
   *
   * @return the Parameter in this Model with the identifier @p sid or @c null
   * if no such Parameter exists.
   */ public
 Parameter getParameter(string sid) {
    global::System.IntPtr cPtr = libsbmlPINVOKE.Model_getParameter__SWIG_2(swigCPtr, sid);
    Parameter ret = (cPtr == global::System.IntPtr.Zero) ? null : new Parameter(cPtr, false);
    return ret;
  }

  
/**
   * Get the nth InitialAssignment object in this Model.
   *
   * @param n the index of the object to return.
   *
   * @return the nth InitialAssignment of this Model.
   */ public
 InitialAssignment getInitialAssignment(long n) {
    global::System.IntPtr cPtr = libsbmlPINVOKE.Model_getInitialAssignment__SWIG_0(swigCPtr, n);
    InitialAssignment ret = (cPtr == global::System.IntPtr.Zero) ? null : new InitialAssignment(cPtr, false);
    return ret;
  }

  
/**
   * Get an InitialAssignment object based on the symbol to which it
   * assigns a value.
   *
   * @param symbol the symbol to search for.
   *
   * @return the InitialAssignment in this Model with the given 'symbol'
   * attribute value or @c null if no such InitialAssignment exists.
   */ public
 InitialAssignment getInitialAssignment(string symbol) {
    global::System.IntPtr cPtr = libsbmlPINVOKE.Model_getInitialAssignment__SWIG_2(swigCPtr, symbol);
    InitialAssignment ret = (cPtr == global::System.IntPtr.Zero) ? null : new InitialAssignment(cPtr, false);
    return ret;
  }

  
/**
   * Get an InitialAssignment object based on the symbol to which it
   * assigns a value.
   *
   * @param symbol the symbol to search for.
   *
   * @return the InitialAssignment in this Model with the given 'symbol'
   * attribute value or @c null if no such InitialAssignment exists.
   */ public
 InitialAssignment getInitialAssignmentBySymbol(string symbol) {
    global::System.IntPtr cPtr = libsbmlPINVOKE.Model_getInitialAssignmentBySymbol__SWIG_0(swigCPtr, symbol);
    InitialAssignment ret = (cPtr == global::System.IntPtr.Zero) ? null : new InitialAssignment(cPtr, false);
    return ret;
  }

  
/**
   * Get the nth Rule object in this Model.
   *
   * @param n the index of the object to return.
   *
   * @return the nth Rule of this Model.
   */ public
 Rule getRule(long n) {
        Rule ret = (Rule) libsbml.DowncastSBase(libsbmlPINVOKE.Model_getRule__SWIG_0(swigCPtr, n), false);
	return ret;
}

  
/**
   * Get a Rule object based on the variable to which it assigns a value.
   *
   * @param variable the variable to search for.
   *
   * @return the Rule in this Model with the given 'variable' attribute
   * value or @c null if no such Rule exists.
   */ public
 Rule getRule(string variable) {
        Rule ret = (Rule) libsbml.DowncastSBase(libsbmlPINVOKE.Model_getRule__SWIG_2(swigCPtr, variable), false);
	return ret;
}

  
/**
   * Get a Rule object based on the variable to which it assigns a value.
   *
   * @param variable the variable to search for.
   *
   * @return the Rule in this Model with the given 'variable' attribute
   * value or @c null if no such Rule exists.
   */ public
 Rule getRuleByVariable(string variable) {
        Rule ret = (Rule) libsbml.DowncastSBase(libsbmlPINVOKE.Model_getRuleByVariable__SWIG_0(swigCPtr, variable), false);
	return ret;
}

  
/**
   * Get a Rule object based on the variable to which it assigns a value.
   *
   * @param variable the variable to search for.
   *
   * @return the Rule in this Model with the given 'variable' attribute
   * value or @c null if no such Rule exists.
   */ public
 AssignmentRule getAssignmentRule(string variable) {
    global::System.IntPtr cPtr = libsbmlPINVOKE.Model_getAssignmentRule__SWIG_0(swigCPtr, variable);
    AssignmentRule ret = (cPtr == global::System.IntPtr.Zero) ? null : new AssignmentRule(cPtr, false);
    return ret;
  }

  
/**
   * Get a Rule object based on the variable to which it assigns a value.
   *
   * @param variable the symbol to search for.
   *
   * @return the Rule in this Model with the given 'variable' attribute
   * value or @c null if no such Rule exists.
   */ public
 RateRule getRateRule(string variable) {
    global::System.IntPtr cPtr = libsbmlPINVOKE.Model_getRateRule__SWIG_0(swigCPtr, variable);
    RateRule ret = (cPtr == global::System.IntPtr.Zero) ? null : new RateRule(cPtr, false);
    return ret;
  }

  
/**
   * Get a Rule object based on the variable to which it assigns a value.
   *
   * @param variable the variable to search for.
   *
   * @return the Rule in this Model with the given 'variable' attribute
   * value or @c null if no such Rule exists.
   */ public
 AssignmentRule getAssignmentRuleByVariable(string variable) {
    global::System.IntPtr cPtr = libsbmlPINVOKE.Model_getAssignmentRuleByVariable__SWIG_0(swigCPtr, variable);
    AssignmentRule ret = (cPtr == global::System.IntPtr.Zero) ? null : new AssignmentRule(cPtr, false);
    return ret;
  }

  
/**
   * Get a Rule object based on the variable to which it assigns a value.
   *
   * @param variable the variable to search for.
   *
   * @return the Rule in this Model with the given 'variable' attribute
   * value or @c null if no such Rule exists.
   */ public
 RateRule getRateRuleByVariable(string variable) {
    global::System.IntPtr cPtr = libsbmlPINVOKE.Model_getRateRuleByVariable__SWIG_0(swigCPtr, variable);
    RateRule ret = (cPtr == global::System.IntPtr.Zero) ? null : new RateRule(cPtr, false);
    return ret;
  }

  
/**
   * Get the nth Constraint object in this Model.
   *
   * @param n the index of the object to return.
   *
   * @return the nth Constraint of this Model.
   */ public
 Constraint getConstraint(long n) {
    global::System.IntPtr cPtr = libsbmlPINVOKE.Model_getConstraint__SWIG_0(swigCPtr, n);
    Constraint ret = (cPtr == global::System.IntPtr.Zero) ? null : new Constraint(cPtr, false);
    return ret;
  }

  
/**
   * Get the nth Reaction object in this Model.
   *
   * @param n the index of the object to return.
   *
   * @return the nth Reaction of this Model.
   */ public
 Reaction getReaction(long n) {
	Reaction ret = (Reaction) libsbml.DowncastSBase(libsbmlPINVOKE.Model_getReaction__SWIG_0(swigCPtr, n), false);
	return ret;
}

  
/**
   * Get a Reaction object based on its identifier.
   *
   * @param sid the identifier to search for.
   *
   * @return the Reaction in this Model with the identifier @p sid or @c null
   * if no such Reaction exists.
   */ public
 Reaction getReaction(string sid) {
	Reaction ret = (Reaction) libsbml.DowncastSBase(libsbmlPINVOKE.Model_getReaction__SWIG_2(swigCPtr, sid), false);
	return ret;
}

  
/**
   * Get a SpeciesReference object based on its identifier.
   *
   * @param sid the identifier to search for.
   *
   * @return the SpeciesReference in this Model with the identifier @p sid or @c null
   * if no such SpeciesReference exists.
   */ public
 SpeciesReference getSpeciesReference(string sid) {
	SpeciesReference ret
	    = (SpeciesReference) libsbml.DowncastSBase(libsbmlPINVOKE.Model_getSpeciesReference__SWIG_0(swigCPtr, sid), false);
	return ret;
}

  
/**
   * Get a ModifierSpeciesReference object based on its identifier.
   *
   * @param sid the identifier to search for.
   *
   * @return the ModifierSpeciesReference in this Model with the 
   * identifier @p sid or @c null
   * if no such ModifierSpeciesReference exists.
   */ public
 ModifierSpeciesReference getModifierSpeciesReference(string sid) {
    global::System.IntPtr cPtr = libsbmlPINVOKE.Model_getModifierSpeciesReference__SWIG_0(swigCPtr, sid);
    ModifierSpeciesReference ret = (cPtr == global::System.IntPtr.Zero) ? null : new ModifierSpeciesReference(cPtr, false);
    return ret;
  }

  
/**
   * Get the nth Event object in this Model.
   *
   * @param n the index of the object to return.
   *
   * @return the nth Event of this Model.
   */ public
 Event getEvent(long n) {
    global::System.IntPtr cPtr = libsbmlPINVOKE.Model_getEvent__SWIG_0(swigCPtr, n);
    Event ret = (cPtr == global::System.IntPtr.Zero) ? null : new Event(cPtr, false);
    return ret;
  }

  
/**
   * Get an Event object based on its identifier.
   *
   * @param sid the identifier to search for.
   *
   * @return the Event in this Model with the identifier @p sid or @c null if
   * no such Event exists.
   */ public
 Event getEvent(string sid) {
    global::System.IntPtr cPtr = libsbmlPINVOKE.Model_getEvent__SWIG_2(swigCPtr, sid);
    Event ret = (cPtr == global::System.IntPtr.Zero) ? null : new Event(cPtr, false);
    return ret;
  }

  
/**
   * Get the number of FunctionDefinition objects in this Model.
   *
   * @return the number of FunctionDefinitions in this Model.
   */ public
 long getNumFunctionDefinitions() { return (long)libsbmlPINVOKE.Model_getNumFunctionDefinitions(swigCPtr); }

  
/**
   * Get the number of UnitDefinition objects in this Model.
   *
   * @return the number of UnitDefinitions in this Model.
   */ public
 long getNumUnitDefinitions() { return (long)libsbmlPINVOKE.Model_getNumUnitDefinitions(swigCPtr); }

  
/**
   * Get the number of CompartmentType objects in this Model.
   *
   * @return the number of CompartmentTypes in this Model.
   *
   * @note The CompartmentType object class is only available in SBML
   * Level&nbsp;2 Versions&nbsp;2&ndash;4.  It is not available in
   * Level&nbsp;1 nor Level&nbsp;3.
   */ public
 long getNumCompartmentTypes() { return (long)libsbmlPINVOKE.Model_getNumCompartmentTypes(swigCPtr); }

  
/**
   * Get the number of SpeciesType objects in this Model.
   *
   * @return the number of SpeciesTypes in this Model.
   *
   * @note The SpeciesType object class is only available in SBML
   * Level&nbsp;2 Versions&nbsp;2&ndash;4.  It is not available in
   * Level&nbsp;1 nor Level&nbsp;3.
   */ public
 long getNumSpeciesTypes() { return (long)libsbmlPINVOKE.Model_getNumSpeciesTypes(swigCPtr); }

  
/**
   * Get the number of Compartment objects in this Model.
   *
   * @return the number of Compartments in this Model.
   */ public
 long getNumCompartments() { return (long)libsbmlPINVOKE.Model_getNumCompartments(swigCPtr); }

  
/**
   * Get the number of Species objects in this Model.
   *
   * @return the number of Species in this Model.
   */ public
 long getNumSpecies() { return (long)libsbmlPINVOKE.Model_getNumSpecies(swigCPtr); }

  
/**
   * Get the number of Species in this Model having their
   * 'boundaryCondition' attribute value set to @c true.
   *
   * @return the number of Species in this Model with boundaryCondition set
   * to true.
   */ public
 long getNumSpeciesWithBoundaryCondition() { return (long)libsbmlPINVOKE.Model_getNumSpeciesWithBoundaryCondition(swigCPtr); }

  
/**
   * Get the number of Parameter objects in this Model.
   *
   * @return the number of Parameters in this Model.  Parameters defined in
   * KineticLaws are not included.
   */ public
 long getNumParameters() { return (long)libsbmlPINVOKE.Model_getNumParameters(swigCPtr); }

  
/**
   * Get the number of InitialAssignment objects in this Model.
   *
   * @return the number of InitialAssignments in this Model.
   */ public
 long getNumInitialAssignments() { return (long)libsbmlPINVOKE.Model_getNumInitialAssignments(swigCPtr); }

  
/**
   * Get the number of Rule objects in this Model.
   *
   * @return the number of Rules in this Model.
   */ public
 long getNumRules() { return (long)libsbmlPINVOKE.Model_getNumRules(swigCPtr); }

  
/**
   * Get the number of Constraint objects in this Model.
   *
   * @return the number of Constraints in this Model.
   */ public
 long getNumConstraints() { return (long)libsbmlPINVOKE.Model_getNumConstraints(swigCPtr); }

  
/**
   * Get the number of Reaction objects in this Model.
   *
   * @return the number of Reactions in this Model.
   */ public
 long getNumReactions() { return (long)libsbmlPINVOKE.Model_getNumReactions(swigCPtr); }

  
/**
   * Get the number of Event objects in this Model.
   *
   * @return the number of Events in this Model.
   */ public
 long getNumEvents() { return (long)libsbmlPINVOKE.Model_getNumEvents(swigCPtr); }

  
/**
   * Remove this Model from its parent SBMLDocument object.
   *
   * This works by finding this Model's parent SBMLDocument and then calling
   * <code>setModel(null)</code> on it, indirectly deleting itself.
   * Overridden from the SBase function since the parent is not a ListOf.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
   */ public new
 int removeFromParentAndDelete() {
    int ret = libsbmlPINVOKE.Model_removeFromParentAndDelete(swigCPtr);
    return ret;
  }

  
/** */ /* libsbml-internal */ public new
 int renameAllIds(IdentifierTransformer idTransformer, ElementFilter filter) {
    int ret = libsbmlPINVOKE.Model_renameAllIds__SWIG_0(swigCPtr, IdentifierTransformer.getCPtr(idTransformer), ElementFilter.getCPtr(filter));
    return ret;
  }

  
/** */ /* libsbml-internal */ public new
 int renameAllIds(IdentifierTransformer idTransformer) {
    int ret = libsbmlPINVOKE.Model_renameAllIds__SWIG_1(swigCPtr, IdentifierTransformer.getCPtr(idTransformer));
    return ret;
  }

  
/**
   *
 * Replaces all uses of a given @c SIdRef type attribute value with another
 * value.
 *
 *
 * 

 * In SBML, object identifiers are of a data type called <code>SId</code>.
 * In SBML Level&nbsp;3, an explicit data type called <code>SIdRef</code> was
 * introduced for attribute values that refer to <code>SId</code> values; in
 * previous Levels of SBML, this data type did not exist and attributes were
 * simply described to as 'referring to an identifier', but the effective
 * data type was the same as <code>SIdRef</code> in Level&nbsp;3.  These and
 * other methods of libSBML refer to the type <code>SIdRef</code> for all
 * Levels of SBML, even if the corresponding SBML specification did not
 * explicitly name the data type.
 *
 *
 *
 * This method works by looking at all attributes and (if appropriate)
 * mathematical formulas in MathML content, comparing the referenced
 * identifiers to the value of @p oldid.  If any matches are found, the
 * matching values are replaced with @p newid.  The method does @em not
 * descend into child elements.
 *
 * @param oldid the old identifier.
 * @param newid the new identifier.
 *
 *
   */ public new
 void renameSIdRefs(string oldid, string newid) {
    libsbmlPINVOKE.Model_renameSIdRefs(swigCPtr, oldid, newid);
  }

  
/**
   *
 * Replaces all uses of a given @c UnitSIdRef type attribute value with
 * another value.
 *
 *
 * 
 * In SBML, unit definitions have identifiers of type <code>UnitSId</code>.  In
 * SBML Level&nbsp;3, an explicit data type called <code>UnitSIdRef</code> was
 * introduced for attribute values that refer to <code>UnitSId</code> values; in
 * previous Levels of SBML, this data type did not exist and attributes were
 * simply described to as 'referring to a unit identifier', but the effective
 * data type was the same as <code>UnitSIdRef</code> in Level&nbsp;3.  These and
 * other methods of libSBML refer to the type <code>UnitSIdRef</code> for all
 * Levels of SBML, even if the corresponding SBML specification did not
 * explicitly name the data type.
 *
 *
 *
 * This method works by looking at all unit identifier attribute values
 * (including, if appropriate, inside mathematical formulas), comparing the
 * referenced unit identifiers to the value of @p oldid.  If any matches
 * are found, the matching values are replaced with @p newid.  The method
 * does @em not descend into child elements.
 *
 * @param oldid the old identifier.
 * @param newid the new identifier.
 *
 *
   */ public new
 void renameUnitSIdRefs(string oldid, string newid) {
    libsbmlPINVOKE.Model_renameUnitSIdRefs(swigCPtr, oldid, newid);
  }

  
/** */ /* libsbml-internal */ public
 void convertL1ToL2() {
    libsbmlPINVOKE.Model_convertL1ToL2(swigCPtr);
  }

  
/** */ /* libsbml-internal */ public
 void convertL1ToL3(bool addDefaultUnits) {
    libsbmlPINVOKE.Model_convertL1ToL3__SWIG_0(swigCPtr, addDefaultUnits);
  }

  
/** */ /* libsbml-internal */ public
 void convertL1ToL3() {
    libsbmlPINVOKE.Model_convertL1ToL3__SWIG_1(swigCPtr);
  }

  
/** */ /* libsbml-internal */ public
 void convertL2ToL3(bool strict, bool addDefaultUnits) {
    libsbmlPINVOKE.Model_convertL2ToL3__SWIG_0(swigCPtr, strict, addDefaultUnits);
  }

  
/** */ /* libsbml-internal */ public
 void convertL2ToL3(bool strict) {
    libsbmlPINVOKE.Model_convertL2ToL3__SWIG_1(swigCPtr, strict);
  }

  
/** */ /* libsbml-internal */ public
 void convertL2ToL3() {
    libsbmlPINVOKE.Model_convertL2ToL3__SWIG_2(swigCPtr);
  }

  
/** */ /* libsbml-internal */ public
 void convertL2ToL1(bool strict) {
    libsbmlPINVOKE.Model_convertL2ToL1__SWIG_0(swigCPtr, strict);
  }

  
/** */ /* libsbml-internal */ public
 void convertL2ToL1() {
    libsbmlPINVOKE.Model_convertL2ToL1__SWIG_1(swigCPtr);
  }

  
/** */ /* libsbml-internal */ public
 void convertL3ToL1(bool strict) {
    libsbmlPINVOKE.Model_convertL3ToL1__SWIG_0(swigCPtr, strict);
  }

  
/** */ /* libsbml-internal */ public
 void convertL3ToL1() {
    libsbmlPINVOKE.Model_convertL3ToL1__SWIG_1(swigCPtr);
  }

  
/** */ /* libsbml-internal */ public
 void convertL3ToL2(bool strict) {
    libsbmlPINVOKE.Model_convertL3ToL2__SWIG_0(swigCPtr, strict);
  }

  
/** */ /* libsbml-internal */ public
 void convertL3ToL2() {
    libsbmlPINVOKE.Model_convertL3ToL2__SWIG_1(swigCPtr);
  }

  
/** */ /* libsbml-internal */ public
 void convertFromL3V2(bool strict) {
    libsbmlPINVOKE.Model_convertFromL3V2__SWIG_0(swigCPtr, strict);
  }

  
/** */ /* libsbml-internal */ public
 void convertFromL3V2() {
    libsbmlPINVOKE.Model_convertFromL3V2__SWIG_1(swigCPtr);
  }

  
/** */ /* libsbml-internal */ public
 void dealWithFast() {
    libsbmlPINVOKE.Model_dealWithFast(swigCPtr);
  }

  
/** */ /* libsbml-internal */ public
 void dealWithL3Fast(long targetVersion) {
    libsbmlPINVOKE.Model_dealWithL3Fast(swigCPtr, targetVersion);
  }

  
/** */ /* libsbml-internal */ public
 void addModifiers() {
    libsbmlPINVOKE.Model_addModifiers(swigCPtr);
  }

  
/** */ /* libsbml-internal */ public
 void addConstantAttribute() {
    libsbmlPINVOKE.Model_addConstantAttribute(swigCPtr);
  }

  
/** */ /* libsbml-internal */ public
 void setSpatialDimensions(double dims) {
    libsbmlPINVOKE.Model_setSpatialDimensions__SWIG_0(swigCPtr, dims);
  }

  
/** */ /* libsbml-internal */ public
 void setSpatialDimensions() {
    libsbmlPINVOKE.Model_setSpatialDimensions__SWIG_1(swigCPtr);
  }

  
/** */ /* libsbml-internal */ public
 void addDefinitionsForDefaultUnits() {
    libsbmlPINVOKE.Model_addDefinitionsForDefaultUnits(swigCPtr);
  }

  
/** */ /* libsbml-internal */ public
 void dealWithDefaultValues() {
    libsbmlPINVOKE.Model_dealWithDefaultValues(swigCPtr);
  }

  
/** */ /* libsbml-internal */ public
 void convertParametersToLocals(long level, long version) {
    libsbmlPINVOKE.Model_convertParametersToLocals(swigCPtr, level, version);
  }

  
/** */ /* libsbml-internal */ public
 void setSpeciesReferenceConstantValueAndStoichiometry() {
    libsbmlPINVOKE.Model_setSpeciesReferenceConstantValueAndStoichiometry(swigCPtr);
  }

  
/** */ /* libsbml-internal */ public
 void removeParameterRuleUnits(bool strict) {
    libsbmlPINVOKE.Model_removeParameterRuleUnits(swigCPtr, strict);
  }

  
/** */ /* libsbml-internal */ public
 void convertStoichiometryMath() {
    libsbmlPINVOKE.Model_convertStoichiometryMath(swigCPtr);
  }

  
/** */ /* libsbml-internal */ public
 void assignRequiredValues() {
    libsbmlPINVOKE.Model_assignRequiredValues(swigCPtr);
  }

  
/** */ /* libsbml-internal */ public
 void dealWithModelUnits(bool strict) {
    libsbmlPINVOKE.Model_dealWithModelUnits__SWIG_0(swigCPtr, strict);
  }

  
/** */ /* libsbml-internal */ public
 void dealWithModelUnits() {
    libsbmlPINVOKE.Model_dealWithModelUnits__SWIG_1(swigCPtr);
  }

  
/** */ /* libsbml-internal */ public
 void dealWithStoichiometry() {
    libsbmlPINVOKE.Model_dealWithStoichiometry(swigCPtr);
  }

  
/** */ /* libsbml-internal */ public
 void dealWithEvents(bool strict) {
    libsbmlPINVOKE.Model_dealWithEvents(swigCPtr, strict);
  }

  
/** */ /* libsbml-internal */ public
 void removeSpeciesTypes() {
    libsbmlPINVOKE.Model_removeSpeciesTypes(swigCPtr);
  }

  
/** */ /* libsbml-internal */ public
 void removeCompartmentTypes() {
    libsbmlPINVOKE.Model_removeCompartmentTypes(swigCPtr);
  }

  public override void connectToChild() {
    libsbmlPINVOKE.Model_connectToChild(swigCPtr);
  }

  
/**
   * Returns the libSBML type code for this %SBML object.
   *
   *
 * 
 * LibSBML attaches an identifying code to every kind of SBML object.  These
 * are integer constants known as <em>SBML type codes</em>.  The names of all
 * the codes begin with the characters <code>SBML_</code>.
 * @if clike The set of possible type codes for core elements is defined in
 * the enumeration #SBMLTypeCode_t, and in addition, libSBML plug-ins for
 * SBML Level&nbsp;3 packages define their own extra enumerations of type
 * codes (e.g., #SBMLLayoutTypeCode_t for the Level&nbsp;3 Layout
 * package).@endif@if java In the Java language interface for libSBML, the
 * type codes are defined as static integer constants in the interface class
 * {@link libsbmlConstants}.  @endif@if python In the Python language
 * interface for libSBML, the type codes are defined as static integer
 * constants in the interface class @link libsbml@endlink.@endif@if csharp In
 * the C# language interface for libSBML, the type codes are defined as
 * static integer constants in the interface class
 * @link libsbmlcs.libsbml@endlink.@endif  Note that different Level&nbsp;3
 * package plug-ins may use overlapping type codes; to identify the package
 * to which a given object belongs, call the 
 * <code>@if conly SBase_getPackageName()
 * @else SBase::getPackageName()
 * @endif</code>
 * method on the object.
 *
 *
   *
   * @return the SBML type code for this object:
   * @link libsbml#SBML_MODEL SBML_MODEL@endlink (default).
   *
   *
 * @warning <span class='warning'>The specific integer values of the possible
 * type codes may be reused by different libSBML plug-ins for SBML Level&nbsp;3.
 * packages,  To fully identify the correct code, <strong>it is necessary to
 * invoke both getTypeCode() and getPackageName()</strong>.</span>
 *
 *
   *
   * @see getElementName()
   * @see getPackageName()
   */ public new
 int getTypeCode() {
    int ret = libsbmlPINVOKE.Model_getTypeCode(swigCPtr);
    return ret;
  }

  
/**
   * Returns the XML element name of this object, which for Model, is
   * always @c 'model'.
   *
   * @return the name of this element, i.e., @c 'model'.
   */ public new
 string getElementName() {
    string ret = libsbmlPINVOKE.Model_getElementName(swigCPtr);
    return ret;
  }

  
/**
   * Populates the internal list of derived units for this Model object.
   *
   * This method tells libSBML to (re)calculate all units for all components
   * of the enclosing Model object.  The result is stored in an internal list
   * of unit data.  Users can access the resulting data by calling the method
   * SBase::getDerivedUnitDefinition() available on most objects.  (The name
   * 'formula units data' is drawn from the name of the internal objects
   * libSBML uses to store the data; note that these internal objects are not
   * exposed to callers, because callers can interact with the results using
   * the ordinary SBML unit objects.)
   *
   * This method is used by libSBML itself in the validator concerned with
   * unit consistency.  The unit consistency validator (like all other
   * validators in libSBML) is invoked by using
   * SBMLDocument::checkConsistency(), with the consistency checks for the
   * category @link libsbml#LIBSBML_CAT_UNITS_CONSISTENCY LIBSBML_CAT_UNITS_CONSISTENCY@endlink turned on.  The method
   * populateListFormulaUnitsData() does not need to be called prior to
   * invoking the validator if unit consistency checking has not been turned
   * off.  This method is only provided for cases when callers have a special
   * need to force the unit data to be recalculated.  For instance, during
   * construction of a model, a caller may want to interrogate libSBML's
   * inferred units without invoking full-blown model validation; this is a
   * scenario in which calling populateListFormulaUnitsData() may be useful.
   *
   * @warning Computing and inferring units is a time-consuming operation.
   * Callers may want to call isPopulatedListFormulaUnitsData() to determine
   * whether the units may already have been computed, to save themselves the
   * need of invoking unit inference unnecessarily.
   *
   * @see isPopulatedListFormulaUnitsData()
   */ public
 void populateListFormulaUnitsData() {
    libsbmlPINVOKE.Model_populateListFormulaUnitsData(swigCPtr);
  }

  
/**
   * Predicate returning @c true if libSBML has derived units for the
   * components of this model.
   *
   * LibSBML can infer the units of measurement associated with different
   * elements of a model.  When libSBML does that, it builds a complex
   * internal structure during a resource-intensive operation.  This is done
   * automatically only when callers invoke validation (via
   * SBMLDocument::checkConsistency()) and have not turned off the unit
   * validation option.
   *
   * Callers can force units to be recalculated by calling
   * populateListFormulaUnitsData().  To avoid calling that method
   * unnecessarily, calling programs may first want to invoke this method
   * (isPopulatedListFormulaUnitsData()) to determine whether it is even
   * necessary.
   *
   * @return @c true if the units have already been computed, @c false
   * otherwise.
   */ public
 bool isPopulatedListFormulaUnitsData() {
    bool ret = libsbmlPINVOKE.Model_isPopulatedListFormulaUnitsData(swigCPtr);
    return ret;
  }

  
/** */ /* libsbml-internal */ public
 SWIGTYPE_p_FormulaUnitsData getFormulaUnitsDataForVariable(string sid) {
    global::System.IntPtr cPtr = libsbmlPINVOKE.Model_getFormulaUnitsDataForVariable(swigCPtr, sid);
    SWIGTYPE_p_FormulaUnitsData ret = (cPtr == global::System.IntPtr.Zero) ? null : new SWIGTYPE_p_FormulaUnitsData(cPtr, false);
    return ret;
  }

  
/** */ /* libsbml-internal */ public
 SWIGTYPE_p_FormulaUnitsData getFormulaUnitsDataForAssignment(string sid) {
    global::System.IntPtr cPtr = libsbmlPINVOKE.Model_getFormulaUnitsDataForAssignment(swigCPtr, sid);
    SWIGTYPE_p_FormulaUnitsData ret = (cPtr == global::System.IntPtr.Zero) ? null : new SWIGTYPE_p_FormulaUnitsData(cPtr, false);
    return ret;
  }

  
/**
   * Populates the internal list of the identifiers of all elements within this Model object.
   *
   * This method tells libSBML to retrieve the identifiers of all elements
   * of the enclosing Model object.  The result is stored in an internal list
   * of ids.  Users can access the resulting data by calling the method
   * getAllElementIdList().
   *
   * @warning Retrieving all elements within a model is a time-consuming operation.
   * Callers may want to call isPopulatedAllElementIdList() to determine
   * whether the id list may already have been populated.
   *
   * @see isPopulatedAllElementIdList()
   */ public
 void populateAllElementIdList() {
    libsbmlPINVOKE.Model_populateAllElementIdList(swigCPtr);
  }

  
/**
   * Predicate returning @c true if libSBML has a list of the ids of all 
   * components of this model.
   *
   * @return @c true if the id list has already been populated, @c false
   * otherwise.
   */ public
 bool isPopulatedAllElementIdList() {
    bool ret = libsbmlPINVOKE.Model_isPopulatedAllElementIdList(swigCPtr);
    return ret;
  }

  
/**
   * Returns the internal list of the identifiers of all elements within this Model object.
   *
   * @return an IdList of all the identifiers in the model.
   *
   * @see populateAllElementIdList()
   * @see isPopulatedAllElementIdList()
   */ public
 IdList getAllElementIdList() {
    IdList ret = new IdList(libsbmlPINVOKE.Model_getAllElementIdList(swigCPtr), true);
    return ret;
  }

  
/**
   * Clears the internal list of the identifiers of all elements within this Model object.
   *
   * @see populateAllElementIdList()
   * @see isPopulatedAllElementIdList()
   */ public
 void clearAllElementIdList() {
    libsbmlPINVOKE.Model_clearAllElementIdList(swigCPtr);
  }

  
/**
   * Populates the internal list of the metaids of all elements within this Model object.
   *
   * This method tells libSBML to retrieve the identifiers of all elements
   * of the enclosing Model object.  The result is stored in an internal list
   * of metaids.  Users can access the resulting data by calling the method
   * getAllElementMetaIdList().
   *
   * @warning Retrieving all elements within a model is a time-consuming operation.
   * Callers may want to call isPopulatedAllElementMetaIdList() to determine
   * whether the metaid list may already have been populated.
   *
   * @see isPopulatedAllElementMetaIdList()
   */ public
 void populateAllElementMetaIdList() {
    libsbmlPINVOKE.Model_populateAllElementMetaIdList(swigCPtr);
  }

  
/**
   * Predicate returning @c true if libSBML has a list of the metaids of all 
   * components of this model.
   *
   * @return @c true if the metaid list has already been populated, @c false
   * otherwise.
   */ public
 bool isPopulatedAllElementMetaIdList() {
    bool ret = libsbmlPINVOKE.Model_isPopulatedAllElementMetaIdList(swigCPtr);
    return ret;
  }

  
/**
   * Returns the internal list of the metaids of all elements within this Model object.
   *
   * @return an IdList of all the metaids in the model.
   *
   * @see populateAllElementMetaIdList()
   * @see isPopulatedAllElementMetaIdList()
   */ public
 IdList getAllElementMetaIdList() {
    IdList ret = new IdList(libsbmlPINVOKE.Model_getAllElementMetaIdList(swigCPtr), true);
    return ret;
  }

  
/**
   * Clears the internal list of the metaids of all elements within this Model object.
   *
   * @see populateAllElementMetaIdList()
   * @see isPopulatedAllElementMetaIdList()
   */ public
 void clearAllElementMetaIdList() {
    libsbmlPINVOKE.Model_clearAllElementMetaIdList(swigCPtr);
  }

  
/**
   * Predicate returning @c true if all the required elements for this Model
   * object have been set.
   *
   * @return a boolean value indicating whether all the required
   * elements for this object have been defined.
   */ public new
 bool hasRequiredElements() {
    bool ret = libsbmlPINVOKE.Model_hasRequiredElements(swigCPtr);
    return ret;
  }

  
/**
   * Removes the nth FunctionDefinition object from this Model object and 
   * returns a pointer to it.
   *
   * The caller owns the returned object and is responsible for deleting it.
   *
   * @param n the index of the FunctionDefinition object to remove.
   *
   * @return the FunctionDefinition object removed, or @c null if the given
   * index is out of range.
   *
   */ public
 FunctionDefinition removeFunctionDefinition(long n) {
    global::System.IntPtr cPtr = libsbmlPINVOKE.Model_removeFunctionDefinition__SWIG_0(swigCPtr, n);
    FunctionDefinition ret = (cPtr == global::System.IntPtr.Zero) ? null : new FunctionDefinition(cPtr, true);
    return ret;
  }

  
/**
   * Removes the FunctionDefinition object with the given identifier from this Model 
   * object and returns a pointer to it.
   *
   * The caller owns the returned object and is responsible for deleting it.
   *
   * @param sid the identifier of the FunctionDefinition object to remove.
   *
   * @return the FunctionDefinition object removed, or @c null if no
   * FunctionDefinition object with the identifier exists in this Model
   * object.
   */ public
 FunctionDefinition removeFunctionDefinition(string sid) {
    global::System.IntPtr cPtr = libsbmlPINVOKE.Model_removeFunctionDefinition__SWIG_1(swigCPtr, sid);
    FunctionDefinition ret = (cPtr == global::System.IntPtr.Zero) ? null : new FunctionDefinition(cPtr, true);
    return ret;
  }

  
/**
   * Removes the nth UnitDefinition object from this Model object and
   * returns a pointer to it.
   *
   * The caller owns the returned object and is responsible for deleting it.
   *
   * @param n the index of the UnitDefinition object to remove.
   *
   * @return the UnitDefinition object removed., or @c null if the given
   * index is out of range.
   *
   */ public
 UnitDefinition removeUnitDefinition(long n) {
    global::System.IntPtr cPtr = libsbmlPINVOKE.Model_removeUnitDefinition__SWIG_0(swigCPtr, n);
    UnitDefinition ret = (cPtr == global::System.IntPtr.Zero) ? null : new UnitDefinition(cPtr, true);
    return ret;
  }

  
/**
   * Removes the UnitDefinition object with the given identifier from this Model
   * object and returns a pointer to it.
   *
   * The caller owns the returned object and is responsible for deleting it.
   *
   * @param sid the identifier of the UnitDefinition object to remove.
   *
   * @return the UnitDefinition object removed, or @c null if no
   * UnitDefinition object with the identifier exists in this Model object.
   */ public
 UnitDefinition removeUnitDefinition(string sid) {
    global::System.IntPtr cPtr = libsbmlPINVOKE.Model_removeUnitDefinition__SWIG_1(swigCPtr, sid);
    UnitDefinition ret = (cPtr == global::System.IntPtr.Zero) ? null : new UnitDefinition(cPtr, true);
    return ret;
  }

  
/**
   * Removes the nth CompartmentType object from this Model object and
   * returns a pointer to it.
   *
   * The caller owns the returned object and is responsible for deleting it.
   *
   * @param n the index of the CompartmentType object to remove.
   *
   * @return the ComapartmentType object removed, or @c null if the given
   * index is out of range.
   *
   */ public
 CompartmentType removeCompartmentType(long n) {
    global::System.IntPtr cPtr = libsbmlPINVOKE.Model_removeCompartmentType__SWIG_0(swigCPtr, n);
    CompartmentType ret = (cPtr == global::System.IntPtr.Zero) ? null : new CompartmentType(cPtr, true);
    return ret;
  }

  
/**
   * Removes the CompartmentType object with the given identifier from this Model
   * object and returns a pointer to it.
   *
   * The caller owns the returned object and is responsible for deleting it.
   *
   * @param sid the identifier of the object to remove.
   *
   * @return the CompartmentType object removed, or @c null if no
   * CompartmentType object with the identifier exists in this Model object.
   */ public
 CompartmentType removeCompartmentType(string sid) {
    global::System.IntPtr cPtr = libsbmlPINVOKE.Model_removeCompartmentType__SWIG_1(swigCPtr, sid);
    CompartmentType ret = (cPtr == global::System.IntPtr.Zero) ? null : new CompartmentType(cPtr, true);
    return ret;
  }

  
/**
   * Removes the nth SpeciesType object from this Model object and
   * returns a pointer to it.
   *
   * The caller owns the returned object and is responsible for deleting it.
   *
   * @param n the index of the SpeciesType object to remove.
   *
   * @return the SpeciesType object removed, or @c null if the given index is
   * out of range.
   *
   */ public
 SpeciesType removeSpeciesType(long n) {
    global::System.IntPtr cPtr = libsbmlPINVOKE.Model_removeSpeciesType__SWIG_0(swigCPtr, n);
    SpeciesType ret = (cPtr == global::System.IntPtr.Zero) ? null : new SpeciesType(cPtr, true);
    return ret;
  }

  
/**
   * Removes the SpeciesType object with the given identifier from this Model
   * object and returns a pointer to it.
   *
   * The caller owns the returned object and is responsible for deleting it.
   *
   * @param sid the identifier of the SpeciesType object to remove.
   *
   * @return the SpeciesType object removed, or @c null if no SpeciesType
   * object with the identifier exists in this Model object.
   *
   */ public
 SpeciesType removeSpeciesType(string sid) {
    global::System.IntPtr cPtr = libsbmlPINVOKE.Model_removeSpeciesType__SWIG_1(swigCPtr, sid);
    SpeciesType ret = (cPtr == global::System.IntPtr.Zero) ? null : new SpeciesType(cPtr, true);
    return ret;
  }

  
/**
   * Removes the nth Compartment object from this Model object and
   * returns a pointer to it.
   *
   * The caller owns the returned object and is responsible for deleting it.
   *
   * @param n the index of the Compartment object to remove.
   *
   * @return the Compartment object removed, or @c null if the given index is
   * out of range.
   *
   */ public
 Compartment removeCompartment(long n) {
    global::System.IntPtr cPtr = libsbmlPINVOKE.Model_removeCompartment__SWIG_0(swigCPtr, n);
    Compartment ret = (cPtr == global::System.IntPtr.Zero) ? null : new Compartment(cPtr, true);
    return ret;
  }

  
/**
   * Removes the Compartment object with the given identifier from this Model
   * object and returns a pointer to it.
   *
   * The caller owns the returned object and is responsible for deleting it.
   *
   * @param sid the identifier of the Compartment object to remove.
   *
   * @return the Compartment object removed, or @c null if no Compartment
   * object with the identifier exists in this Model object.
   */ public
 Compartment removeCompartment(string sid) {
    global::System.IntPtr cPtr = libsbmlPINVOKE.Model_removeCompartment__SWIG_1(swigCPtr, sid);
    Compartment ret = (cPtr == global::System.IntPtr.Zero) ? null : new Compartment(cPtr, true);
    return ret;
  }

  
/**
   * Removes the nth Species object from this Model object and
   * returns a pointer to it.
   *
   * The caller owns the returned object and is responsible for deleting it.
   *
   * @param n the index of the Species object to remove.
   *
   * @return the Species object removed, or @c null if the given index is out
   * of range.
   *
   */ public
 Species removeSpecies(long n) {
    global::System.IntPtr cPtr = libsbmlPINVOKE.Model_removeSpecies__SWIG_0(swigCPtr, n);
    Species ret = (cPtr == global::System.IntPtr.Zero) ? null : new Species(cPtr, true);
    return ret;
  }

  
/**
   * Removes the Species object with the given identifier from this Model
   * object and returns a pointer to it.
   *
   * The caller owns the returned object and is responsible for deleting it.
   *
   * @param sid the identifier of the Species object to remove.
   *
   * @return the Species object removed, or @c null if no Species object with
   * the identifier exists in this Model object.
   *
   */ public
 Species removeSpecies(string sid) {
    global::System.IntPtr cPtr = libsbmlPINVOKE.Model_removeSpecies__SWIG_1(swigCPtr, sid);
    Species ret = (cPtr == global::System.IntPtr.Zero) ? null : new Species(cPtr, true);
    return ret;
  }

  
/**
   * Removes the nth Parameter object from this Model object and
   * returns a pointer to it.
   *
   * The caller owns the returned object and is responsible for deleting it.
   *
   * @param n the index of the Parameter object to remove.
   *
   * @return the Parameter object removed, or @c null if the given index is
   * out of range.
   *
   */ public
 Parameter removeParameter(long n) {
    global::System.IntPtr cPtr = libsbmlPINVOKE.Model_removeParameter__SWIG_0(swigCPtr, n);
    Parameter ret = (cPtr == global::System.IntPtr.Zero) ? null : new Parameter(cPtr, true);
    return ret;
  }

  
/**
   * Removes the Parameter object with the given identifier from this Model
   * object and returns a pointer to it.
   *
   * The caller owns the returned object and is responsible for deleting it.
   *
   * @param sid the identifier of the Parameter object to remove.
   *
   * @return the Parameter object removed, or @c null if no Parameter object
   * with the identifier exists in this Model object.
   */ public
 Parameter removeParameter(string sid) {
    global::System.IntPtr cPtr = libsbmlPINVOKE.Model_removeParameter__SWIG_1(swigCPtr, sid);
    Parameter ret = (cPtr == global::System.IntPtr.Zero) ? null : new Parameter(cPtr, true);
    return ret;
  }

  
/**
   * Removes the nth InitialAssignment object from this Model object and
   * returns a pointer to it.
   *
   * The caller owns the returned object and is responsible for deleting it.
   *
   * @param n the index of the InitialAssignment object to remove.
   *
   * @return the InitialAssignment object removed, or @c null if the given
   * index is out of range.
   *
   */ public
 InitialAssignment removeInitialAssignment(long n) {
    global::System.IntPtr cPtr = libsbmlPINVOKE.Model_removeInitialAssignment__SWIG_0(swigCPtr, n);
    InitialAssignment ret = (cPtr == global::System.IntPtr.Zero) ? null : new InitialAssignment(cPtr, true);
    return ret;
  }

  
/**
   * Removes the InitialAssignment object with the given 'symbol' attribute 
   * from this Model object and returns a pointer to it.
   *
   * The caller owns the returned object and is responsible for deleting it.
   *
   * @param symbol the 'symbol' attribute of the InitialAssignment object to remove.
   *
   * @return the InitialAssignment object removed, or @c null if no
   * InitialAssignment object with the 'symbol' attribute exists in this
   * Model object.
   */ public
 InitialAssignment removeInitialAssignment(string symbol) {
    global::System.IntPtr cPtr = libsbmlPINVOKE.Model_removeInitialAssignment__SWIG_1(swigCPtr, symbol);
    InitialAssignment ret = (cPtr == global::System.IntPtr.Zero) ? null : new InitialAssignment(cPtr, true);
    return ret;
  }

  
/**
   * Removes the nth Rule object from this Model object and
   * returns a pointer to it.
   *
   * The caller owns the returned object and is responsible for deleting it.
   *
   * @param n the index of the Rule object to remove.
   *
   * @return the Rule object removed, or @c null if the given index is out of
   * range.
   *
   */ public
 Rule removeRule(long n) {
        Rule ret = (Rule) libsbml.DowncastSBase(libsbmlPINVOKE.Model_removeRule__SWIG_0(swigCPtr, n), true);
	return ret;
}

  
/**
   * Removes the Rule object with the given 'variable' attribute from this Model 
   * object and returns a pointer to it.
   *
   * The caller owns the returned object and is responsible for deleting it.
   *
   * @param variable the 'variable' attribute of the Rule object to remove.
   *
   * @return the Rule object removed, or @c null if no Rule object with the
   * 'variable' attribute exists in this Model object.
   */ public
 Rule removeRule(string variable) {
        Rule ret = (Rule) libsbml.DowncastSBase(libsbmlPINVOKE.Model_removeRule__SWIG_1(swigCPtr, variable), true);
	return ret;
}

  
/**
   * Removes the Rule object with the given 'variable' attribute from this Model 
   * object and returns a pointer to it.
   *
   * The caller owns the returned object and is responsible for deleting it.
   *
   * @param variable the 'variable' attribute of the Rule object to remove.
   *
   * @return the Rule object removed, or @c null if no Rule object with the
   * 'variable' attribute exists in this Model object.
   */ public
 Rule removeRuleByVariable(string variable) {
        Rule ret = (Rule) libsbml.DowncastSBase(libsbmlPINVOKE.Model_removeRuleByVariable(swigCPtr, variable), false);
	return ret;
}

  
/**
   * Removes the nth Constraint object from this Model object and
   * returns a pointer to it.
   *
   * The caller owns the returned object and is responsible for deleting it.
   *
   * @param n the index of the Constraint object to remove.
   *
   * @return the Constraint object removed, or @c null if the given index is
   * out of range.
   *
   */ public
 Constraint removeConstraint(long n) {
    global::System.IntPtr cPtr = libsbmlPINVOKE.Model_removeConstraint(swigCPtr, n);
    Constraint ret = (cPtr == global::System.IntPtr.Zero) ? null : new Constraint(cPtr, true);
    return ret;
  }

  
/**
   * Removes the nth Reaction object from this Model object and
   * returns a pointer to it.
   *
   * The caller owns the returned object and is responsible for deleting it.
   *
   * @param n the index of the Reaction object to remove.
   *
   * @return the Reaction object removed, or @c null if the given index is
   * out of range.
   *
   */ public
 Reaction removeReaction(long n) {
	Reaction ret = (Reaction) libsbml.DowncastSBase(libsbmlPINVOKE.Model_removeReaction__SWIG_0(swigCPtr, n), true);
	return ret;
}

  
/**
   * Removes the Reaction object with the given identifier from this Model
   * object and returns a pointer to it.
   *
   * The caller owns the returned object and is responsible for deleting it.
   *
   * @param sid the identifier of the Reaction object to remove.
   *
   * @return the Reaction object removed, or @c null if no Reaction object
   * with the identifier exists in this Model object.
   *
   */ public
 Reaction removeReaction(string sid) {
	Reaction ret = (Reaction) libsbml.DowncastSBase(libsbmlPINVOKE.Model_removeReaction__SWIG_1(swigCPtr, sid), true);
	return ret;
}

  
/**
   * Removes the nth Event object from this Model object and
   * returns a pointer to it.
   *
   * The caller owns the returned object and is responsible for deleting it.
   *
   * @param n the index of the Event object to remove.
   *
   * @return the Event object removed, or @c null if the given index is out
   * of range.
   *
   */ public
 Event removeEvent(long n) {
    global::System.IntPtr cPtr = libsbmlPINVOKE.Model_removeEvent__SWIG_0(swigCPtr, n);
    Event ret = (cPtr == global::System.IntPtr.Zero) ? null : new Event(cPtr, true);
    return ret;
  }

  
/**
   * Removes the Event object with the given identifier from this Model
   * object and returns a pointer to it.
   *
   * The caller owns the returned object and is responsible for deleting it.
   *
   * @param sid the identifier of the Event object to remove.
   *
   * @return the Event object removed, or @c null if no Event object with the
   * identifier exists in this Model object.
   *
   */ public
 Event removeEvent(string sid) {
    global::System.IntPtr cPtr = libsbmlPINVOKE.Model_removeEvent__SWIG_1(swigCPtr, sid);
    Event ret = (cPtr == global::System.IntPtr.Zero) ? null : new Event(cPtr, true);
    return ret;
  }

  
/**
   * Copies a given Model object's subcomponents and appends the copies to
   * the appropriate places in this Model.
   *
   * This method also calls the <code>appendFrom</code> method on all libSBML
   * plug-in objects.
   *
   *
 * 
 * SBML Level&nbsp;3 consists of a <em>Core</em> definition that can be extended
 * via optional SBML Level&nbsp;3 <em>packages</em>.  A given model may indicate
 * that it uses one or more SBML packages, and likewise, a software tool may be
 * able to support one or more packages.  LibSBML does not come preconfigured
 * with all possible packages included and enabled, in part because not all
 * package specifications have been finalized.  To support the ability for
 * software systems to enable support for the Level&nbsp;3 packages they choose,
 * libSBML features a <em>plug-in</em> mechanism.  Each SBML Level&nbsp;3
 * package is implemented in a separate code plug-in that can be enabled by the
 * application to support working with that SBML package.  A given SBML model
 * may thus contain not only objects defined by SBML Level&nbsp;3 Core, but also
 * objects created by libSBML plug-ins supporting additional Level&nbsp;3
 * packages.
 *
 *
   *
   * @param model the Model to merge with this one.
   *
   */ public new
 int appendFrom(Model model) {
    int ret = libsbmlPINVOKE.Model_appendFrom(swigCPtr, Model.getCPtr(model));
    return ret;
  }

  
/** */ /* libsbml-internal */ public new
 void enablePackageInternal(string pkgURI, string pkgPrefix, bool flag) {
    libsbmlPINVOKE.Model_enablePackageInternal(swigCPtr, pkgURI, pkgPrefix, flag);
  }

  public void renameIDs(SBaseList elements, IdentifierTransformer idTransformer) {
    libsbmlPINVOKE.Model_renameIDs(swigCPtr, SBaseList.getCPtr(elements), IdentifierTransformer.getCPtr(idTransformer));
  }

}

}
