/**
 * Mandelbulber v2, a 3D fractal generator  _%}}i*<.        ____                _______
 * Copyright (C) 2018 Mandelbulber Team   _>]|=||i=i<,     / __ \___  ___ ___  / ___/ /
 *                                        \><||i|=>>%)    / /_/ / _ \/ -_) _ \/ /__/ /__
 * This file is part of Mandelbulber.     )<=i=]=|=i<>    \____/ .__/\__/_//_/\___/____/
 * The project is licensed under GPLv3,   -<>>=|><|||`        /_/
 * see also COPYING file in this folder.    ~+{i%+++
 *
 * benesiFastPwr2PineTree 3D
 * @reference
 * http://www.fractalforums.com/new-theories-and-research/
 * do-m3d-formula-have-to-be-distance-estimation-formulas/

 * This file has been autogenerated by tools/populateUiInformation.php
 * from the function "BenesiPineTreeIteration" in the file fractal_formulas.cpp
 * D O    N O T    E D I T    T H I S    F I L E !
 */

REAL4 BenesiPineTreeIteration(REAL4 z, __constant sFractalCl *fractal, sExtendedAuxCl *aux)
{
	REAL4 c = aux->const_c * fractal->transformCommon.constantMultiplier100;
	REAL4 zz = z * z;
	aux->r = native_sqrt(zz.x + zz.y + zz.z); // needed when alternating pwr2s
	aux->DE = mad(aux->r * aux->DE, 2.0f, 1.0f);

	REAL t = 1.0f;
	REAL temp = zz.y + zz.z;
	if (temp > 0.0f) t = 2.0f * native_divide(z.x, native_sqrt(temp));
	temp = z.z;
	z.x = (zz.x - zz.y - zz.z);
	z.y = (2.0f * t * z.y * temp);
	z.z = (t * (zz.y - zz.z));
	// c.yz swap
	z.x += c.x;
	z.z += c.y;
	z.y += c.z;

	if (fractal->transformCommon.angle0 != 0)
	{
		REAL tempY = z.y;
		REAL beta = fractal->transformCommon.angle0 * M_PI_180;
		z.y = mad(z.y, native_cos(beta), z.z * native_sin(beta));
		z.z = mad(tempY, -native_sin(beta), z.z * native_cos(beta));
	}
	return z;
}