/*
 * Copyright (C) 2025 The Phosh Developers
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#pragma once

#include <gio/gio.h>

G_BEGIN_DECLS

void        cbd_service_providers_get_channels (const char          *serviceproviders,
                                                const char          *country,
                                                GCancellable        *cancellable,
                                                GAsyncReadyCallback  callback,
                                                gpointer             user_data);
GArray *    cbd_service_provider_get_channels_finish (GAsyncResult *res,
                                                      GError      **error);
GArray *    cbd_service_provider_get_channels_sync (const char *serviceproviders,
                                                    const char *country,
                                                    GError    **error) G_GNUC_WARN_UNUSED_RESULT;


G_END_DECLS
