# coding=utf-8
# Copyright (c) 2015-2016, 2019 Intel Corporation

# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:

# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.

# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
# SOFTWARE.

"""Tests for the exceptions module."""

import pytest

from framework import exceptions

# Good test names often are not PEP8
# pylint: disable=invalid-name


@pytest.mark.raises(exception=SystemExit)
@exceptions.handler
def test_handle_PiglitFatalError():
    """exceptions.handler: Handles PiglitFatalError"""
    raise exceptions.PiglitFatalError


@pytest.mark.raises(exception=SystemExit)
@exceptions.handler
def test_handle_PiglitAbort():
    """exceptions.handler: Handles PiglitAbort"""
    raise exceptions.PiglitAbort


@pytest.mark.raises(exception=SystemExit)
@exceptions.handler
def test_handle_PiglitUserError():
    """exceptions.handler: Handles PiglitUserError"""
    raise exceptions.PiglitUserError


@exceptions.handler
def f1():
    pass


@exceptions.handler
def f2(param):
    return param + 1


@exceptions.handler
def f3(param, unused):
    return param, len(param)


@pytest.mark.parametrize("function, param, expected", [
    (f1, (), None),
    (f2, 2, 3),
    (f2, 5, 6),
    (f3, ("testing", 1), ("testing", 7)),
    (f3, ("more testing", 2), ("more testing", 12)),
])
def test_handle_return(function, param, expected):
    if type(param) is tuple:
        value = function(*param)
    else:
        value = function(param)
    assert value == expected
