/*
 * Copyright (c) 2009 The Chromium Authors. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 *    * Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 *    * Redistributions in binary form must reproduce the above
 * copyright notice, this list of conditions and the following disclaimer
 * in the documentation and/or other materials provided with the
 * distribution.
 *    * Neither the name of Google Inc. nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

// Modified from
//
//   https://raw.githubusercontent.com/KhronosGroup/WebGL/master/sdk/demos/google/shiny-teapot/teapot-streams.js

// Disable auto-formatting to get multiple values per line
// clang-format off

static const float teapot_positions[] = {
    17.83489990234375f, 0.0f, 30.573999404907227f,
    16.452699661254883f, -7.000179767608643f, 30.573999404907227f,
    16.223100662231445f, -6.902520179748535f, 31.51460075378418f,
    17.586000442504883f, 0.0f, 31.51460075378418f,
    16.48940086364746f, -7.015810012817383f, 31.828100204467773f,
    17.87470054626465f, 0.0f, 31.828100204467773f,
    17.031099319458008f, -7.246280193328857f, 31.51460075378418f,
    18.46190071105957f, 0.0f, 31.51460075378418f,
    17.62779998779297f, -7.500199794769287f, 30.573999404907227f,
    19.108800888061523f, 0.0f, 30.573999404907227f,
    12.662699699401855f, -12.662699699401855f, 30.573999404907227f,
    12.486100196838379f, -12.486100196838379f, 31.51460075378418f,
    12.690999984741211f, -12.690999984741211f, 31.828100204467773f,
    13.10789966583252f, -13.10789966583252f, 31.51460075378418f,
    13.56719970703125f, -13.56719970703125f, 30.573999404907227f,
    7.000179767608643f, -16.452699661254883f, 30.573999404907227f,
    6.902520179748535f, -16.223100662231445f, 31.51460075378418f,
    7.015810012817383f, -16.48940086364746f, 31.828100204467773f,
    7.246280193328857f, -17.031099319458008f, 31.51460075378418f,
    7.500199794769287f, -17.62779998779297f, 30.573999404907227f,
    0.0f, -17.83489990234375f, 30.573999404907227f,
    0.0f, -17.586000442504883f, 31.51460075378418f,
    0.0f, -17.87470054626465f, 31.828100204467773f,
    0.0f, -18.46190071105957f, 31.51460075378418f,
    0.0f, -19.108800888061523f, 30.573999404907227f,
    0.0f, -17.83489990234375f, 30.573999404907227f,
    -7.483870029449463f, -16.452699661254883f, 30.573999404907227f,
    -7.106579780578613f, -16.223100662231445f, 31.51460075378418f,
    0.0f, -17.586000442504883f, 31.51460075378418f,
    -7.07627010345459f, -16.48940086364746f, 31.828100204467773f,
    0.0f, -17.87470054626465f, 31.828100204467773f,
    -7.25383996963501f, -17.031099319458008f, 31.51460075378418f,
    0.0f, -18.46190071105957f, 31.51460075378418f,
    -7.500199794769287f, -17.62779998779297f, 30.573999404907227f,
    0.0f, -19.108800888061523f, 30.573999404907227f,
    -13.092700004577637f, -12.662699699401855f, 30.573999404907227f,
    -12.667499542236328f, -12.486100196838379f, 31.51460075378418f,
    -12.744799613952637f, -12.690999984741211f, 31.828100204467773f,
    -13.11460018157959f, -13.10789966583252f, 31.51460075378418f,
    -13.56719970703125f, -13.56719970703125f, 30.573999404907227f,
    -16.61389923095703f, -7.000179767608643f, 30.573999404907227f,
    -16.291099548339844f, -6.902520179748535f, 31.51460075378418f,
    -16.50950050354004f, -7.015810012817383f, 31.828100204467773f,
    -17.033599853515625f, -7.246280193328857f, 31.51460075378418f,
    -17.62779998779297f, -7.500199794769287f, 30.573999404907227f,
    -17.83489990234375f, 0.0f, 30.573999404907227f,
    -17.586000442504883f, 0.0f, 31.51460075378418f,
    -17.87470054626465f, 0.0f, 31.828100204467773f,
    -18.46190071105957f, 0.0f, 31.51460075378418f,
    -19.108800888061523f, 0.0f, 30.573999404907227f,
    -17.83489990234375f, 0.0f, 30.573999404907227f,
    -16.452699661254883f, 7.000179767608643f, 30.573999404907227f,
    -16.223100662231445f, 6.902520179748535f, 31.51460075378418f,
    -17.586000442504883f, 0.0f, 31.51460075378418f,
    -16.48940086364746f, 7.015810012817383f, 31.828100204467773f,
    -17.87470054626465f, 0.0f, 31.828100204467773f,
    -17.031099319458008f, 7.246280193328857f, 31.51460075378418f,
    -18.46190071105957f, 0.0f, 31.51460075378418f,
    -17.62779998779297f, 7.500199794769287f, 30.573999404907227f,
    -19.108800888061523f, 0.0f, 30.573999404907227f,
    -12.662699699401855f, 12.662699699401855f, 30.573999404907227f,
    -12.486100196838379f, 12.486100196838379f, 31.51460075378418f,
    -12.690999984741211f, 12.690999984741211f, 31.828100204467773f,
    -13.10789966583252f, 13.10789966583252f, 31.51460075378418f,
    -13.56719970703125f, 13.56719970703125f, 30.573999404907227f,
    -7.000179767608643f, 16.452699661254883f, 30.573999404907227f,
    -6.902520179748535f, 16.223100662231445f, 31.51460075378418f,
    -7.015810012817383f, 16.48940086364746f, 31.828100204467773f,
    -7.246280193328857f, 17.031099319458008f, 31.51460075378418f,
    -7.500199794769287f, 17.62779998779297f, 30.573999404907227f,
    0.0f, 17.83489990234375f, 30.573999404907227f,
    0.0f, 17.586000442504883f, 31.51460075378418f,
    0.0f, 17.87470054626465f, 31.828100204467773f,
    0.0f, 18.46190071105957f, 31.51460075378418f,
    0.0f, 19.108800888061523f, 30.573999404907227f,
    0.0f, 17.83489990234375f, 30.573999404907227f,
    7.000179767608643f, 16.452699661254883f, 30.573999404907227f,
    6.902520179748535f, 16.223100662231445f, 31.51460075378418f,
    0.0f, 17.586000442504883f, 31.51460075378418f,
    7.015810012817383f, 16.48940086364746f, 31.828100204467773f,
    0.0f, 17.87470054626465f, 31.828100204467773f,
    7.246280193328857f, 17.031099319458008f, 31.51460075378418f,
    0.0f, 18.46190071105957f, 31.51460075378418f,
    7.500199794769287f, 17.62779998779297f, 30.573999404907227f,
    0.0f, 19.108800888061523f, 30.573999404907227f,
    12.662699699401855f, 12.662699699401855f, 30.573999404907227f,
    12.486100196838379f, 12.486100196838379f, 31.51460075378418f,
    12.690999984741211f, 12.690999984741211f, 31.828100204467773f,
    13.10789966583252f, 13.10789966583252f, 31.51460075378418f,
    13.56719970703125f, 13.56719970703125f, 30.573999404907227f,
    16.452699661254883f, 7.000179767608643f, 30.573999404907227f,
    16.223100662231445f, 6.902520179748535f, 31.51460075378418f,
    16.48940086364746f, 7.015810012817383f, 31.828100204467773f,
    17.031099319458008f, 7.246280193328857f, 31.51460075378418f,
    17.62779998779297f, 7.500199794769287f, 30.573999404907227f,
    17.83489990234375f, 0.0f, 30.573999404907227f,
    17.586000442504883f, 0.0f, 31.51460075378418f,
    17.87470054626465f, 0.0f, 31.828100204467773f,
    18.46190071105957f, 0.0f, 31.51460075378418f,
    19.108800888061523f, 0.0f, 30.573999404907227f,
    19.108800888061523f, 0.0f, 30.573999404907227f,
    17.62779998779297f, -7.500199794769287f, 30.573999404907227f,
    19.785400390625f, -8.418190002441406f, 25.572900772094727f,
    21.447599411010742f, 0.0f, 25.572900772094727f,
    21.667600631713867f, -9.218990325927734f, 20.661399841308594f,
    23.487899780273438f, 0.0f, 20.661399841308594f,
    22.99880027770996f, -9.785409927368164f, 15.928999900817871f,
    24.930999755859375f, 0.0f, 15.928999900817871f,
    23.503799438476562f, -10.000300407409668f, 11.465299606323242f,
    25.4783992767334f, 0.0f, 11.465299606323242f,
    13.56719970703125f, -13.56719970703125f, 30.573999404907227f,
    15.227800369262695f, -15.227800369262695f, 25.572900772094727f,
    16.67639923095703f, -16.67639923095703f, 20.661399841308594f,
    17.701000213623047f, -17.701000213623047f, 15.928999900817871f,
    18.089599609375f, -18.089599609375f, 11.465299606323242f,
    7.500199794769287f, -17.62779998779297f, 30.573999404907227f,
    8.418190002441406f, -19.785400390625f, 25.572900772094727f,
    9.218990325927734f, -21.667600631713867f, 20.661399841308594f,
    9.785409927368164f, -22.99880027770996f, 15.928999900817871f,
    10.000300407409668f, -23.503799438476562f, 11.465299606323242f,
    0.0f, -19.108800888061523f, 30.573999404907227f,
    0.0f, -21.447599411010742f, 25.572900772094727f,
    0.0f, -23.487899780273438f, 20.661399841308594f,
    0.0f, -24.930999755859375f, 15.928999900817871f,
    0.0f, -25.4783992767334f, 11.465299606323242f,
    0.0f, -19.108800888061523f, 30.573999404907227f,
    -7.500199794769287f, -17.62779998779297f, 30.573999404907227f,
    -8.418190002441406f, -19.785400390625f, 25.572900772094727f,
    0.0f, -21.447599411010742f, 25.572900772094727f,
    -9.218990325927734f, -21.667600631713867f, 20.661399841308594f,
    0.0f, -23.487899780273438f, 20.661399841308594f,
    -9.785409927368164f, -22.99880027770996f, 15.928999900817871f,
    0.0f, -24.930999755859375f, 15.928999900817871f,
    -10.000300407409668f, -23.503799438476562f, 11.465299606323242f,
    0.0f, -25.4783992767334f, 11.465299606323242f,
    -13.56719970703125f, -13.56719970703125f, 30.573999404907227f,
    -15.227800369262695f, -15.227800369262695f, 25.572900772094727f,
    -16.67639923095703f, -16.67639923095703f, 20.661399841308594f,
    -17.701000213623047f, -17.701000213623047f, 15.928999900817871f,
    -18.089599609375f, -18.089599609375f, 11.465299606323242f,
    -17.62779998779297f, -7.500199794769287f, 30.573999404907227f,
    -19.785400390625f, -8.418190002441406f, 25.572900772094727f,
    -21.667600631713867f, -9.218990325927734f, 20.661399841308594f,
    -22.99880027770996f, -9.785409927368164f, 15.928999900817871f,
    -23.503799438476562f, -10.000300407409668f, 11.465299606323242f,
    -19.108800888061523f, 0.0f, 30.573999404907227f,
    -21.447599411010742f, 0.0f, 25.572900772094727f,
    -23.487899780273438f, 0.0f, 20.661399841308594f,
    -24.930999755859375f, 0.0f, 15.928999900817871f,
    -25.4783992767334f, 0.0f, 11.465299606323242f,
    -19.108800888061523f, 0.0f, 30.573999404907227f,
    -17.62779998779297f, 7.500199794769287f, 30.573999404907227f,
    -19.785400390625f, 8.418190002441406f, 25.572900772094727f,
    -21.447599411010742f, 0.0f, 25.572900772094727f,
    -21.667600631713867f, 9.218990325927734f, 20.661399841308594f,
    -23.487899780273438f, 0.0f, 20.661399841308594f,
    -22.99880027770996f, 9.785409927368164f, 15.928999900817871f,
    -24.930999755859375f, 0.0f, 15.928999900817871f,
    -23.503799438476562f, 10.000300407409668f, 11.465299606323242f,
    -25.4783992767334f, 0.0f, 11.465299606323242f,
    -13.56719970703125f, 13.56719970703125f, 30.573999404907227f,
    -15.227800369262695f, 15.227800369262695f, 25.572900772094727f,
    -16.67639923095703f, 16.67639923095703f, 20.661399841308594f,
    -17.701000213623047f, 17.701000213623047f, 15.928999900817871f,
    -18.089599609375f, 18.089599609375f, 11.465299606323242f,
    -7.500199794769287f, 17.62779998779297f, 30.573999404907227f,
    -8.418190002441406f, 19.785400390625f, 25.572900772094727f,
    -9.218990325927734f, 21.667600631713867f, 20.661399841308594f,
    -9.785409927368164f, 22.99880027770996f, 15.928999900817871f,
    -10.000300407409668f, 23.503799438476562f, 11.465299606323242f,
    0.0f, 19.108800888061523f, 30.573999404907227f,
    0.0f, 21.447599411010742f, 25.572900772094727f,
    0.0f, 23.487899780273438f, 20.661399841308594f,
    0.0f, 24.930999755859375f, 15.928999900817871f,
    0.0f, 25.4783992767334f, 11.465299606323242f,
    0.0f, 19.108800888061523f, 30.573999404907227f,
    7.500199794769287f, 17.62779998779297f, 30.573999404907227f,
    8.418190002441406f, 19.785400390625f, 25.572900772094727f,
    0.0f, 21.447599411010742f, 25.572900772094727f,
    9.218990325927734f, 21.667600631713867f, 20.661399841308594f,
    0.0f, 23.487899780273438f, 20.661399841308594f,
    9.785409927368164f, 22.99880027770996f, 15.928999900817871f,
    0.0f, 24.930999755859375f, 15.928999900817871f,
    10.000300407409668f, 23.503799438476562f, 11.465299606323242f,
    0.0f, 25.4783992767334f, 11.465299606323242f,
    13.56719970703125f, 13.56719970703125f, 30.573999404907227f,
    15.227800369262695f, 15.227800369262695f, 25.572900772094727f,
    16.67639923095703f, 16.67639923095703f, 20.661399841308594f,
    17.701000213623047f, 17.701000213623047f, 15.928999900817871f,
    18.089599609375f, 18.089599609375f, 11.465299606323242f,
    17.62779998779297f, 7.500199794769287f, 30.573999404907227f,
    19.785400390625f, 8.418190002441406f, 25.572900772094727f,
    21.667600631713867f, 9.218990325927734f, 20.661399841308594f,
    22.99880027770996f, 9.785409927368164f, 15.928999900817871f,
    23.503799438476562f, 10.000300407409668f, 11.465299606323242f,
    19.108800888061523f, 0.0f, 30.573999404907227f,
    21.447599411010742f, 0.0f, 25.572900772094727f,
    23.487899780273438f, 0.0f, 20.661399841308594f,
    24.930999755859375f, 0.0f, 15.928999900817871f,
    25.4783992767334f, 0.0f, 11.465299606323242f,
    25.4783992767334f, 0.0f, 11.465299606323242f,
    23.503799438476562f, -10.000300407409668f, 11.465299606323242f,
    22.5856990814209f, -9.609620094299316f, 7.688300132751465f,
    24.48310089111328f, 0.0f, 7.688300132751465f,
    20.565799713134766f, -8.750229835510254f, 4.89661979675293f,
    22.29360008239746f, 0.0f, 4.89661979675293f,
    18.54599952697754f, -7.890830039978027f, 3.0006699562072754f,
    20.104000091552734f, 0.0f, 3.0006699562072754f,
    17.62779998779297f, -7.500199794769287f, 1.9108799695968628f,
    19.108800888061523f, 0.0f, 1.9108799695968628f,
    18.089599609375f, -18.089599609375f, 11.465299606323242f,
    17.382999420166016f, -17.382999420166016f, 7.688300132751465f,
    15.828399658203125f, -15.828399658203125f, 4.89661979675293f,
    14.273900032043457f, -14.273900032043457f, 3.0006699562072754f,
    13.56719970703125f, -13.56719970703125f, 1.9108799695968628f,
    10.000300407409668f, -23.503799438476562f, 11.465299606323242f,
    9.609620094299316f, -22.5856990814209f, 7.688300132751465f,
    8.750229835510254f, -20.565799713134766f, 4.89661979675293f,
    7.890830039978027f, -18.54599952697754f, 3.0006699562072754f,
    7.500199794769287f, -17.62779998779297f, 1.9108799695968628f,
    0.0f, -25.4783992767334f, 11.465299606323242f,
    0.0f, -24.48310089111328f, 7.688300132751465f,
    0.0f, -22.29360008239746f, 4.89661979675293f,
    0.0f, -20.104000091552734f, 3.0006699562072754f,
    0.0f, -19.108800888061523f, 1.9108799695968628f,
    0.0f, -25.4783992767334f, 11.465299606323242f,
    -10.000300407409668f, -23.503799438476562f, 11.465299606323242f,
    -9.609620094299316f, -22.5856990814209f, 7.688300132751465f,
    0.0f, -24.48310089111328f, 7.688300132751465f,
    -8.750229835510254f, -20.565799713134766f, 4.89661979675293f,
    0.0f, -22.29360008239746f, 4.89661979675293f,
    -7.890830039978027f, -18.54599952697754f, 3.0006699562072754f,
    0.0f, -20.104000091552734f, 3.0006699562072754f,
    -7.500199794769287f, -17.62779998779297f, 1.9108799695968628f,
    0.0f, -19.108800888061523f, 1.9108799695968628f,
    -18.089599609375f, -18.089599609375f, 11.465299606323242f,
    -17.382999420166016f, -17.382999420166016f, 7.688300132751465f,
    -15.828399658203125f, -15.828399658203125f, 4.89661979675293f,
    -14.273900032043457f, -14.273900032043457f, 3.0006699562072754f,
    -13.56719970703125f, -13.56719970703125f, 1.9108799695968628f,
    -23.503799438476562f, -10.000300407409668f, 11.465299606323242f,
    -22.5856990814209f, -9.609620094299316f, 7.688300132751465f,
    -20.565799713134766f, -8.750229835510254f, 4.89661979675293f,
    -18.54599952697754f, -7.890830039978027f, 3.0006699562072754f,
    -17.62779998779297f, -7.500199794769287f, 1.9108799695968628f,
    -25.4783992767334f, 0.0f, 11.465299606323242f,
    -24.48310089111328f, 0.0f, 7.688300132751465f,
    -22.29360008239746f, 0.0f, 4.89661979675293f,
    -20.104000091552734f, 0.0f, 3.0006699562072754f,
    -19.108800888061523f, 0.0f, 1.9108799695968628f,
    -25.4783992767334f, 0.0f, 11.465299606323242f,
    -23.503799438476562f, 10.000300407409668f, 11.465299606323242f,
    -22.5856990814209f, 9.609620094299316f, 7.688300132751465f,
    -24.48310089111328f, 0.0f, 7.688300132751465f,
    -20.565799713134766f, 8.750229835510254f, 4.89661979675293f,
    -22.29360008239746f, 0.0f, 4.89661979675293f,
    -18.54599952697754f, 7.890830039978027f, 3.0006699562072754f,
    -20.104000091552734f, 0.0f, 3.0006699562072754f,
    -17.62779998779297f, 7.500199794769287f, 1.9108799695968628f,
    -19.108800888061523f, 0.0f, 1.9108799695968628f,
    -18.089599609375f, 18.089599609375f, 11.465299606323242f,
    -17.382999420166016f, 17.382999420166016f, 7.688300132751465f,
    -15.828399658203125f, 15.828399658203125f, 4.89661979675293f,
    -14.273900032043457f, 14.273900032043457f, 3.0006699562072754f,
    -13.56719970703125f, 13.56719970703125f, 1.9108799695968628f,
    -10.000300407409668f, 23.503799438476562f, 11.465299606323242f,
    -9.609620094299316f, 22.5856990814209f, 7.688300132751465f,
    -8.750229835510254f, 20.565799713134766f, 4.89661979675293f,
    -7.890830039978027f, 18.54599952697754f, 3.0006699562072754f,
    -7.500199794769287f, 17.62779998779297f, 1.9108799695968628f,
    0.0f, 25.4783992767334f, 11.465299606323242f,
    0.0f, 24.48310089111328f, 7.688300132751465f,
    0.0f, 22.29360008239746f, 4.89661979675293f,
    0.0f, 20.104000091552734f, 3.0006699562072754f,
    0.0f, 19.108800888061523f, 1.9108799695968628f,
    0.0f, 25.4783992767334f, 11.465299606323242f,
    10.000300407409668f, 23.503799438476562f, 11.465299606323242f,
    9.609620094299316f, 22.5856990814209f, 7.688300132751465f,
    0.0f, 24.48310089111328f, 7.688300132751465f,
    8.750229835510254f, 20.565799713134766f, 4.89661979675293f,
    0.0f, 22.29360008239746f, 4.89661979675293f,
    7.890830039978027f, 18.54599952697754f, 3.0006699562072754f,
    0.0f, 20.104000091552734f, 3.0006699562072754f,
    7.500199794769287f, 17.62779998779297f, 1.9108799695968628f,
    0.0f, 19.108800888061523f, 1.9108799695968628f,
    18.089599609375f, 18.089599609375f, 11.465299606323242f,
    17.382999420166016f, 17.382999420166016f, 7.688300132751465f,
    15.828399658203125f, 15.828399658203125f, 4.89661979675293f,
    14.273900032043457f, 14.273900032043457f, 3.0006699562072754f,
    13.56719970703125f, 13.56719970703125f, 1.9108799695968628f,
    23.503799438476562f, 10.000300407409668f, 11.465299606323242f,
    22.5856990814209f, 9.609620094299316f, 7.688300132751465f,
    20.565799713134766f, 8.750229835510254f, 4.89661979675293f,
    18.54599952697754f, 7.890830039978027f, 3.0006699562072754f,
    17.62779998779297f, 7.500199794769287f, 1.9108799695968628f,
    25.4783992767334f, 0.0f, 11.465299606323242f,
    24.48310089111328f, 0.0f, 7.688300132751465f,
    22.29360008239746f, 0.0f, 4.89661979675293f,
    20.104000091552734f, 0.0f, 3.0006699562072754f,
    19.108800888061523f, 0.0f, 1.9108799695968628f,
    19.108800888061523f, 0.0f, 1.9108799695968628f,
    17.62779998779297f, -7.500199794769287f, 1.9108799695968628f,
    17.228500366210938f, -7.330269813537598f, 1.2092299461364746f,
    18.675800323486328f, 0.0f, 1.2092299461364746f,
    15.093799591064453f, -6.422039985656738f, 0.5971490144729614f,
    16.361900329589844f, 0.0f, 0.5971490144729614f,
    9.819259643554688f, -4.177840232849121f, 0.16421599686145782f,
    10.644200325012207f, 0.0f, 0.16421599686145782f,
    0.0f, 0.0f, 0.0f,
    0.0f, 0.0f, 0.0f,
    13.56719970703125f, -13.56719970703125f, 1.9108799695968628f,
    13.25979995727539f, -13.25979995727539f, 1.2092299461364746f,
    11.616900444030762f, -11.616900444030762f, 0.5971490144729614f,
    7.557370185852051f, -7.557370185852051f, 0.16421599686145782f,
    0.0f, 0.0f, 0.0f,
    7.500199794769287f, -17.62779998779297f, 1.9108799695968628f,
    7.330269813537598f, -17.228500366210938f, 1.2092299461364746f,
    6.422039985656738f, -15.093799591064453f, 0.5971490144729614f,
    4.177840232849121f, -9.819259643554688f, 0.16421599686145782f,
    0.0f, 0.0f, 0.0f,
    0.0f, -19.108800888061523f, 1.9108799695968628f,
    0.0f, -18.675800323486328f, 1.2092299461364746f,
    0.0f, -16.361900329589844f, 0.5971490144729614f,
    0.0f, -10.644200325012207f, 0.16421599686145782f,
    0.0f, 0.0f, 0.0f,
    0.0f, -19.108800888061523f, 1.9108799695968628f,
    -7.500199794769287f, -17.62779998779297f, 1.9108799695968628f,
    -7.330269813537598f, -17.228500366210938f, 1.2092299461364746f,
    0.0f, -18.675800323486328f, 1.2092299461364746f,
    -6.422039985656738f, -15.093799591064453f, 0.5971490144729614f,
    0.0f, -16.361900329589844f, 0.5971490144729614f,
    -4.177840232849121f, -9.819259643554688f, 0.16421599686145782f,
    0.0f, -10.644200325012207f, 0.16421599686145782f,
    0.0f, 0.0f, 0.0f,
    0.0f, 0.0f, 0.0f,
    -13.56719970703125f, -13.56719970703125f, 1.9108799695968628f,
    -13.25979995727539f, -13.25979995727539f, 1.2092299461364746f,
    -11.616900444030762f, -11.616900444030762f, 0.5971490144729614f,
    -7.557370185852051f, -7.557370185852051f, 0.16421599686145782f,
    0.0f, 0.0f, 0.0f,
    -17.62779998779297f, -7.500199794769287f, 1.9108799695968628f,
    -17.228500366210938f, -7.330269813537598f, 1.2092299461364746f,
    -15.093799591064453f, -6.422039985656738f, 0.5971490144729614f,
    -9.819259643554688f, -4.177840232849121f, 0.16421599686145782f,
    0.0f, 0.0f, 0.0f,
    -19.108800888061523f, 0.0f, 1.9108799695968628f,
    -18.675800323486328f, 0.0f, 1.2092299461364746f,
    -16.361900329589844f, 0.0f, 0.5971490144729614f,
    -10.644200325012207f, 0.0f, 0.16421599686145782f,
    0.0f, 0.0f, 0.0f,
    -19.108800888061523f, 0.0f, 1.9108799695968628f,
    -17.62779998779297f, 7.500199794769287f, 1.9108799695968628f,
    -17.228500366210938f, 7.330269813537598f, 1.2092299461364746f,
    -18.675800323486328f, 0.0f, 1.2092299461364746f,
    -15.093799591064453f, 6.422039985656738f, 0.5971490144729614f,
    -16.361900329589844f, 0.0f, 0.5971490144729614f,
    -9.819259643554688f, 4.177840232849121f, 0.16421599686145782f,
    -10.644200325012207f, 0.0f, 0.16421599686145782f,
    0.0f, 0.0f, 0.0f,
    0.0f, 0.0f, 0.0f,
    -13.56719970703125f, 13.56719970703125f, 1.9108799695968628f,
    -13.25979995727539f, 13.25979995727539f, 1.2092299461364746f,
    -11.616900444030762f, 11.616900444030762f, 0.5971490144729614f,
    -7.557370185852051f, 7.557370185852051f, 0.16421599686145782f,
    0.0f, 0.0f, 0.0f,
    -7.500199794769287f, 17.62779998779297f, 1.9108799695968628f,
    -7.330269813537598f, 17.228500366210938f, 1.2092299461364746f,
    -6.422039985656738f, 15.093799591064453f, 0.5971490144729614f,
    -4.177840232849121f, 9.819259643554688f, 0.16421599686145782f,
    0.0f, 0.0f, 0.0f,
    0.0f, 19.108800888061523f, 1.9108799695968628f,
    0.0f, 18.675800323486328f, 1.2092299461364746f,
    0.0f, 16.361900329589844f, 0.5971490144729614f,
    0.0f, 10.644200325012207f, 0.16421599686145782f,
    0.0f, 0.0f, 0.0f,
    0.0f, 19.108800888061523f, 1.9108799695968628f,
    7.500199794769287f, 17.62779998779297f, 1.9108799695968628f,
    7.330269813537598f, 17.228500366210938f, 1.2092299461364746f,
    0.0f, 18.675800323486328f, 1.2092299461364746f,
    6.422039985656738f, 15.093799591064453f, 0.5971490144729614f,
    0.0f, 16.361900329589844f, 0.5971490144729614f,
    4.177840232849121f, 9.819259643554688f, 0.16421599686145782f,
    0.0f, 10.644200325012207f, 0.16421599686145782f,
    0.0f, 0.0f, 0.0f,
    0.0f, 0.0f, 0.0f,
    13.56719970703125f, 13.56719970703125f, 1.9108799695968628f,
    13.25979995727539f, 13.25979995727539f, 1.2092299461364746f,
    11.616900444030762f, 11.616900444030762f, 0.5971490144729614f,
    7.557370185852051f, 7.557370185852051f, 0.16421599686145782f,
    0.0f, 0.0f, 0.0f,
    17.62779998779297f, 7.500199794769287f, 1.9108799695968628f,
    17.228500366210938f, 7.330269813537598f, 1.2092299461364746f,
    15.093799591064453f, 6.422039985656738f, 0.5971490144729614f,
    9.819259643554688f, 4.177840232849121f, 0.16421599686145782f,
    0.0f, 0.0f, 0.0f,
    19.108800888061523f, 0.0f, 1.9108799695968628f,
    18.675800323486328f, 0.0f, 1.2092299461364746f,
    16.361900329589844f, 0.0f, 0.5971490144729614f,
    10.644200325012207f, 0.0f, 0.16421599686145782f,
    0.0f, 0.0f, 0.0f,
    -20.382699966430664f, 0.0f, 25.796899795532227f,
    -20.1835994720459f, -2.149739980697632f, 26.244699478149414f,
    -26.511600494384766f, -2.149739980697632f, 26.192899703979492f,
    -26.334299087524414f, 0.0f, 25.752099990844727f,
    -31.156299591064453f, -2.149739980697632f, 25.830400466918945f,
    -30.733299255371094f, 0.0f, 25.438600540161133f,
    -34.016998291015625f, -2.149739980697632f, 24.846500396728516f,
    -33.46030044555664f, 0.0f, 24.587600708007812f,
    -34.99290084838867f, -2.149739980697632f, 22.930500030517578f,
    -34.39580154418945f, 0.0f, 22.930500030517578f,
    -19.74570083618164f, -2.8663198947906494f, 27.229999542236328f,
    -26.901599884033203f, -2.8663198947906494f, 27.162799835205078f,
    -32.08679962158203f, -2.8663198947906494f, 26.69260025024414f,
    -35.241798400878906f, -2.8663198947906494f, 25.416200637817383f,
    -36.30670166015625f, -2.8663198947906494f, 22.930500030517578f,
    -19.30780029296875f, -2.149739980697632f, 28.215299606323242f,
    -27.29159927368164f, -2.149739980697632f, 28.132699966430664f,
    -33.017398834228516f, -2.149739980697632f, 27.55470085144043f,
    -36.46649932861328f, -2.149739980697632f, 25.98579978942871f,
    -37.620399475097656f, -2.149739980697632f, 22.930500030517578f,
    -19.108800888061523f, 0.0f, 28.66320037841797f,
    -27.468900680541992f, 0.0f, 28.57360076904297f,
    -33.440399169921875f, 0.0f, 27.94659996032715f,
    -37.02330017089844f, 0.0f, 26.244699478149414f,
    -38.21760177612305f, 0.0f, 22.930500030517578f,
    -19.108800888061523f, 0.0f, 28.66320037841797f,
    -19.30780029296875f, 2.149739980697632f, 28.215299606323242f,
    -27.29159927368164f, 2.149739980697632f, 28.132699966430664f,
    -27.468900680541992f, 0.0f, 28.57360076904297f,
    -33.017398834228516f, 2.149739980697632f, 27.55470085144043f,
    -33.440399169921875f, 0.0f, 27.94659996032715f,
    -36.46649932861328f, 2.149739980697632f, 25.98579978942871f,
    -37.02330017089844f, 0.0f, 26.244699478149414f,
    -37.620399475097656f, 2.149739980697632f, 22.930500030517578f,
    -38.21760177612305f, 0.0f, 22.930500030517578f,
    -19.74570083618164f, 2.8663198947906494f, 27.229999542236328f,
    -26.901599884033203f, 2.8663198947906494f, 27.162799835205078f,
    -32.08679962158203f, 2.8663198947906494f, 26.69260025024414f,
    -35.241798400878906f, 2.8663198947906494f, 25.416200637817383f,
    -36.30670166015625f, 2.8663198947906494f, 22.930500030517578f,
    -20.1835994720459f, 2.149739980697632f, 26.244699478149414f,
    -26.511600494384766f, 2.149739980697632f, 26.192899703979492f,
    -31.156299591064453f, 2.149739980697632f, 25.830400466918945f,
    -34.016998291015625f, 2.149739980697632f, 24.846500396728516f,
    -34.99290084838867f, 2.149739980697632f, 22.930500030517578f,
    -20.382699966430664f, 0.0f, 25.796899795532227f,
    -26.334299087524414f, 0.0f, 25.752099990844727f,
    -30.733299255371094f, 0.0f, 25.438600540161133f,
    -33.46030044555664f, 0.0f, 24.587600708007812f,
    -34.39580154418945f, 0.0f, 22.930500030517578f,
    -34.39580154418945f, 0.0f, 22.930500030517578f,
    -34.99290084838867f, -2.149739980697632f, 22.930500030517578f,
    -34.44089889526367f, -2.149739980697632f, 20.082199096679688f,
    -33.89820098876953f, 0.0f, 20.33289909362793f,
    -32.711299896240234f, -2.149739980697632f, 16.81529998779297f,
    -32.32569885253906f, 0.0f, 17.197900772094727f,
    -29.69420051574707f, -2.149739980697632f, 13.590499877929688f,
    -29.558900833129883f, 0.0f, 14.062899589538574f,
    -25.279300689697266f, -2.149739980697632f, 10.8681001663208f,
    -25.4783992767334f, 0.0f, 11.465299606323242f,
    -36.30670166015625f, -2.8663198947906494f, 22.930500030517578f,
    -35.6348991394043f, -2.8663198947906494f, 19.530500411987305f,
    -33.55979919433594f, -2.8663198947906494f, 15.973699569702148f,
    -29.99180030822754f, -2.8663198947906494f, 12.551300048828125f,
    -24.841400146484375f, -2.8663198947906494f, 9.554389953613281f,
    -37.620399475097656f, -2.149739980697632f, 22.930500030517578f,
    -36.82889938354492f, -2.149739980697632f, 18.97879981994629f,
    -34.408199310302734f, -2.149739980697632f, 15.132100105285645f,
    -30.289499282836914f, -2.149739980697632f, 11.512200355529785f,
    -24.403499603271484f, -2.149739980697632f, 8.240659713745117f,
    -38.21760177612305f, 0.0f, 22.930500030517578f,
    -37.37160110473633f, 0.0f, 18.728099822998047f,
    -34.79389953613281f, 0.0f, 14.749600410461426f,
    -30.424800872802734f, 0.0f, 11.039799690246582f,
    -24.204500198364258f, 0.0f, 7.643509864807129f,
    -38.21760177612305f, 0.0f, 22.930500030517578f,
    -37.620399475097656f, 2.149739980697632f, 22.930500030517578f,
    -36.82889938354492f, 2.149739980697632f, 18.97879981994629f,
    -37.37160110473633f, 0.0f, 18.728099822998047f,
    -34.408199310302734f, 2.149739980697632f, 15.132100105285645f,
    -34.79389953613281f, 0.0f, 14.749600410461426f,
    -30.289499282836914f, 2.149739980697632f, 11.512200355529785f,
    -30.424800872802734f, 0.0f, 11.039799690246582f,
    -24.403499603271484f, 2.149739980697632f, 8.240659713745117f,
    -24.204500198364258f, 0.0f, 7.643509864807129f,
    -36.30670166015625f, 2.8663198947906494f, 22.930500030517578f,
    -35.6348991394043f, 2.8663198947906494f, 19.530500411987305f,
    -33.55979919433594f, 2.8663198947906494f, 15.973699569702148f,
    -29.99180030822754f, 2.8663198947906494f, 12.551300048828125f,
    -24.841400146484375f, 2.8663198947906494f, 9.554389953613281f,
    -34.99290084838867f, 2.149739980697632f, 22.930500030517578f,
    -34.44089889526367f, 2.149739980697632f, 20.082199096679688f,
    -32.711299896240234f, 2.149739980697632f, 16.81529998779297f,
    -29.69420051574707f, 2.149739980697632f, 13.590499877929688f,
    -25.279300689697266f, 2.149739980697632f, 10.8681001663208f,
    -34.39580154418945f, 0.0f, 22.930500030517578f,
    -33.89820098876953f, 0.0f, 20.33289909362793f,
    -32.32569885253906f, 0.0f, 17.197900772094727f,
    -29.558900833129883f, 0.0f, 14.062899589538574f,
    -25.4783992767334f, 0.0f, 11.465299606323242f,
    21.656600952148438f, 0.0f, 18.15329933166504f,
    21.656600952148438f, -4.729420185089111f, 16.511199951171875f,
    28.233999252319336f, -4.270359992980957f, 18.339000701904297f,
    27.76740074157715f, 0.0f, 19.55660057067871f,
    31.011899948120117f, -3.2604401111602783f, 22.221399307250977f,
    30.4148006439209f, 0.0f, 22.930500030517578f,
    32.59560012817383f, -2.2505099773406982f, 26.764400482177734f,
    31.867900848388672f, 0.0f, 27.020999908447266f,
    35.5900993347168f, -1.791450023651123f, 30.573999404907227f,
    34.39580154418945f, 0.0f, 30.573999404907227f,
    21.656600952148438f, -6.3059000968933105f, 12.89840030670166f,
    29.260299682617188f, -5.693819999694824f, 15.660200119018555f,
    32.32569885253906f, -4.347249984741211f, 20.661399841308594f,
    34.19670104980469f, -3.0006699562072754f, 26.199899673461914f,
    38.21760177612305f, -2.3886001110076904f, 30.573999404907227f,
    21.656600952148438f, -4.729420185089111f, 9.285670280456543f,
    30.286699295043945f, -4.270359992980957f, 12.981499671936035f,
    33.639400482177734f, -3.2604401111602783f, 19.101299285888672f,
    35.79790115356445f, -2.2505099773406982f, 25.635400772094727f,
    40.845001220703125f, -1.791450023651123f, 30.573999404907227f,
    21.656600952148438f, 0.0f, 7.643509864807129f,
    30.75320053100586f, 0.0f, 11.763799667358398f,
    34.23659896850586f, 0.0f, 18.392200469970703f,
    36.52560043334961f, 0.0f, 25.378799438476562f,
    42.03929901123047f, 0.0f, 30.573999404907227f,
    21.656600952148438f, 0.0f, 7.643509864807129f,
    21.656600952148438f, 4.729420185089111f, 9.285670280456543f,
    30.286699295043945f, 4.270359992980957f, 12.981499671936035f,
    30.75320053100586f, 0.0f, 11.763799667358398f,
    33.639400482177734f, 3.2604401111602783f, 19.101299285888672f,
    34.23659896850586f, 0.0f, 18.392200469970703f,
    35.79790115356445f, 2.2505099773406982f, 25.635400772094727f,
    36.52560043334961f, 0.0f, 25.378799438476562f,
    40.845001220703125f, 1.791450023651123f, 30.573999404907227f,
    42.03929901123047f, 0.0f, 30.573999404907227f,
    21.656600952148438f, 6.3059000968933105f, 12.89840030670166f,
    29.260299682617188f, 5.693819999694824f, 15.660200119018555f,
    32.32569885253906f, 4.347249984741211f, 20.661399841308594f,
    34.19670104980469f, 3.0006699562072754f, 26.199899673461914f,
    38.21760177612305f, 2.3886001110076904f, 30.573999404907227f,
    21.656600952148438f, 4.729420185089111f, 16.511199951171875f,
    28.233999252319336f, 4.270359992980957f, 18.339000701904297f,
    31.011899948120117f, 3.2604401111602783f, 22.221399307250977f,
    32.59560012817383f, 2.2505099773406982f, 26.764400482177734f,
    35.5900993347168f, 1.791450023651123f, 30.573999404907227f,
    21.656600952148438f, 0.0f, 18.15329933166504f,
    27.76740074157715f, 0.0f, 19.55660057067871f,
    30.4148006439209f, 0.0f, 22.930500030517578f,
    31.867900848388672f, 0.0f, 27.020999908447266f,
    34.39580154418945f, 0.0f, 30.573999404907227f,
    34.39580154418945f, 0.0f, 30.573999404907227f,
    35.5900993347168f, -1.791450023651123f, 30.573999404907227f,
    36.59049987792969f, -1.679479956626892f, 31.137699127197266f,
    35.3114013671875f, 0.0f, 31.111499786376953f,
    37.18870162963867f, -1.4331599473953247f, 31.332599639892578f,
    35.98820114135742f, 0.0f, 31.290599822998047f,
    37.206600189208984f, -1.1868300437927246f, 31.1481990814209f,
    36.187198638916016f, 0.0f, 31.111499786376953f,
    36.46590042114258f, -1.074869990348816f, 30.573999404907227f,
    35.669700622558594f, 0.0f, 30.573999404907227f,
    38.21760177612305f, -2.3886001110076904f, 30.573999404907227f,
    39.40439987182617f, -2.2393100261688232f, 31.195499420166016f,
    39.829898834228516f, -1.9108799695968628f, 31.424999237060547f,
    39.44919967651367f, -1.582450032234192f, 31.229000091552734f,
    38.21760177612305f, -1.4331599473953247f, 30.573999404907227f,
    40.845001220703125f, -1.791450023651123f, 30.573999404907227f,
    42.218299865722656f, -1.679479956626892f, 31.25320053100586f,
    42.47100067138672f, -1.4331599473953247f, 31.51740074157715f,
    41.69169998168945f, -1.1868300437927246f, 31.309900283813477f,
    39.969200134277344f, -1.074869990348816f, 30.573999404907227f,
    42.03929901123047f, 0.0f, 30.573999404907227f,
    43.49729919433594f, 0.0f, 31.279399871826172f,
    43.67150115966797f, 0.0f, 31.55929946899414f,
    42.71110153198242f, 0.0f, 31.346599578857422f,
    40.76539993286133f, 0.0f, 30.573999404907227f,
    42.03929901123047f, 0.0f, 30.573999404907227f,
    40.845001220703125f, 1.791450023651123f, 30.573999404907227f,
    42.218299865722656f, 1.679479956626892f, 31.25320053100586f,
    43.49729919433594f, 0.0f, 31.279399871826172f,
    42.47100067138672f, 1.4331599473953247f, 31.51740074157715f,
    43.67150115966797f, 0.0f, 31.55929946899414f,
    41.69169998168945f, 1.1868300437927246f, 31.309900283813477f,
    42.71110153198242f, 0.0f, 31.346599578857422f,
    39.969200134277344f, 1.074869990348816f, 30.573999404907227f,
    40.76539993286133f, 0.0f, 30.573999404907227f,
    38.21760177612305f, 2.3886001110076904f, 30.573999404907227f,
    39.40439987182617f, 2.2393100261688232f, 31.195499420166016f,
    39.829898834228516f, 1.9108799695968628f, 31.424999237060547f,
    39.44919967651367f, 1.582450032234192f, 31.229000091552734f,
    38.21760177612305f, 1.4331599473953247f, 30.573999404907227f,
    35.5900993347168f, 1.791450023651123f, 30.573999404907227f,
    36.59049987792969f, 1.679479956626892f, 31.137699127197266f,
    37.18870162963867f, 1.4331599473953247f, 31.332599639892578f,
    37.206600189208984f, 1.1868300437927246f, 31.1481990814209f,
    36.46590042114258f, 1.074869990348816f, 30.573999404907227f,
    34.39580154418945f, 0.0f, 30.573999404907227f,
    35.3114013671875f, 0.0f, 31.111499786376953f,
    35.98820114135742f, 0.0f, 31.290599822998047f,
    36.187198638916016f, 0.0f, 31.111499786376953f,
    35.669700622558594f, 0.0f, 30.573999404907227f,
    0.0f, 0.0f, 40.12839889526367f,
    0.0f, 0.0f, 40.12839889526367f,
    4.004499912261963f, -1.7077000141143799f, 39.501399993896484f,
    4.339280128479004f, 0.0f, 39.501399993896484f,
    3.8207099437713623f, -1.6290700435638428f, 37.97869873046875f,
    4.140230178833008f, 0.0f, 37.97869873046875f,
    2.314160108566284f, -0.985912024974823f, 36.09769821166992f,
    2.5080299377441406f, 0.0f, 36.09769821166992f,
    2.3503799438476562f, -1.0000300407409668f, 34.39580154418945f,
    2.547840118408203f, 0.0f, 34.39580154418945f,
    0.0f, 0.0f, 40.12839889526367f,
    3.0849199295043945f, -3.0849199295043945f, 39.501399993896484f,
    2.943150043487549f, -2.943150043487549f, 37.97869873046875f,
    1.782039999961853f, -1.782039999961853f, 36.09769821166992f,
    1.8089599609375f, -1.8089599609375f, 34.39580154418945f,
    0.0f, 0.0f, 40.12839889526367f,
    1.7077000141143799f, -4.004499912261963f, 39.501399993896484f,
    1.6290700435638428f, -3.8207099437713623f, 37.97869873046875f,
    0.985912024974823f, -2.314160108566284f, 36.09769821166992f,
    1.0000300407409668f, -2.3503799438476562f, 34.39580154418945f,
    0.0f, 0.0f, 40.12839889526367f,
    0.0f, -4.339280128479004f, 39.501399993896484f,
    0.0f, -4.140230178833008f, 37.97869873046875f,
    0.0f, -2.5080299377441406f, 36.09769821166992f,
    0.0f, -2.547840118408203f, 34.39580154418945f,
    0.0f, 0.0f, 40.12839889526367f,
    0.0f, 0.0f, 40.12839889526367f,
    -1.7077000141143799f, -4.004499912261963f, 39.501399993896484f,
    0.0f, -4.339280128479004f, 39.501399993896484f,
    -1.6290700435638428f, -3.8207099437713623f, 37.97869873046875f,
    0.0f, -4.140230178833008f, 37.97869873046875f,
    -0.985912024974823f, -2.314160108566284f, 36.09769821166992f,
    0.0f, -2.5080299377441406f, 36.09769821166992f,
    -1.0000300407409668f, -2.3503799438476562f, 34.39580154418945f,
    0.0f, -2.547840118408203f, 34.39580154418945f,
    0.0f, 0.0f, 40.12839889526367f,
    -3.0849199295043945f, -3.0849199295043945f, 39.501399993896484f,
    -2.943150043487549f, -2.943150043487549f, 37.97869873046875f,
    -1.782039999961853f, -1.782039999961853f, 36.09769821166992f,
    -1.8089599609375f, -1.8089599609375f, 34.39580154418945f,
    0.0f, 0.0f, 40.12839889526367f,
    -4.004499912261963f, -1.7077000141143799f, 39.501399993896484f,
    -3.8207099437713623f, -1.6290700435638428f, 37.97869873046875f,
    -2.314160108566284f, -0.985912024974823f, 36.09769821166992f,
    -2.3503799438476562f, -1.0000300407409668f, 34.39580154418945f,
    0.0f, 0.0f, 40.12839889526367f,
    -4.339280128479004f, 0.0f, 39.501399993896484f,
    -4.140230178833008f, 0.0f, 37.97869873046875f,
    -2.5080299377441406f, 0.0f, 36.09769821166992f,
    -2.547840118408203f, 0.0f, 34.39580154418945f,
    0.0f, 0.0f, 40.12839889526367f,
    0.0f, 0.0f, 40.12839889526367f,
    -4.004499912261963f, 1.7077000141143799f, 39.501399993896484f,
    -4.339280128479004f, 0.0f, 39.501399993896484f,
    -3.8207099437713623f, 1.6290700435638428f, 37.97869873046875f,
    -4.140230178833008f, 0.0f, 37.97869873046875f,
    -2.314160108566284f, 0.985912024974823f, 36.09769821166992f,
    -2.5080299377441406f, 0.0f, 36.09769821166992f,
    -2.3503799438476562f, 1.0000300407409668f, 34.39580154418945f,
    -2.547840118408203f, 0.0f, 34.39580154418945f,
    0.0f, 0.0f, 40.12839889526367f,
    -3.0849199295043945f, 3.0849199295043945f, 39.501399993896484f,
    -2.943150043487549f, 2.943150043487549f, 37.97869873046875f,
    -1.782039999961853f, 1.782039999961853f, 36.09769821166992f,
    -1.8089599609375f, 1.8089599609375f, 34.39580154418945f,
    0.0f, 0.0f, 40.12839889526367f,
    -1.7077000141143799f, 4.004499912261963f, 39.501399993896484f,
    -1.6290700435638428f, 3.8207099437713623f, 37.97869873046875f,
    -0.985912024974823f, 2.314160108566284f, 36.09769821166992f,
    -1.0000300407409668f, 2.3503799438476562f, 34.39580154418945f,
    0.0f, 0.0f, 40.12839889526367f,
    0.0f, 4.339280128479004f, 39.501399993896484f,
    0.0f, 4.140230178833008f, 37.97869873046875f,
    0.0f, 2.5080299377441406f, 36.09769821166992f,
    0.0f, 2.547840118408203f, 34.39580154418945f,
    0.0f, 0.0f, 40.12839889526367f,
    0.0f, 0.0f, 40.12839889526367f,
    1.7077000141143799f, 4.004499912261963f, 39.501399993896484f,
    0.0f, 4.339280128479004f, 39.501399993896484f,
    1.6290700435638428f, 3.8207099437713623f, 37.97869873046875f,
    0.0f, 4.140230178833008f, 37.97869873046875f,
    0.985912024974823f, 2.314160108566284f, 36.09769821166992f,
    0.0f, 2.5080299377441406f, 36.09769821166992f,
    1.0000300407409668f, 2.3503799438476562f, 34.39580154418945f,
    0.0f, 2.547840118408203f, 34.39580154418945f,
    0.0f, 0.0f, 40.12839889526367f,
    3.0849199295043945f, 3.0849199295043945f, 39.501399993896484f,
    2.943150043487549f, 2.943150043487549f, 37.97869873046875f,
    1.782039999961853f, 1.782039999961853f, 36.09769821166992f,
    1.8089599609375f, 1.8089599609375f, 34.39580154418945f,
    0.0f, 0.0f, 40.12839889526367f,
    4.004499912261963f, 1.7077000141143799f, 39.501399993896484f,
    3.8207099437713623f, 1.6290700435638428f, 37.97869873046875f,
    2.314160108566284f, 0.985912024974823f, 36.09769821166992f,
    2.3503799438476562f, 1.0000300407409668f, 34.39580154418945f,
    0.0f, 0.0f, 40.12839889526367f,
    4.339280128479004f, 0.0f, 39.501399993896484f,
    4.140230178833008f, 0.0f, 37.97869873046875f,
    2.5080299377441406f, 0.0f, 36.09769821166992f,
    2.547840118408203f, 0.0f, 34.39580154418945f,
    2.547840118408203f, 0.0f, 34.39580154418945f,
    2.3503799438476562f, -1.0000300407409668f, 34.39580154418945f,
    5.361800193786621f, -2.2813100814819336f, 33.261199951171875f,
    5.812250137329102f, 0.0f, 33.261199951171875f,
    9.695320129394531f, -4.125110149383545f, 32.484901428222656f,
    10.50979995727539f, 0.0f, 32.484901428222656f,
    13.58810043334961f, -5.781400203704834f, 31.708599090576172f,
    14.729700088500977f, 0.0f, 31.708599090576172f,
    15.27750015258789f, -6.5001702308654785f, 30.573999404907227f,
    16.56089973449707f, 0.0f, 30.573999404907227f,
    1.8089599609375f, -1.8089599609375f, 34.39580154418945f,
    4.126699924468994f, -4.126699924468994f, 33.261199951171875f,
    7.461979866027832f, -7.461979866027832f, 32.484901428222656f,
    10.458100318908691f, -10.458100318908691f, 31.708599090576172f,
    11.758299827575684f, -11.758299827575684f, 30.573999404907227f,
    1.0000300407409668f, -2.3503799438476562f, 34.39580154418945f,
    2.2813100814819336f, -5.361800193786621f, 33.261199951171875f,
    4.125110149383545f, -9.695320129394531f, 32.484901428222656f,
    5.781400203704834f, -13.58810043334961f, 31.708599090576172f,
    6.5001702308654785f, -15.27750015258789f, 30.573999404907227f,
    0.0f, -2.547840118408203f, 34.39580154418945f,
    0.0f, -5.812250137329102f, 33.261199951171875f,
    0.0f, -10.50979995727539f, 32.484901428222656f,
    0.0f, -14.729700088500977f, 31.708599090576172f,
    0.0f, -16.56089973449707f, 30.573999404907227f,
    0.0f, -2.547840118408203f, 34.39580154418945f,
    -1.0000300407409668f, -2.3503799438476562f, 34.39580154418945f,
    -2.2813100814819336f, -5.361800193786621f, 33.261199951171875f,
    0.0f, -5.812250137329102f, 33.261199951171875f,
    -4.125110149383545f, -9.695320129394531f, 32.484901428222656f,
    0.0f, -10.50979995727539f, 32.484901428222656f,
    -5.781400203704834f, -13.58810043334961f, 31.708599090576172f,
    0.0f, -14.729700088500977f, 31.708599090576172f,
    -6.5001702308654785f, -15.27750015258789f, 30.573999404907227f,
    0.0f, -16.56089973449707f, 30.573999404907227f,
    -1.8089599609375f, -1.8089599609375f, 34.39580154418945f,
    -4.126699924468994f, -4.126699924468994f, 33.261199951171875f,
    -7.461979866027832f, -7.461979866027832f, 32.484901428222656f,
    -10.458100318908691f, -10.458100318908691f, 31.708599090576172f,
    -11.758299827575684f, -11.758299827575684f, 30.573999404907227f,
    -2.3503799438476562f, -1.0000300407409668f, 34.39580154418945f,
    -5.361800193786621f, -2.2813100814819336f, 33.261199951171875f,
    -9.695320129394531f, -4.125110149383545f, 32.484901428222656f,
    -13.58810043334961f, -5.781400203704834f, 31.708599090576172f,
    -15.27750015258789f, -6.5001702308654785f, 30.573999404907227f,
    -2.547840118408203f, 0.0f, 34.39580154418945f,
    -5.812250137329102f, 0.0f, 33.261199951171875f,
    -10.50979995727539f, 0.0f, 32.484901428222656f,
    -14.729700088500977f, 0.0f, 31.708599090576172f,
    -16.56089973449707f, 0.0f, 30.573999404907227f,
    -2.547840118408203f, 0.0f, 34.39580154418945f,
    -2.3503799438476562f, 1.0000300407409668f, 34.39580154418945f,
    -5.361800193786621f, 2.2813100814819336f, 33.261199951171875f,
    -5.812250137329102f, 0.0f, 33.261199951171875f,
    -9.695320129394531f, 4.125110149383545f, 32.484901428222656f,
    -10.50979995727539f, 0.0f, 32.484901428222656f,
    -13.58810043334961f, 5.781400203704834f, 31.708599090576172f,
    -14.729700088500977f, 0.0f, 31.708599090576172f,
    -15.27750015258789f, 6.5001702308654785f, 30.573999404907227f,
    -16.56089973449707f, 0.0f, 30.573999404907227f,
    -1.8089599609375f, 1.8089599609375f, 34.39580154418945f,
    -4.126699924468994f, 4.126699924468994f, 33.261199951171875f,
    -7.461979866027832f, 7.461979866027832f, 32.484901428222656f,
    -10.458100318908691f, 10.458100318908691f, 31.708599090576172f,
    -11.758299827575684f, 11.758299827575684f, 30.573999404907227f,
    -1.0000300407409668f, 2.3503799438476562f, 34.39580154418945f,
    -2.2813100814819336f, 5.361800193786621f, 33.261199951171875f,
    -4.125110149383545f, 9.695320129394531f, 32.484901428222656f,
    -5.781400203704834f, 13.58810043334961f, 31.708599090576172f,
    -6.5001702308654785f, 15.27750015258789f, 30.573999404907227f,
    0.0f, 2.547840118408203f, 34.39580154418945f,
    0.0f, 5.812250137329102f, 33.261199951171875f,
    0.0f, 10.50979995727539f, 32.484901428222656f,
    0.0f, 14.729700088500977f, 31.708599090576172f,
    0.0f, 16.56089973449707f, 30.573999404907227f,
    0.0f, 2.547840118408203f, 34.39580154418945f,
    1.0000300407409668f, 2.3503799438476562f, 34.39580154418945f,
    2.2813100814819336f, 5.361800193786621f, 33.261199951171875f,
    0.0f, 5.812250137329102f, 33.261199951171875f,
    4.125110149383545f, 9.695320129394531f, 32.484901428222656f,
    0.0f, 10.50979995727539f, 32.484901428222656f,
    5.781400203704834f, 13.58810043334961f, 31.708599090576172f,
    0.0f, 14.729700088500977f, 31.708599090576172f,
    6.5001702308654785f, 15.27750015258789f, 30.573999404907227f,
    0.0f, 16.56089973449707f, 30.573999404907227f,
    1.8089599609375f, 1.8089599609375f, 34.39580154418945f,
    4.126699924468994f, 4.126699924468994f, 33.261199951171875f,
    7.461979866027832f, 7.461979866027832f, 32.484901428222656f,
    10.458100318908691f, 10.458100318908691f, 31.708599090576172f,
    11.758299827575684f, 11.758299827575684f, 30.573999404907227f,
    2.3503799438476562f, 1.0000300407409668f, 34.39580154418945f,
    5.361800193786621f, 2.2813100814819336f, 33.261199951171875f,
    9.695320129394531f, 4.125110149383545f, 32.484901428222656f,
    13.58810043334961f, 5.781400203704834f, 31.708599090576172f,
    15.27750015258789f, 6.5001702308654785f, 30.573999404907227f,
    2.547840118408203f, 0.0f, 34.39580154418945f,
    5.812250137329102f, 0.0f, 33.261199951171875f,
    10.50979995727539f, 0.0f, 32.484901428222656f,
    14.729700088500977f, 0.0f, 31.708599090576172f,
    16.56089973449707f, 0.0f, 30.573999404907227f,
};

static const float teapot_normals[] = {
    -0.9667419791221619, 0, -0.25575199723243713,
    -0.8930140137672424, 0.3698819875717163, -0.2563450038433075,
    -0.8934370279312134, 0.36910200119018555, 0.2559970021247864,
    -0.9668239951133728, 0, 0.2554430067539215,
    -0.0838799998164177, 0.03550700098276138, 0.9958429932594299,
    -0.09205400198698044, 0, 0.9957540035247803,
    0.629721999168396, -0.2604379951953888, 0.7318620085716248,
    0.6820489764213562, 0, 0.7313070297241211,
    0.803725004196167, -0.3325839936733246, 0.4933690130710602,
    0.8703010082244873, 0, 0.4925200045108795,
    -0.6834070086479187, 0.6834070086479187, -0.2567310035228729,
    -0.6835309863090515, 0.6835309863090515, 0.25606799125671387,
    -0.06492599844932556, 0.06492500007152557, 0.9957759976387024,
    0.48139700293540955, -0.48139700293540955, 0.7324709892272949,
    0.6148040294647217, -0.6148040294647217, 0.4939970076084137,
    -0.3698819875717163, 0.8930140137672424, -0.2563450038433075,
    -0.36910200119018555, 0.8934370279312134, 0.2559959888458252,
    -0.03550700098276138, 0.0838790014386177, 0.9958429932594299,
    0.26043900847435, -0.6297230124473572, 0.7318609952926636,
    0.3325839936733246, -0.803725004196167, 0.4933690130710602,
    -0.002848000032827258, 0.9661769866943359, -0.25786298513412476,
    -0.001921999966725707, 0.9670090079307556, 0.2547360062599182,
    -0.00026500000967644155, 0.09227199852466583, 0.9957339763641357,
    0.00002300000051036477, -0.6820600032806396, 0.7312960028648376,
    0, -0.8703010082244873, 0.4925200045108795,
    -0.002848000032827258, 0.9661769866943359, -0.25786298513412476,
    0.37905800342559814, 0.852770984172821, -0.35929998755455017,
    0.37711000442504883, 0.9140909910202026, 0.14908500015735626,
    -0.001921999966725707, 0.9670090079307556, 0.2547360062599182,
    0.0275030005723238, 0.12255500257015228, 0.9920809864997864,
    -0.00026500000967644155, 0.09227199852466583, 0.9957339763641357,
    -0.26100900769233704, -0.6353650093078613, 0.7267630100250244,
    0.00002300000051036477, -0.6820600032806396, 0.7312960028648376,
    -0.33248499035835266, -0.8042709827423096, 0.4925459921360016,
    0, -0.8703010082244873, 0.4925200045108795,
    0.6635469794273376, 0.6252639889717102, -0.4107919931411743,
    0.712664008140564, 0.6976209878921509, 0.07372400164604187,
    0.09972699731588364, 0.12198299914598465, 0.98750901222229,
    -0.4873189926147461, -0.4885669946670532, 0.7237560153007507,
    -0.6152420043945312, -0.6154839992523193, 0.4926010072231293,
    0.8800280094146729, 0.3387089967727661, -0.3329069912433624,
    0.9172769784927368, 0.36149299144744873, 0.16711199283599854,
    0.11358699947595596, 0.04806999862194061, 0.9923650026321411,
    -0.6341490149497986, -0.2618879973888397, 0.7275090217590332,
    -0.8041260242462158, -0.33270499110221863, 0.49263399839401245,
    0.9666900038719177, -0.010453999973833561, -0.2557379901409149,
    0.967441976070404, -0.00810300000011921, 0.25296199321746826,
    0.0934389978647232, -0.0012799999676644802, 0.9956240057945251,
    -0.6821659803390503, 0.0003429999924264848, 0.7311969995498657,
    -0.8703219890594482, 0.00005400000009103678, 0.492482990026474,
    0.9666900038719177, -0.010453999973833561, -0.2557379901409149,
    0.8930140137672424, -0.3698819875717163, -0.2563450038433075,
    0.8934370279312134, -0.36910200119018555, 0.2559970021247864,
    0.967441976070404, -0.00810300000011921, 0.25296199321746826,
    0.0838799998164177, -0.03550700098276138, 0.9958429932594299,
    0.0934389978647232, -0.0012799999676644802, 0.9956240057945251,
    -0.629721999168396, 0.2604379951953888, 0.7318620085716248,
    -0.6821659803390503, 0.0003429999924264848, 0.7311969995498657,
    -0.803725004196167, 0.3325839936733246, 0.4933690130710602,
    -0.8703219890594482, 0.00005400000009103678, 0.492482990026474,
    0.6834070086479187, -0.6834070086479187, -0.2567310035228729,
    0.6835309863090515, -0.6835309863090515, 0.25606799125671387,
    0.06492599844932556, -0.06492500007152557, 0.9957759976387024,
    -0.48139700293540955, 0.48139700293540955, 0.7324709892272949,
    -0.6148040294647217, 0.6148040294647217, 0.4939970076084137,
    0.3698819875717163, -0.8930140137672424, -0.2563450038433075,
    0.36910200119018555, -0.8934370279312134, 0.2559959888458252,
    0.03550700098276138, -0.0838790014386177, 0.9958429932594299,
    -0.26043900847435, 0.6297230124473572, 0.7318609952926636,
    -0.3325839936733246, 0.803725004196167, 0.4933690130710602,
    0, -0.9667419791221619, -0.25575199723243713,
    0, -0.9668239951133728, 0.2554430067539215,
    0, -0.09205400198698044, 0.9957540035247803,
    0, 0.6820489764213562, 0.7313070297241211,
    0, 0.8703010082244873, 0.4925200045108795,
    0, -0.9667419791221619, -0.25575199723243713,
    -0.3698819875717163, -0.8930140137672424, -0.2563450038433075,
    -0.36910200119018555, -0.8934370279312134, 0.2559970021247864,
    0, -0.9668239951133728, 0.2554430067539215,
    -0.03550700098276138, -0.0838799998164177, 0.9958429932594299,
    0, -0.09205400198698044, 0.9957540035247803,
    0.2604379951953888, 0.629721999168396, 0.7318620085716248,
    0, 0.6820489764213562, 0.7313070297241211,
    0.3325839936733246, 0.803725004196167, 0.4933690130710602,
    0, 0.8703010082244873, 0.4925200045108795,
    -0.6834070086479187, -0.6834070086479187, -0.2567310035228729,
    -0.6835309863090515, -0.6835309863090515, 0.25606799125671387,
    -0.06492500007152557, -0.06492599844932556, 0.9957759976387024,
    0.48139700293540955, 0.48139700293540955, 0.7324709892272949,
    0.6148040294647217, 0.6148040294647217, 0.4939970076084137,
    -0.8930140137672424, -0.3698819875717163, -0.2563450038433075,
    -0.8934370279312134, -0.36910200119018555, 0.2559959888458252,
    -0.0838790014386177, -0.03550700098276138, 0.9958429932594299,
    0.6297230124473572, 0.26043900847435, 0.7318609952926636,
    0.803725004196167, 0.3325839936733246, 0.4933690130710602,
    -0.9667419791221619, 0, -0.25575199723243713,
    -0.9668239951133728, 0, 0.2554430067539215,
    -0.09205400198698044, 0, 0.9957540035247803,
    0.6820489764213562, 0, 0.7313070297241211,
    0.8703010082244873, 0, 0.4925200045108795,
    0.8703010082244873, 0, 0.4925200045108795,
    0.803725004196167, -0.3325839936733246, 0.4933690130710602,
    0.8454390168190002, -0.34983500838279724, 0.40354499220848083,
    0.9153209924697876, 0, 0.4027250111103058,
    0.8699960112571716, -0.36004599928855896, 0.33685898780822754,
    0.9418079853057861, 0, 0.33615100383758545,
    0.9041929841041565, -0.37428000569343567, 0.20579099655151367,
    0.9786900281906128, 0, 0.20534199476242065,
    0.9218789935112, -0.38175201416015625, -0.06636899709701538,
    0.9978039860725403, 0, -0.06623899936676025,
    0.6148040294647217, -0.6148040294647217, 0.4939970076084137,
    0.6468020081520081, -0.6468020081520081, 0.40409600734710693,
    0.6656550168991089, -0.6656550168991089, 0.3373520076274872,
    0.6919230222702026, -0.6919230222702026, 0.20611999928951263,
    0.7055429816246033, -0.7055429816246033, -0.06647899746894836,
    0.3325839936733246, -0.803725004196167, 0.4933690130710602,
    0.34983500838279724, -0.8454390168190002, 0.40354499220848083,
    0.36004701256752014, -0.8699960112571716, 0.33685800433158875,
    0.37428000569343567, -0.9041929841041565, 0.20579099655151367,
    0.38175201416015625, -0.9218789935112, -0.06636899709701538,
    0, -0.8703010082244873, 0.4925200045108795,
    0, -0.9153209924697876, 0.4027250111103058,
    0, -0.9418079853057861, 0.33615100383758545,
    0, -0.9786900281906128, 0.20534199476242065,
    0, -0.9978039860725403, -0.06623899936676025,
    0, -0.8703010082244873, 0.4925200045108795,
    -0.33248499035835266, -0.8042709827423096, 0.4925459921360016,
    -0.34983500838279724, -0.8454390168190002, 0.40354499220848083,
    0, -0.9153209924697876, 0.4027250111103058,
    -0.36004599928855896, -0.8699960112571716, 0.33685898780822754,
    0, -0.9418079853057861, 0.33615100383758545,
    -0.37428000569343567, -0.9041929841041565, 0.20579099655151367,
    0, -0.9786900281906128, 0.20534199476242065,
    -0.38175201416015625, -0.9218789935112, -0.06636899709701538,
    0, -0.9978039860725403, -0.06623899936676025,
    -0.6152420043945312, -0.6154839992523193, 0.4926010072231293,
    -0.6468020081520081, -0.6468020081520081, 0.40409600734710693,
    -0.6656550168991089, -0.6656550168991089, 0.3373520076274872,
    -0.6919230222702026, -0.6919230222702026, 0.20611999928951263,
    -0.7055429816246033, -0.7055429816246033, -0.06647899746894836,
    -0.8041260242462158, -0.33270499110221863, 0.49263399839401245,
    -0.8454390168190002, -0.34983500838279724, 0.40354499220848083,
    -0.8699960112571716, -0.36004701256752014, 0.33685800433158875,
    -0.9041929841041565, -0.37428000569343567, 0.20579099655151367,
    -0.9218789935112, -0.38175201416015625, -0.06636899709701538,
    -0.8703219890594482, 0.00005400000009103678, 0.492482990026474,
    -0.9153209924697876, 0, 0.4027250111103058,
    -0.9418079853057861, 0, 0.33615100383758545,
    -0.9786900281906128, 0, 0.20534199476242065,
    -0.9978039860725403, 0, -0.06623899936676025,
    -0.8703219890594482, 0.00005400000009103678, 0.492482990026474,
    -0.803725004196167, 0.3325839936733246, 0.4933690130710602,
    -0.8454390168190002, 0.34983500838279724, 0.40354499220848083,
    -0.9153209924697876, 0, 0.4027250111103058,
    -0.8699960112571716, 0.36004599928855896, 0.33685898780822754,
    -0.9418079853057861, 0, 0.33615100383758545,
    -0.9041929841041565, 0.37428000569343567, 0.20579099655151367,
    -0.9786900281906128, 0, 0.20534199476242065,
    -0.9218789935112, 0.38175201416015625, -0.06636899709701538,
    -0.9978039860725403, 0, -0.06623899936676025,
    -0.6148040294647217, 0.6148040294647217, 0.4939970076084137,
    -0.6468020081520081, 0.6468020081520081, 0.40409600734710693,
    -0.6656550168991089, 0.6656550168991089, 0.3373520076274872,
    -0.6919230222702026, 0.6919230222702026, 0.20611999928951263,
    -0.7055429816246033, 0.7055429816246033, -0.06647899746894836,
    -0.3325839936733246, 0.803725004196167, 0.4933690130710602,
    -0.34983500838279724, 0.8454390168190002, 0.40354499220848083,
    -0.36004701256752014, 0.8699960112571716, 0.33685800433158875,
    -0.37428000569343567, 0.9041929841041565, 0.20579099655151367,
    -0.38175201416015625, 0.9218789935112, -0.06636899709701538,
    0, 0.8703010082244873, 0.4925200045108795,
    0, 0.9153209924697876, 0.4027250111103058,
    0, 0.9418079853057861, 0.33615100383758545,
    0, 0.9786900281906128, 0.20534199476242065,
    0, 0.9978039860725403, -0.06623899936676025,
    0, 0.8703010082244873, 0.4925200045108795,
    0.3325839936733246, 0.803725004196167, 0.4933690130710602,
    0.34983500838279724, 0.8454390168190002, 0.40354499220848083,
    0, 0.9153209924697876, 0.4027250111103058,
    0.36004599928855896, 0.8699960112571716, 0.33685898780822754,
    0, 0.9418079853057861, 0.33615100383758545,
    0.37428000569343567, 0.9041929841041565, 0.20579099655151367,
    0, 0.9786900281906128, 0.20534199476242065,
    0.38175201416015625, 0.9218789935112, -0.06636899709701538,
    0, 0.9978039860725403, -0.06623899936676025,
    0.6148040294647217, 0.6148040294647217, 0.4939970076084137,
    0.6468020081520081, 0.6468020081520081, 0.40409600734710693,
    0.6656550168991089, 0.6656550168991089, 0.3373520076274872,
    0.6919230222702026, 0.6919230222702026, 0.20611999928951263,
    0.7055429816246033, 0.7055429816246033, -0.06647899746894836,
    0.803725004196167, 0.3325839936733246, 0.4933690130710602,
    0.8454390168190002, 0.34983500838279724, 0.40354499220848083,
    0.8699960112571716, 0.36004701256752014, 0.33685800433158875,
    0.9041929841041565, 0.37428000569343567, 0.20579099655151367,
    0.9218789935112, 0.38175201416015625, -0.06636899709701538,
    0.8703010082244873, 0, 0.4925200045108795,
    0.9153209924697876, 0, 0.4027250111103058,
    0.9418079853057861, 0, 0.33615100383758545,
    0.9786900281906128, 0, 0.20534199476242065,
    0.9978039860725403, 0, -0.06623899936676025,
    0.9978039860725403, 0, -0.06623899936676025,
    0.9218789935112, -0.38175201416015625, -0.06636899709701538,
    0.8314369916915894, -0.3441790044307709, -0.4361799955368042,
    0.9001820087432861, 0, -0.4355129897594452,
    0.6735119819641113, -0.2785939872264862, -0.6846650242805481,
    0.7296109795570374, 0, -0.6838629841804504,
    0.6403989791870117, -0.26487401127815247, -0.7209240198135376,
    0.6939510107040405, 0, -0.7200220227241516,
    0.7329490184783936, -0.303166002035141, -0.6089959740638733,
    0.7939500212669373, 0, -0.6079840064048767,
    0.7055429816246033, -0.7055429816246033, -0.06647899746894836,
    0.6360920071601868, -0.6360920071601868, -0.4367780089378357,
    0.5149649977684021, -0.5149649977684021, -0.6852890253067017,
    0.48965099453926086, -0.48965099453926086, -0.7214459776878357,
    0.5605549812316895, -0.5605549812316895, -0.6095539927482605,
    0.38175201416015625, -0.9218789935112, -0.06636899709701538,
    0.3441790044307709, -0.8314369916915894, -0.4361799955368042,
    0.2785939872264862, -0.6735119819641113, -0.6846650242805481,
    0.26487401127815247, -0.6403989791870117, -0.7209240198135376,
    0.303166002035141, -0.7329490184783936, -0.6089959740638733,
    0, -0.9978039860725403, -0.06623899936676025,
    0, -0.9001820087432861, -0.4355129897594452,
    0, -0.7296109795570374, -0.6838629841804504,
    0, -0.6939510107040405, -0.7200220227241516,
    0, -0.7939500212669373, -0.6079840064048767,
    0, -0.9978039860725403, -0.06623899936676025,
    -0.38175201416015625, -0.9218789935112, -0.06636899709701538,
    -0.3441790044307709, -0.8314369916915894, -0.4361799955368042,
    0, -0.9001820087432861, -0.4355129897594452,
    -0.2785939872264862, -0.6735119819641113, -0.6846650242805481,
    0, -0.7296109795570374, -0.6838629841804504,
    -0.26487401127815247, -0.6403989791870117, -0.7209240198135376,
    0, -0.6939510107040405, -0.7200220227241516,
    -0.303166002035141, -0.7329490184783936, -0.6089959740638733,
    0, -0.7939500212669373, -0.6079840064048767,
    -0.7055429816246033, -0.7055429816246033, -0.06647899746894836,
    -0.6360920071601868, -0.6360920071601868, -0.4367780089378357,
    -0.5149649977684021, -0.5149649977684021, -0.6852890253067017,
    -0.48965099453926086, -0.48965099453926086, -0.7214459776878357,
    -0.5605549812316895, -0.5605549812316895, -0.6095539927482605,
    -0.9218789935112, -0.38175201416015625, -0.06636899709701538,
    -0.8314369916915894, -0.3441790044307709, -0.4361799955368042,
    -0.6735119819641113, -0.2785939872264862, -0.6846650242805481,
    -0.6403989791870117, -0.26487401127815247, -0.7209240198135376,
    -0.7329490184783936, -0.303166002035141, -0.6089959740638733,
    -0.9978039860725403, 0, -0.06623899936676025,
    -0.9001820087432861, 0, -0.4355129897594452,
    -0.7296109795570374, 0, -0.6838629841804504,
    -0.6939510107040405, 0, -0.7200220227241516,
    -0.7939500212669373, 0, -0.6079840064048767,
    -0.9978039860725403, 0, -0.06623899936676025,
    -0.9218789935112, 0.38175201416015625, -0.06636899709701538,
    -0.8314369916915894, 0.3441790044307709, -0.4361799955368042,
    -0.9001820087432861, 0, -0.4355129897594452,
    -0.6735119819641113, 0.2785939872264862, -0.6846650242805481,
    -0.7296109795570374, 0, -0.6838629841804504,
    -0.6403989791870117, 0.26487401127815247, -0.7209240198135376,
    -0.6939510107040405, 0, -0.7200220227241516,
    -0.7329490184783936, 0.303166002035141, -0.6089959740638733,
    -0.7939500212669373, 0, -0.6079840064048767,
    -0.7055429816246033, 0.7055429816246033, -0.06647899746894836,
    -0.6360920071601868, 0.6360920071601868, -0.4367780089378357,
    -0.5149649977684021, 0.5149649977684021, -0.6852890253067017,
    -0.48965099453926086, 0.48965099453926086, -0.7214459776878357,
    -0.5605549812316895, 0.5605549812316895, -0.6095539927482605,
    -0.38175201416015625, 0.9218789935112, -0.06636899709701538,
    -0.3441790044307709, 0.8314369916915894, -0.4361799955368042,
    -0.2785939872264862, 0.6735119819641113, -0.6846650242805481,
    -0.26487401127815247, 0.6403989791870117, -0.7209240198135376,
    -0.303166002035141, 0.7329490184783936, -0.6089959740638733,
    0, 0.9978039860725403, -0.06623899936676025,
    0, 0.9001820087432861, -0.4355129897594452,
    0, 0.7296109795570374, -0.6838629841804504,
    0, 0.6939510107040405, -0.7200220227241516,
    0, 0.7939500212669373, -0.6079840064048767,
    0, 0.9978039860725403, -0.06623899936676025,
    0.38175201416015625, 0.9218789935112, -0.06636899709701538,
    0.3441790044307709, 0.8314369916915894, -0.4361799955368042,
    0, 0.9001820087432861, -0.4355129897594452,
    0.2785939872264862, 0.6735119819641113, -0.6846650242805481,
    0, 0.7296109795570374, -0.6838629841804504,
    0.26487401127815247, 0.6403989791870117, -0.7209240198135376,
    0, 0.6939510107040405, -0.7200220227241516,
    0.303166002035141, 0.7329490184783936, -0.6089959740638733,
    0, 0.7939500212669373, -0.6079840064048767,
    0.7055429816246033, 0.7055429816246033, -0.06647899746894836,
    0.6360920071601868, 0.6360920071601868, -0.4367780089378357,
    0.5149649977684021, 0.5149649977684021, -0.6852890253067017,
    0.48965099453926086, 0.48965099453926086, -0.7214459776878357,
    0.5605549812316895, 0.5605549812316895, -0.6095539927482605,
    0.9218789935112, 0.38175201416015625, -0.06636899709701538,
    0.8314369916915894, 0.3441790044307709, -0.4361799955368042,
    0.6735119819641113, 0.2785939872264862, -0.6846650242805481,
    0.6403989791870117, 0.26487401127815247, -0.7209240198135376,
    0.7329490184783936, 0.303166002035141, -0.6089959740638733,
    0.9978039860725403, 0, -0.06623899936676025,
    0.9001820087432861, 0, -0.4355129897594452,
    0.7296109795570374, 0, -0.6838629841804504,
    0.6939510107040405, 0, -0.7200220227241516,
    0.7939500212669373, 0, -0.6079840064048767,
    0.7939500212669373, 0, -0.6079840064048767,
    0.7329490184783936, -0.303166002035141, -0.6089959740638733,
    0.576229989528656, -0.23821599781513214, -0.7818009853363037,
    0.6238600015640259, 0, -0.7815359830856323,
    0.16362899541854858, -0.06752700358629227, -0.9842079877853394,
    0.17729100584983826, 0, -0.984158992767334,
    0.04542100057005882, -0.018735000863671303, -0.9987919926643372,
    0.04920699819922447, 0, -0.9987890124320984,
    0, 0, -1,
    0, 0, -1,
    0.5605549812316895, -0.5605549812316895, -0.6095539927482605,
    0.44041600823402405, -0.44041600823402405, -0.7823479771614075,
    0.12490200251340866, -0.12490200251340866, -0.9842759966850281,
    0.034662000834941864, -0.034662000834941864, -0.9987980127334595,
    0, 0, -1,
    0.303166002035141, -0.7329490184783936, -0.6089959740638733,
    0.23821599781513214, -0.576229989528656, -0.7818009853363037,
    0.06752700358629227, -0.16362899541854858, -0.9842079877853394,
    0.018735000863671303, -0.04542100057005882, -0.9987919926643372,
    0, 0, -1,
    0, -0.7939500212669373, -0.6079840064048767,
    0, -0.6238600015640259, -0.7815359830856323,
    0, -0.17729100584983826, -0.984158992767334,
    0, -0.04920699819922447, -0.9987890124320984,
    0, 0, -1,
    0, -0.7939500212669373, -0.6079840064048767,
    -0.303166002035141, -0.7329490184783936, -0.6089959740638733,
    -0.23821599781513214, -0.576229989528656, -0.7818009853363037,
    0, -0.6238600015640259, -0.7815359830856323,
    -0.06752700358629227, -0.16362899541854858, -0.9842079877853394,
    0, -0.17729100584983826, -0.984158992767334,
    -0.018735000863671303, -0.04542100057005882, -0.9987919926643372,
    0, -0.04920699819922447, -0.9987890124320984,
    0, 0, -1,
    0, 0, -1,
    -0.5605549812316895, -0.5605549812316895, -0.6095539927482605,
    -0.44041600823402405, -0.44041600823402405, -0.7823479771614075,
    -0.12490200251340866, -0.12490200251340866, -0.9842759966850281,
    -0.034662000834941864, -0.034662000834941864, -0.9987980127334595,
    0, 0, -1,
    -0.7329490184783936, -0.303166002035141, -0.6089959740638733,
    -0.576229989528656, -0.23821599781513214, -0.7818009853363037,
    -0.16362899541854858, -0.06752700358629227, -0.9842079877853394,
    -0.04542100057005882, -0.018735000863671303, -0.9987919926643372,
    0, 0, -1,
    -0.7939500212669373, 0, -0.6079840064048767,
    -0.6238600015640259, 0, -0.7815359830856323,
    -0.17729100584983826, 0, -0.984158992767334,
    -0.04920699819922447, 0, -0.9987890124320984,
    0, 0, -1,
    -0.7939500212669373, 0, -0.6079840064048767,
    -0.7329490184783936, 0.303166002035141, -0.6089959740638733,
    -0.576229989528656, 0.23821599781513214, -0.7818009853363037,
    -0.6238600015640259, 0, -0.7815359830856323,
    -0.16362899541854858, 0.06752700358629227, -0.9842079877853394,
    -0.17729100584983826, 0, -0.984158992767334,
    -0.04542100057005882, 0.018735000863671303, -0.9987919926643372,
    -0.04920699819922447, 0, -0.9987890124320984,
    0, 0, -1,
    0, 0, -1,
    -0.5605549812316895, 0.5605549812316895, -0.6095539927482605,
    -0.44041600823402405, 0.44041600823402405, -0.7823479771614075,
    -0.12490200251340866, 0.12490200251340866, -0.9842759966850281,
    -0.034662000834941864, 0.034662000834941864, -0.9987980127334595,
    0, 0, -1,
    -0.303166002035141, 0.7329490184783936, -0.6089959740638733,
    -0.23821599781513214, 0.576229989528656, -0.7818009853363037,
    -0.06752700358629227, 0.16362899541854858, -0.9842079877853394,
    -0.018735000863671303, 0.04542100057005882, -0.9987919926643372,
    0, 0, -1,
    0, 0.7939500212669373, -0.6079840064048767,
    0, 0.6238600015640259, -0.7815359830856323,
    0, 0.17729100584983826, -0.984158992767334,
    0, 0.04920699819922447, -0.9987890124320984,
    0, 0, -1,
    0, 0.7939500212669373, -0.6079840064048767,
    0.303166002035141, 0.7329490184783936, -0.6089959740638733,
    0.23821599781513214, 0.576229989528656, -0.7818009853363037,
    0, 0.6238600015640259, -0.7815359830856323,
    0.06752700358629227, 0.16362899541854858, -0.9842079877853394,
    0, 0.17729100584983826, -0.984158992767334,
    0.018735000863671303, 0.04542100057005882, -0.9987919926643372,
    0, 0.04920699819922447, -0.9987890124320984,
    0, 0, -1,
    0, 0, -1,
    0.5605549812316895, 0.5605549812316895, -0.6095539927482605,
    0.44041600823402405, 0.44041600823402405, -0.7823479771614075,
    0.12490200251340866, 0.12490200251340866, -0.9842759966850281,
    0.034662000834941864, 0.034662000834941864, -0.9987980127334595,
    0, 0, -1,
    0.7329490184783936, 0.303166002035141, -0.6089959740638733,
    0.576229989528656, 0.23821599781513214, -0.7818009853363037,
    0.16362899541854858, 0.06752700358629227, -0.9842079877853394,
    0.04542100057005882, 0.018735000863671303, -0.9987919926643372,
    0, 0, -1,
    0.7939500212669373, 0, -0.6079840064048767,
    0.6238600015640259, 0, -0.7815359830856323,
    0.17729100584983826, 0, -0.984158992767334,
    0.04920699819922447, 0, -0.9987890124320984,
    0, 0, -1,
    0.007784999907016754, 0.00021499999274965376, -0.999970018863678,
    0.007038000039756298, -0.5829259753227234, -0.8124949932098389,
    0.0361270010471344, -0.5456140041351318, -0.837257981300354,
    0.03913800045847893, 0.0009879999561235309, -0.9992330074310303,
    0.16184599697589874, -0.5630490183830261, -0.8104209899902344,
    0.17951199412345886, 0.0043680001981556416, -0.9837459921836853,
    0.4823650121688843, -0.6427459716796875, -0.5951480269432068,
    0.6122999787330627, 0.010459000244736671, -0.790556013584137,
    0.7387199997901917, -0.6641989946365356, -0.11459299921989441,
    0.9861519932746887, 0.006668999791145325, -0.16570700705051422,
    -0.0019079999765381217, -0.9867690205574036, 0.1621209979057312,
    0.002761000068858266, -0.9998499751091003, 0.017105000093579292,
    0.010532000102102757, -0.9972469806671143, 0.07339800149202347,
    -0.06604000180959702, -0.9893029928207397, 0.13006900250911713,
    -0.09442699700593948, -0.9953929781913757, 0.016594000160694122,
    -0.009201999753713608, -0.4902929961681366, 0.8715090155601501,
    -0.04860600084066391, -0.5394579768180847, 0.8406090140342712,
    -0.22329799830913544, -0.5527390241622925, 0.8028810024261475,
    -0.5963649749755859, -0.5751349925994873, 0.5599709749221802,
    -0.8033369779586792, -0.5916029810905457, 0.06823500245809555,
    -0.01056000031530857, -0.00010299999848939478, 0.9999439716339111,
    -0.05879800021648407, -0.0007089999853633344, 0.9982699751853943,
    -0.28071001172065735, -0.0032679999712854624, 0.9597870111465454,
    -0.7497230172157288, -0.004267000127583742, 0.6617379784584045,
    -0.9973509907722473, -0.0020580000709742308, 0.07271400094032288,
    -0.01056000031530857, -0.00010299999848939478, 0.9999439716339111,
    -0.008791999891400337, 0.49032899737358093, 0.8714929819107056,
    -0.04649300128221512, 0.5387560129165649, 0.8411779999732971,
    -0.05879800021648407, -0.0007089999853633344, 0.9982699751853943,
    -0.21790899336338043, 0.5491610169410706, 0.8068069815635681,
    -0.28071001172065735, -0.0032679999712854624, 0.9597870111465454,
    -0.5972909927368164, 0.5741199851036072, 0.560027003288269,
    -0.7497230172157288, -0.004267000127583742, 0.6617379784584045,
    -0.8040000200271606, 0.5912910103797913, 0.0629120022058487,
    -0.9973509907722473, -0.0020580000709742308, 0.07271400094032288,
    -0.0018050000071525574, 0.986840009689331, 0.16169099509716034,
    0.0020310000982135534, 0.999891996383667, 0.014553000219166279,
    0.009215000085532665, 0.9981520175933838, 0.060068998485803604,
    -0.059335000813007355, 0.9917230010032654, 0.11386600136756897,
    -0.08690100163221359, 0.9961410164833069, 0.01228999998420477,
    0.006417000200599432, 0.5830950140953064, -0.812379002571106,
    0.03378299996256828, 0.5453730225563049, -0.8375130295753479,
    0.1571130007505417, 0.562188982963562, -0.8119469881057739,
    0.4844059944152832, 0.6465290188789368, -0.5893650054931641,
    0.7388700246810913, 0.6661880016326904, -0.10131999850273132,
    0.007784999907016754, 0.00021499999274965376, -0.999970018863678,
    0.03913800045847893, 0.0009879999561235309, -0.9992330074310303,
    0.17951199412345886, 0.0043680001981556416, -0.9837459921836853,
    0.6122999787330627, 0.010459000244736671, -0.790556013584137,
    0.9861519932746887, 0.006668999791145325, -0.16570700705051422,
    0.9861519932746887, 0.006668999791145325, -0.16570700705051422,
    0.7387199997901917, -0.6641989946365356, -0.11459299921989441,
    0.7256090044975281, -0.6373609900474548, 0.25935098528862,
    0.94651198387146, 0.0033569999504834414, 0.3226499855518341,
    0.6459450125694275, -0.6077200174331665, 0.46198800206184387,
    0.8258299827575684, 0.007451999932527542, 0.5638700127601624,
    0.5316150188446045, -0.5586140155792236, 0.6366599798202515,
    0.6500110030174255, 0.006936000194400549, 0.759893000125885,
    0.4249640107154846, -0.5955389738082886, 0.6817179918289185,
    0.5324289798736572, 0.005243999883532524, 0.8464580178260803,
    -0.09442699700593948, -0.9953929781913757, 0.016594000160694122,
    -0.04956100136041641, -0.9985759854316711, -0.01975500024855137,
    -0.03781700134277344, -0.998649001121521, -0.035624999552965164,
    -0.0379129983484745, -0.9986140131950378, -0.03651199862360954,
    -0.1688539981842041, -0.9395300149917603, -0.2979460060596466,
    -0.8033369779586792, -0.5916029810905457, 0.06823500245809555,
    -0.7423409819602966, -0.5995240211486816, -0.2991659939289093,
    -0.6196020245552063, -0.5795029997825623, -0.5294060111045837,
    -0.483707994222641, -0.5438370108604431, -0.6857600212097168,
    -0.44529199600219727, -0.4131770133972168, -0.7943549752235413,
    -0.9973509907722473, -0.0020580000709742308, 0.07271400094032288,
    -0.9265130162239075, -0.0019950000569224358, -0.3762570023536682,
    -0.7539200186729431, -0.004317000042647123, -0.6569520235061646,
    -0.5662239789962769, -0.003461000043898821, -0.8242440223693848,
    -0.4818040132522583, -0.0018500000005587935, -0.8762770295143127,
    -0.9973509907722473, -0.0020580000709742308, 0.07271400094032288,
    -0.8040000200271606, 0.5912910103797913, 0.0629120022058487,
    -0.7446749806404114, 0.5989770293235779, -0.29442399740219116,
    -0.9265130162239075, -0.0019950000569224358, -0.3762570023536682,
    -0.6219490170478821, 0.5781649947166443, -0.5281140208244324,
    -0.7539200186729431, -0.004317000042647123, -0.6569520235061646,
    -0.48117101192474365, 0.5428280234336853, -0.6883400082588196,
    -0.5662239789962769, -0.003461000043898821, -0.8242440223693848,
    -0.43805500864982605, 0.41574400663375854, -0.7970349788665771,
    -0.4818040132522583, -0.0018500000005587935, -0.8762770295143127,
    -0.08690100163221359, 0.9961410164833069, 0.01228999998420477,
    -0.04433799907565117, 0.9988710284233093, -0.017055999487638474,
    -0.026177000254392624, 0.9992600083351135, -0.02816700004041195,
    -0.025293000042438507, 0.9992780089378357, -0.028332000598311424,
    -0.15748199820518494, 0.9441670179367065, -0.28939300775527954,
    0.7388700246810913, 0.6661880016326904, -0.10131999850273132,
    0.7282440066337585, 0.63714200258255, 0.25240999460220337,
    0.6470540165901184, 0.6082550287246704, 0.4597249925136566,
    0.5229939818382263, 0.5621700286865234, 0.6406570076942444,
    0.4099780023097992, 0.6046689748764038, 0.6828569769859314,
    0.9861519932746887, 0.006668999791145325, -0.16570700705051422,
    0.94651198387146, 0.0033569999504834414, 0.3226499855518341,
    0.8258299827575684, 0.007451999932527542, 0.5638700127601624,
    0.6500110030174255, 0.006936000194400549, 0.759893000125885,
    0.5324289798736572, 0.005243999883532524, 0.8464580178260803,
    -0.230786994099617, 0.006523000076413155, 0.9729819893836975,
    -0.15287800133228302, -0.7101899981498718, 0.6872109770774841,
    -0.31672099232673645, -0.7021129727363586, 0.6377500295639038,
    -0.5489360094070435, 0.0015109999803826213, 0.8358629941940308,
    -0.6010670065879822, -0.645330011844635, 0.471451997756958,
    -0.8756710290908813, -0.009891999885439873, 0.4828070104122162,
    -0.635890007019043, -0.629800021648407, 0.4460900127887726,
    -0.8775539994239807, -0.01909100078046322, 0.47909700870513916,
    -0.4357450008392334, -0.670009970664978, 0.6010090112686157,
    -0.6961889863014221, -0.02449600026011467, 0.7174400091171265,
    0.11111299693584442, -0.9901599884033203, -0.08506900072097778,
    0.22330999374389648, -0.9747260212898254, 0.006539999973028898,
    0.19009700417518616, -0.9694579839706421, 0.15496399998664856,
    0.005270000081509352, -0.9818699955940247, 0.18948200345039368,
    -0.011750999838113785, -0.9690240025520325, 0.24668699502944946,
    0.3439059853553772, -0.5994120240211487, -0.7227950096130371,
    0.5724899768829346, -0.5916270017623901, -0.5676559805870056,
    0.7874360084533691, -0.5605109930038452, -0.2564600110054016,
    0.6470969915390015, -0.6981409788131714, -0.3063740134239197,
    0.4275279939174652, -0.7535750269889832, -0.49934399127960205,
    0.4109260141849518, -0.0012839999981224537, -0.9116680026054382,
    0.6715199947357178, 0.0008989999769255519, -0.7409859895706177,
    0.9220259785652161, 0.00725199980661273, -0.3870599865913391,
    0.8469099998474121, 0.01385399978607893, -0.5315560102462769,
    0.5359240174293518, 0.010503999888896942, -0.8442010283470154,
    0.4109260141849518, -0.0012839999981224537, -0.9116680026054382,
    0.3411880135536194, 0.6009309887886047, -0.7228230237960815,
    0.5786640048027039, 0.591838002204895, -0.5611389875411987,
    0.6715199947357178, 0.0008989999769255519, -0.7409859895706177,
    0.7848690152168274, 0.5665420293807983, -0.25102001428604126,
    0.9220259785652161, 0.00725199980661273, -0.3870599865913391,
    0.6426810026168823, 0.7039899826049805, -0.3022570013999939,
    0.8469099998474121, 0.01385399978607893, -0.5315560102462769,
    0.4185889959335327, 0.7581170201301575, -0.5000420212745667,
    0.5359240174293518, 0.010503999888896942, -0.8442010283470154,
    0.11580599844455719, 0.9901139736175537, -0.07913900166749954,
    0.23281100392341614, 0.9724410176277161, 0.012564999982714653,
    0.20666299760341644, 0.9662799835205078, 0.15360000729560852,
    0.02449899911880493, 0.9865779876708984, 0.16144299507141113,
    0.0033809999004006386, 0.9774550199508667, 0.2111150026321411,
    -0.13491199910640717, 0.7135509848594666, 0.6874909996986389,
    -0.31953999400138855, 0.7050619721412659, 0.6330729722976685,
    -0.6039019823074341, 0.6499029994010925, 0.4614419937133789,
    -0.6318150162696838, 0.6400719881057739, 0.43716898560523987,
    -0.4243049919605255, 0.6667500138282776, 0.6127070188522339,
    -0.230786994099617, 0.006523000076413155, 0.9729819893836975,
    -0.5489360094070435, 0.0015109999803826213, 0.8358629941940308,
    -0.8756710290908813, -0.009891999885439873, 0.4828070104122162,
    -0.8775539994239807, -0.01909100078046322, 0.47909700870513916,
    -0.6961889863014221, -0.02449600026011467, 0.7174400091171265,
    -0.6961889863014221, -0.02449600026011467, 0.7174400091171265,
    -0.4357450008392334, -0.670009970664978, 0.6010090112686157,
    -0.25985801219940186, -0.5525479912757874, 0.7919380068778992,
    -0.42579901218414307, -0.010804999619722366, 0.9047530293464661,
    0.009537000209093094, 0.021669000387191772, 0.9997199773788452,
    0.022041000425815582, -0.001623000018298626, 0.9997559785842896,
    0.4101540148258209, 0.8490809798240662, 0.3329179883003235,
    0.9995980262756348, -0.01155600044876337, 0.02587899938225746,
    0.5415220260620117, 0.6370009779930115, -0.5486199855804443,
    0.7095860242843628, -0.009670999832451344, -0.7045519948005676,
    -0.011750999838113785, -0.9690240025520325, 0.24668699502944946,
    0.046310000121593475, -0.8891720175743103, 0.45522499084472656,
    -0.010688000358641148, -0.14889900386333466, 0.9887949824333191,
    -0.04437499865889549, 0.7291200160980225, 0.6829460263252258,
    0.12282499670982361, 0.9923850297927856, 0.009232000447809696,
    0.4275279939174652, -0.7535750269889832, -0.49934399127960205,
    0.48183900117874146, -0.857479989528656, -0.18044300377368927,
    0.45527198910713196, -0.49992498755455017, 0.7367510199546814,
    -0.22054199874401093, 0.3582780063152313, 0.9071930050849915,
    -0.23591899871826172, 0.7157959938049316, 0.6572499871253967,
    0.5359240174293518, 0.010503999888896942, -0.8442010283470154,
    0.7280910015106201, 0.015584999695420265, -0.6853029727935791,
    0.8887389898300171, 0.016679000109434128, 0.4581089913845062,
    -0.26009801030158997, -0.0007999999797903001, 0.965582013130188,
    -0.37161099910736084, 0.004416999872773886, 0.9283779859542847,
    0.5359240174293518, 0.010503999888896942, -0.8442010283470154,
    0.4185889959335327, 0.7581170201301575, -0.5000420212745667,
    0.4801650047302246, 0.8588529825210571, -0.17836299538612366,
    0.7280910015106201, 0.015584999695420265, -0.6853029727935791,
    0.4881030023097992, 0.49794700741767883, 0.7168020009994507,
    0.8887389898300171, 0.016679000109434128, 0.4581089913845062,
    -0.2220049947500229, -0.36189401149749756, 0.9053990244865417,
    -0.26009801030158997, -0.0007999999797903001, 0.965582013130188,
    -0.23540399968624115, -0.7104769945144653, 0.6631799936294556,
    -0.37161099910736084, 0.004416999872773886, 0.9283779859542847,
    0.0033809999004006386, 0.9774550199508667, 0.2111150026321411,
    0.058719001710414886, 0.8971999883651733, 0.437703013420105,
    0.0013249999610707164, 0.164000004529953, 0.9864590167999268,
    -0.04418899863958359, -0.7303190231323242, 0.6816750168800354,
    0.13880200684070587, -0.9897300004959106, -0.034189000725746155,
    -0.4243049919605255, 0.6667500138282776, 0.6127070188522339,
    -0.25888898968696594, 0.5453789830207825, 0.7972059845924377,
    0.012268000282347202, -0.01928500086069107, 0.9997389912605286,
    0.3986299932003021, -0.8456630110740662, 0.3548929989337921,
    0.5375639796257019, -0.6107370257377625, -0.5813990235328674,
    -0.6961889863014221, -0.02449600026011467, 0.7174400091171265,
    -0.42579901218414307, -0.010804999619722366, 0.9047530293464661,
    0.022041000425815582, -0.001623000018298626, 0.9997559785842896,
    0.9995980262756348, -0.01155600044876337, 0.02587899938225746,
    0.7095860242843628, -0.009670999832451344, -0.7045519948005676,
    0, 0, 1,
    0, 0, 1,
    0.7626410126686096, -0.31482499837875366, 0.5650339722633362,
    0.8245400190353394, -0.00001700000029813964, 0.5658029913902283,
    0.8479819893836975, -0.3500339984893799, -0.39799800515174866,
    0.917701005935669, -0.00003300000025774352, -0.397271990776062,
    0.8641409873962402, -0.35644200444221497, -0.3552600145339966,
    0.9352689981460571, -0.00011200000153621659, -0.3539389967918396,
    0.7209920287132263, -0.29793301224708557, 0.6256250143051147,
    0.7807120084762573, -0.00007500000356230885, 0.6248909831047058,
    0, 0, 1,
    0.5833569765090942, -0.5833380222320557, 0.5651649832725525,
    0.648485004901886, -0.6484479904174805, -0.3987259864807129,
    0.6608719825744629, -0.6607480049133301, -0.35589399933815,
    0.5518630146980286, -0.5517799854278564, 0.6252880096435547,
    0, 0, 1,
    0.31482499837875366, -0.762628972530365, 0.5650510191917419,
    0.35004499554634094, -0.8479880094528198, -0.39797601103782654,
    0.35647401213645935, -0.8641520142555237, -0.35519900918006897,
    0.29798200726509094, -0.7210670113563538, 0.6255149841308594,
    0, 0, 1,
    -0.00001700000029813964, -0.8245400190353394, 0.5658029913902283,
    -0.00003300000025774352, -0.917701005935669, -0.397271990776062,
    -0.00011200000153621659, -0.9352689981460571, -0.3539389967918396,
    -0.00007500000356230885, -0.7807120084762573, 0.6248900294303894,
    0, 0, 1,
    0, 0, 1,
    -0.31482499837875366, -0.7626410126686096, 0.5650339722633362,
    -0.00001700000029813964, -0.8245400190353394, 0.5658029913902283,
    -0.3500339984893799, -0.8479819893836975, -0.39799800515174866,
    -0.00003300000025774352, -0.917701005935669, -0.397271990776062,
    -0.35644200444221497, -0.8641409873962402, -0.3552600145339966,
    -0.00011200000153621659, -0.9352689981460571, -0.3539389967918396,
    -0.29793301224708557, -0.7209920287132263, 0.6256250143051147,
    -0.00007500000356230885, -0.7807120084762573, 0.6248900294303894,
    0, 0, 1,
    -0.5833380222320557, -0.5833569765090942, 0.5651649832725525,
    -0.6484479904174805, -0.648485004901886, -0.3987259864807129,
    -0.6607480049133301, -0.6608719825744629, -0.35589399933815,
    -0.5517799854278564, -0.5518630146980286, 0.6252880096435547,
    0, 0, 1,
    -0.762628972530365, -0.31482499837875366, 0.5650510191917419,
    -0.8479880094528198, -0.35004499554634094, -0.39797601103782654,
    -0.8641520142555237, -0.35647401213645935, -0.35519900918006897,
    -0.7210670113563538, -0.29798200726509094, 0.6255149841308594,
    0, 0, 1,
    -0.8245400190353394, 0.00001700000029813964, 0.5658029913902283,
    -0.917701005935669, 0.00003300000025774352, -0.397271990776062,
    -0.9352689981460571, 0.00011200000153621659, -0.3539389967918396,
    -0.7807120084762573, 0.00007500000356230885, 0.6248900294303894,
    0, 0, 1,
    0, 0, 1,
    -0.7626410126686096, 0.31482499837875366, 0.5650339722633362,
    -0.8245400190353394, 0.00001700000029813964, 0.5658029913902283,
    -0.8479819893836975, 0.3500339984893799, -0.39799800515174866,
    -0.917701005935669, 0.00003300000025774352, -0.397271990776062,
    -0.8641409873962402, 0.35644200444221497, -0.3552600145339966,
    -0.9352689981460571, 0.00011200000153621659, -0.3539389967918396,
    -0.7209920287132263, 0.29793301224708557, 0.6256250143051147,
    -0.7807120084762573, 0.00007500000356230885, 0.6248900294303894,
    0, 0, 1,
    -0.5833569765090942, 0.5833380222320557, 0.5651649832725525,
    -0.648485004901886, 0.6484479904174805, -0.3987259864807129,
    -0.6608719825744629, 0.6607480049133301, -0.35589399933815,
    -0.5518630146980286, 0.5517799854278564, 0.6252880096435547,
    0, 0, 1,
    -0.31482499837875366, 0.762628972530365, 0.5650510191917419,
    -0.35004499554634094, 0.8479880094528198, -0.39797601103782654,
    -0.35647401213645935, 0.8641520142555237, -0.35519900918006897,
    -0.29798200726509094, 0.7210670113563538, 0.6255149841308594,
    0, 0, 1,
    0.00001700000029813964, 0.8245400190353394, 0.5658029913902283,
    0.00003300000025774352, 0.917701005935669, -0.397271990776062,
    0.00011200000153621659, 0.9352689981460571, -0.3539389967918396,
    0.00007500000356230885, 0.7807120084762573, 0.6248900294303894,
    0, 0, 1,
    0, 0, 1,
    0.31482499837875366, 0.7626410126686096, 0.5650339722633362,
    0.00001700000029813964, 0.8245400190353394, 0.5658029913902283,
    0.3500339984893799, 0.8479819893836975, -0.39799800515174866,
    0.00003300000025774352, 0.917701005935669, -0.397271990776062,
    0.35644200444221497, 0.8641409873962402, -0.3552600145339966,
    0.00011200000153621659, 0.9352689981460571, -0.3539389967918396,
    0.29793301224708557, 0.7209920287132263, 0.6256250143051147,
    0.00007500000356230885, 0.7807120084762573, 0.6248900294303894,
    0, 0, 1,
    0.5833380222320557, 0.5833569765090942, 0.5651649832725525,
    0.6484479904174805, 0.648485004901886, -0.3987259864807129,
    0.6607480049133301, 0.6608719825744629, -0.35589399933815,
    0.5517799854278564, 0.5518630146980286, 0.6252880096435547,
    0, 0, 1,
    0.762628972530365, 0.31482499837875366, 0.5650510191917419,
    0.8479880094528198, 0.35004499554634094, -0.39797601103782654,
    0.8641520142555237, 0.35647401213645935, -0.35519900918006897,
    0.7210670113563538, 0.29798200726509094, 0.6255149841308594,
    0, 0, 1,
    0.8245400190353394, -0.00001700000029813964, 0.5658029913902283,
    0.917701005935669, -0.00003300000025774352, -0.397271990776062,
    0.9352689981460571, -0.00011200000153621659, -0.3539389967918396,
    0.7807120084762573, -0.00007500000356230885, 0.6248909831047058,
    0.7807120084762573, -0.00007500000356230885, 0.6248909831047058,
    0.7209920287132263, -0.29793301224708557, 0.6256250143051147,
    0.21797800064086914, -0.0902160033583641, 0.9717749953269958,
    0.23658299446105957, 0, 0.9716110229492188,
    0.1595889925956726, -0.06596100330352783, 0.9849770069122314,
    0.17308400571346283, 0, 0.9849069714546204,
    0.3504979908466339, -0.1447400003671646, 0.9253119826316833,
    0.37970298528671265, 0, 0.925108015537262,
    0.48558899760246277, -0.20147399604320526, 0.8506529927253723,
    0.5266720056533813, 0, 0.8500679731369019,
    0.5518630146980286, -0.5517799854278564, 0.6252880096435547,
    0.16663099825382233, -0.16663099825382233, 0.9718379974365234,
    0.12190800160169601, -0.12190800160169601, 0.9850260019302368,
    0.2676680088043213, -0.2676680088043213, 0.9255849719047546,
    0.37131500244140625, -0.37131500244140625, 0.8510289788246155,
    0.29798200726509094, -0.7210670113563538, 0.6255149841308594,
    0.0902160033583641, -0.21797800064086914, 0.9717749953269958,
    0.06596100330352783, -0.1595889925956726, 0.9849770069122314,
    0.1447400003671646, -0.3504979908466339, 0.9253119826316833,
    0.20147399604320526, -0.48558899760246277, 0.8506529927253723,
    -0.00007500000356230885, -0.7807120084762573, 0.6248900294303894,
    0, -0.23658299446105957, 0.9716110229492188,
    0, -0.17308400571346283, 0.9849069714546204,
    0, -0.37970298528671265, 0.925108015537262,
    0, -0.5266720056533813, 0.8500679731369019,
    -0.00007500000356230885, -0.7807120084762573, 0.6248900294303894,
    -0.29793301224708557, -0.7209920287132263, 0.6256250143051147,
    -0.0902160033583641, -0.21797800064086914, 0.9717749953269958,
    0, -0.23658299446105957, 0.9716110229492188,
    -0.06596100330352783, -0.1595889925956726, 0.9849770069122314,
    0, -0.17308400571346283, 0.9849069714546204,
    -0.1447400003671646, -0.3504979908466339, 0.9253119826316833,
    0, -0.37970298528671265, 0.925108015537262,
    -0.20147399604320526, -0.48558899760246277, 0.8506529927253723,
    0, -0.5266720056533813, 0.8500679731369019,
    -0.5517799854278564, -0.5518630146980286, 0.6252880096435547,
    -0.16663099825382233, -0.16663099825382233, 0.9718379974365234,
    -0.12190800160169601, -0.12190800160169601, 0.9850260019302368,
    -0.2676680088043213, -0.2676680088043213, 0.9255849719047546,
    -0.37131500244140625, -0.37131500244140625, 0.8510289788246155,
    -0.7210670113563538, -0.29798200726509094, 0.6255149841308594,
    -0.21797800064086914, -0.0902160033583641, 0.9717749953269958,
    -0.1595889925956726, -0.06596100330352783, 0.9849770069122314,
    -0.3504979908466339, -0.1447400003671646, 0.9253119826316833,
    -0.48558899760246277, -0.20147399604320526, 0.8506529927253723,
    -0.7807120084762573, 0.00007500000356230885, 0.6248900294303894,
    -0.23658299446105957, 0, 0.9716110229492188,
    -0.17308400571346283, 0, 0.9849069714546204,
    -0.37970298528671265, 0, 0.925108015537262,
    -0.5266720056533813, 0, 0.8500679731369019,
    -0.7807120084762573, 0.00007500000356230885, 0.6248900294303894,
    -0.7209920287132263, 0.29793301224708557, 0.6256250143051147,
    -0.21797800064086914, 0.0902160033583641, 0.9717749953269958,
    -0.23658299446105957, 0, 0.9716110229492188,
    -0.1595889925956726, 0.06596100330352783, 0.9849770069122314,
    -0.17308400571346283, 0, 0.9849069714546204,
    -0.3504979908466339, 0.1447400003671646, 0.9253119826316833,
    -0.37970298528671265, 0, 0.925108015537262,
    -0.48558899760246277, 0.20147399604320526, 0.8506529927253723,
    -0.5266720056533813, 0, 0.8500679731369019,
    -0.5518630146980286, 0.5517799854278564, 0.6252880096435547,
    -0.16663099825382233, 0.16663099825382233, 0.9718379974365234,
    -0.12190800160169601, 0.12190800160169601, 0.9850260019302368,
    -0.2676680088043213, 0.2676680088043213, 0.9255849719047546,
    -0.37131500244140625, 0.37131500244140625, 0.8510289788246155,
    -0.29798200726509094, 0.7210670113563538, 0.6255149841308594,
    -0.0902160033583641, 0.21797800064086914, 0.9717749953269958,
    -0.06596100330352783, 0.1595889925956726, 0.9849770069122314,
    -0.1447400003671646, 0.3504979908466339, 0.9253119826316833,
    -0.20147399604320526, 0.48558899760246277, 0.8506529927253723,
    0.00007500000356230885, 0.7807120084762573, 0.6248900294303894,
    0, 0.23658299446105957, 0.9716110229492188,
    0, 0.17308400571346283, 0.9849069714546204,
    0, 0.37970298528671265, 0.925108015537262,
    0, 0.5266720056533813, 0.8500679731369019,
    0.00007500000356230885, 0.7807120084762573, 0.6248900294303894,
    0.29793301224708557, 0.7209920287132263, 0.6256250143051147,
    0.0902160033583641, 0.21797800064086914, 0.9717749953269958,
    0, 0.23658299446105957, 0.9716110229492188,
    0.06596100330352783, 0.1595889925956726, 0.9849770069122314,
    0, 0.17308400571346283, 0.9849069714546204,
    0.1447400003671646, 0.3504979908466339, 0.9253119826316833,
    0, 0.37970298528671265, 0.925108015537262,
    0.20147399604320526, 0.48558899760246277, 0.8506529927253723,
    0, 0.5266720056533813, 0.8500679731369019,
    0.5517799854278564, 0.5518630146980286, 0.6252880096435547,
    0.16663099825382233, 0.16663099825382233, 0.9718379974365234,
    0.12190800160169601, 0.12190800160169601, 0.9850260019302368,
    0.2676680088043213, 0.2676680088043213, 0.9255849719047546,
    0.37131500244140625, 0.37131500244140625, 0.8510289788246155,
    0.7210670113563538, 0.29798200726509094, 0.6255149841308594,
    0.21797800064086914, 0.0902160033583641, 0.9717749953269958,
    0.1595889925956726, 0.06596100330352783, 0.9849770069122314,
    0.3504979908466339, 0.1447400003671646, 0.9253119826316833,
    0.48558899760246277, 0.20147399604320526, 0.8506529927253723,
    0.7807120084762573, -0.00007500000356230885, 0.6248909831047058,
    0.23658299446105957, 0, 0.9716110229492188,
    0.17308400571346283, 0, 0.9849069714546204,
    0.37970298528671265, 0, 0.925108015537262,
    0.5266720056533813, 0, 0.8500679731369019,
};

// clang-format on

static const int teapot_indices[] = {
    0,   1,   2,   2,   3,   0,   3,   2,   4,   4,   5,   3,   5,   4,   6,   6,   7,   5,   7,   6,   8,   8,   9,   7,   1,
    10,  11,  11,  2,   1,   2,   11,  12,  12,  4,   2,   4,   12,  13,  13,  6,   4,   6,   13,  14,  14,  8,   6,   10,  15,
    16,  16,  11,  10,  11,  16,  17,  17,  12,  11,  12,  17,  18,  18,  13,  12,  13,  18,  19,  19,  14,  13,  15,  20,  21,
    21,  16,  15,  16,  21,  22,  22,  17,  16,  17,  22,  23,  23,  18,  17,  18,  23,  24,  24,  19,  18,  25,  26,  27,  27,
    28,  25,  28,  27,  29,  29,  30,  28,  30,  29,  31,  31,  32,  30,  32,  31,  33,  33,  34,  32,  26,  35,  36,  36,  27,
    26,  27,  36,  37,  37,  29,  27,  29,  37,  38,  38,  31,  29,  31,  38,  39,  39,  33,  31,  35,  40,  41,  41,  36,  35,
    36,  41,  42,  42,  37,  36,  37,  42,  43,  43,  38,  37,  38,  43,  44,  44,  39,  38,  40,  45,  46,  46,  41,  40,  41,
    46,  47,  47,  42,  41,  42,  47,  48,  48,  43,  42,  43,  48,  49,  49,  44,  43,  50,  51,  52,  52,  53,  50,  53,  52,
    54,  54,  55,  53,  55,  54,  56,  56,  57,  55,  57,  56,  58,  58,  59,  57,  51,  60,  61,  61,  52,  51,  52,  61,  62,
    62,  54,  52,  54,  62,  63,  63,  56,  54,  56,  63,  64,  64,  58,  56,  60,  65,  66,  66,  61,  60,  61,  66,  67,  67,
    62,  61,  62,  67,  68,  68,  63,  62,  63,  68,  69,  69,  64,  63,  65,  70,  71,  71,  66,  65,  66,  71,  72,  72,  67,
    66,  67,  72,  73,  73,  68,  67,  68,  73,  74,  74,  69,  68,  75,  76,  77,  77,  78,  75,  78,  77,  79,  79,  80,  78,
    80,  79,  81,  81,  82,  80,  82,  81,  83,  83,  84,  82,  76,  85,  86,  86,  77,  76,  77,  86,  87,  87,  79,  77,  79,
    87,  88,  88,  81,  79,  81,  88,  89,  89,  83,  81,  85,  90,  91,  91,  86,  85,  86,  91,  92,  92,  87,  86,  87,  92,
    93,  93,  88,  87,  88,  93,  94,  94,  89,  88,  90,  95,  96,  96,  91,  90,  91,  96,  97,  97,  92,  91,  92,  97,  98,
    98,  93,  92,  93,  98,  99,  99,  94,  93,  100, 101, 102, 102, 103, 100, 103, 102, 104, 104, 105, 103, 105, 104, 106, 106,
    107, 105, 107, 106, 108, 108, 109, 107, 101, 110, 111, 111, 102, 101, 102, 111, 112, 112, 104, 102, 104, 112, 113, 113, 106,
    104, 106, 113, 114, 114, 108, 106, 110, 115, 116, 116, 111, 110, 111, 116, 117, 117, 112, 111, 112, 117, 118, 118, 113, 112,
    113, 118, 119, 119, 114, 113, 115, 120, 121, 121, 116, 115, 116, 121, 122, 122, 117, 116, 117, 122, 123, 123, 118, 117, 118,
    123, 124, 124, 119, 118, 125, 126, 127, 127, 128, 125, 128, 127, 129, 129, 130, 128, 130, 129, 131, 131, 132, 130, 132, 131,
    133, 133, 134, 132, 126, 135, 136, 136, 127, 126, 127, 136, 137, 137, 129, 127, 129, 137, 138, 138, 131, 129, 131, 138, 139,
    139, 133, 131, 135, 140, 141, 141, 136, 135, 136, 141, 142, 142, 137, 136, 137, 142, 143, 143, 138, 137, 138, 143, 144, 144,
    139, 138, 140, 145, 146, 146, 141, 140, 141, 146, 147, 147, 142, 141, 142, 147, 148, 148, 143, 142, 143, 148, 149, 149, 144,
    143, 150, 151, 152, 152, 153, 150, 153, 152, 154, 154, 155, 153, 155, 154, 156, 156, 157, 155, 157, 156, 158, 158, 159, 157,
    151, 160, 161, 161, 152, 151, 152, 161, 162, 162, 154, 152, 154, 162, 163, 163, 156, 154, 156, 163, 164, 164, 158, 156, 160,
    165, 166, 166, 161, 160, 161, 166, 167, 167, 162, 161, 162, 167, 168, 168, 163, 162, 163, 168, 169, 169, 164, 163, 165, 170,
    171, 171, 166, 165, 166, 171, 172, 172, 167, 166, 167, 172, 173, 173, 168, 167, 168, 173, 174, 174, 169, 168, 175, 176, 177,
    177, 178, 175, 178, 177, 179, 179, 180, 178, 180, 179, 181, 181, 182, 180, 182, 181, 183, 183, 184, 182, 176, 185, 186, 186,
    177, 176, 177, 186, 187, 187, 179, 177, 179, 187, 188, 188, 181, 179, 181, 188, 189, 189, 183, 181, 185, 190, 191, 191, 186,
    185, 186, 191, 192, 192, 187, 186, 187, 192, 193, 193, 188, 187, 188, 193, 194, 194, 189, 188, 190, 195, 196, 196, 191, 190,
    191, 196, 197, 197, 192, 191, 192, 197, 198, 198, 193, 192, 193, 198, 199, 199, 194, 193, 200, 201, 202, 202, 203, 200, 203,
    202, 204, 204, 205, 203, 205, 204, 206, 206, 207, 205, 207, 206, 208, 208, 209, 207, 201, 210, 211, 211, 202, 201, 202, 211,
    212, 212, 204, 202, 204, 212, 213, 213, 206, 204, 206, 213, 214, 214, 208, 206, 210, 215, 216, 216, 211, 210, 211, 216, 217,
    217, 212, 211, 212, 217, 218, 218, 213, 212, 213, 218, 219, 219, 214, 213, 215, 220, 221, 221, 216, 215, 216, 221, 222, 222,
    217, 216, 217, 222, 223, 223, 218, 217, 218, 223, 224, 224, 219, 218, 225, 226, 227, 227, 228, 225, 228, 227, 229, 229, 230,
    228, 230, 229, 231, 231, 232, 230, 232, 231, 233, 233, 234, 232, 226, 235, 236, 236, 227, 226, 227, 236, 237, 237, 229, 227,
    229, 237, 238, 238, 231, 229, 231, 238, 239, 239, 233, 231, 235, 240, 241, 241, 236, 235, 236, 241, 242, 242, 237, 236, 237,
    242, 243, 243, 238, 237, 238, 243, 244, 244, 239, 238, 240, 245, 246, 246, 241, 240, 241, 246, 247, 247, 242, 241, 242, 247,
    248, 248, 243, 242, 243, 248, 249, 249, 244, 243, 250, 251, 252, 252, 253, 250, 253, 252, 254, 254, 255, 253, 255, 254, 256,
    256, 257, 255, 257, 256, 258, 258, 259, 257, 251, 260, 261, 261, 252, 251, 252, 261, 262, 262, 254, 252, 254, 262, 263, 263,
    256, 254, 256, 263, 264, 264, 258, 256, 260, 265, 266, 266, 261, 260, 261, 266, 267, 267, 262, 261, 262, 267, 268, 268, 263,
    262, 263, 268, 269, 269, 264, 263, 265, 270, 271, 271, 266, 265, 266, 271, 272, 272, 267, 266, 267, 272, 273, 273, 268, 267,
    268, 273, 274, 274, 269, 268, 275, 276, 277, 277, 278, 275, 278, 277, 279, 279, 280, 278, 280, 279, 281, 281, 282, 280, 282,
    281, 283, 283, 284, 282, 276, 285, 286, 286, 277, 276, 277, 286, 287, 287, 279, 277, 279, 287, 288, 288, 281, 279, 281, 288,
    289, 289, 283, 281, 285, 290, 291, 291, 286, 285, 286, 291, 292, 292, 287, 286, 287, 292, 293, 293, 288, 287, 288, 293, 294,
    294, 289, 288, 290, 295, 296, 296, 291, 290, 291, 296, 297, 297, 292, 291, 292, 297, 298, 298, 293, 292, 293, 298, 299, 299,
    294, 293, 300, 301, 302, 302, 303, 300, 303, 302, 304, 304, 305, 303, 305, 304, 306, 306, 307, 305, 307, 306, 308, 308, 309,
    307, 301, 310, 311, 311, 302, 301, 302, 311, 312, 312, 304, 302, 304, 312, 313, 313, 306, 304, 306, 313, 314, 314, 308, 306,
    310, 315, 316, 316, 311, 310, 311, 316, 317, 317, 312, 311, 312, 317, 318, 318, 313, 312, 313, 318, 319, 319, 314, 313, 315,
    320, 321, 321, 316, 315, 316, 321, 322, 322, 317, 316, 317, 322, 323, 323, 318, 317, 318, 323, 324, 324, 319, 318, 325, 326,
    327, 327, 328, 325, 328, 327, 329, 329, 330, 328, 330, 329, 331, 331, 332, 330, 332, 331, 333, 333, 334, 332, 326, 335, 336,
    336, 327, 326, 327, 336, 337, 337, 329, 327, 329, 337, 338, 338, 331, 329, 331, 338, 339, 339, 333, 331, 335, 340, 341, 341,
    336, 335, 336, 341, 342, 342, 337, 336, 337, 342, 343, 343, 338, 337, 338, 343, 344, 344, 339, 338, 340, 345, 346, 346, 341,
    340, 341, 346, 347, 347, 342, 341, 342, 347, 348, 348, 343, 342, 343, 348, 349, 349, 344, 343, 350, 351, 352, 352, 353, 350,
    353, 352, 354, 354, 355, 353, 355, 354, 356, 356, 357, 355, 357, 356, 358, 358, 359, 357, 351, 360, 361, 361, 352, 351, 352,
    361, 362, 362, 354, 352, 354, 362, 363, 363, 356, 354, 356, 363, 364, 364, 358, 356, 360, 365, 366, 366, 361, 360, 361, 366,
    367, 367, 362, 361, 362, 367, 368, 368, 363, 362, 363, 368, 369, 369, 364, 363, 365, 370, 371, 371, 366, 365, 366, 371, 372,
    372, 367, 366, 367, 372, 373, 373, 368, 367, 368, 373, 374, 374, 369, 368, 375, 376, 377, 377, 378, 375, 378, 377, 379, 379,
    380, 378, 380, 379, 381, 381, 382, 380, 382, 381, 383, 383, 384, 382, 376, 385, 386, 386, 377, 376, 377, 386, 387, 387, 379,
    377, 379, 387, 388, 388, 381, 379, 381, 388, 389, 389, 383, 381, 385, 390, 391, 391, 386, 385, 386, 391, 392, 392, 387, 386,
    387, 392, 393, 393, 388, 387, 388, 393, 394, 394, 389, 388, 390, 395, 396, 396, 391, 390, 391, 396, 397, 397, 392, 391, 392,
    397, 398, 398, 393, 392, 393, 398, 399, 399, 394, 393, 400, 401, 402, 402, 403, 400, 403, 402, 404, 404, 405, 403, 405, 404,
    406, 406, 407, 405, 407, 406, 408, 408, 409, 407, 401, 410, 411, 411, 402, 401, 402, 411, 412, 412, 404, 402, 404, 412, 413,
    413, 406, 404, 406, 413, 414, 414, 408, 406, 410, 415, 416, 416, 411, 410, 411, 416, 417, 417, 412, 411, 412, 417, 418, 418,
    413, 412, 413, 418, 419, 419, 414, 413, 415, 420, 421, 421, 416, 415, 416, 421, 422, 422, 417, 416, 417, 422, 423, 423, 418,
    417, 418, 423, 424, 424, 419, 418, 425, 426, 427, 427, 428, 425, 428, 427, 429, 429, 430, 428, 430, 429, 431, 431, 432, 430,
    432, 431, 433, 433, 434, 432, 426, 435, 436, 436, 427, 426, 427, 436, 437, 437, 429, 427, 429, 437, 438, 438, 431, 429, 431,
    438, 439, 439, 433, 431, 435, 440, 441, 441, 436, 435, 436, 441, 442, 442, 437, 436, 437, 442, 443, 443, 438, 437, 438, 443,
    444, 444, 439, 438, 440, 445, 446, 446, 441, 440, 441, 446, 447, 447, 442, 441, 442, 447, 448, 448, 443, 442, 443, 448, 449,
    449, 444, 443, 450, 451, 452, 452, 453, 450, 453, 452, 454, 454, 455, 453, 455, 454, 456, 456, 457, 455, 457, 456, 458, 458,
    459, 457, 451, 460, 461, 461, 452, 451, 452, 461, 462, 462, 454, 452, 454, 462, 463, 463, 456, 454, 456, 463, 464, 464, 458,
    456, 460, 465, 466, 466, 461, 460, 461, 466, 467, 467, 462, 461, 462, 467, 468, 468, 463, 462, 463, 468, 469, 469, 464, 463,
    465, 470, 471, 471, 466, 465, 466, 471, 472, 472, 467, 466, 467, 472, 473, 473, 468, 467, 468, 473, 474, 474, 469, 468, 475,
    476, 477, 477, 478, 475, 478, 477, 479, 479, 480, 478, 480, 479, 481, 481, 482, 480, 482, 481, 483, 483, 484, 482, 476, 485,
    486, 486, 477, 476, 477, 486, 487, 487, 479, 477, 479, 487, 488, 488, 481, 479, 481, 488, 489, 489, 483, 481, 485, 490, 491,
    491, 486, 485, 486, 491, 492, 492, 487, 486, 487, 492, 493, 493, 488, 487, 488, 493, 494, 494, 489, 488, 490, 495, 496, 496,
    491, 490, 491, 496, 497, 497, 492, 491, 492, 497, 498, 498, 493, 492, 493, 498, 499, 499, 494, 493, 500, 501, 502, 502, 503,
    500, 503, 502, 504, 504, 505, 503, 505, 504, 506, 506, 507, 505, 507, 506, 508, 508, 509, 507, 501, 510, 511, 511, 502, 501,
    502, 511, 512, 512, 504, 502, 504, 512, 513, 513, 506, 504, 506, 513, 514, 514, 508, 506, 510, 515, 516, 516, 511, 510, 511,
    516, 517, 517, 512, 511, 512, 517, 518, 518, 513, 512, 513, 518, 519, 519, 514, 513, 515, 520, 521, 521, 516, 515, 516, 521,
    522, 522, 517, 516, 517, 522, 523, 523, 518, 517, 518, 523, 524, 524, 519, 518, 525, 526, 527, 527, 528, 525, 528, 527, 529,
    529, 530, 528, 530, 529, 531, 531, 532, 530, 532, 531, 533, 533, 534, 532, 526, 535, 536, 536, 527, 526, 527, 536, 537, 537,
    529, 527, 529, 537, 538, 538, 531, 529, 531, 538, 539, 539, 533, 531, 535, 540, 541, 541, 536, 535, 536, 541, 542, 542, 537,
    536, 537, 542, 543, 543, 538, 537, 538, 543, 544, 544, 539, 538, 540, 545, 546, 546, 541, 540, 541, 546, 547, 547, 542, 541,
    542, 547, 548, 548, 543, 542, 543, 548, 549, 549, 544, 543, 550, 551, 552, 552, 553, 550, 553, 552, 554, 554, 555, 553, 555,
    554, 556, 556, 557, 555, 557, 556, 558, 558, 559, 557, 551, 560, 561, 561, 552, 551, 552, 561, 562, 562, 554, 552, 554, 562,
    563, 563, 556, 554, 556, 563, 564, 564, 558, 556, 560, 565, 566, 566, 561, 560, 561, 566, 567, 567, 562, 561, 562, 567, 568,
    568, 563, 562, 563, 568, 569, 569, 564, 563, 565, 570, 571, 571, 566, 565, 566, 571, 572, 572, 567, 566, 567, 572, 573, 573,
    568, 567, 568, 573, 574, 574, 569, 568, 575, 576, 577, 577, 578, 575, 578, 577, 579, 579, 580, 578, 580, 579, 581, 581, 582,
    580, 582, 581, 583, 583, 584, 582, 576, 585, 586, 586, 577, 576, 577, 586, 587, 587, 579, 577, 579, 587, 588, 588, 581, 579,
    581, 588, 589, 589, 583, 581, 585, 590, 591, 591, 586, 585, 586, 591, 592, 592, 587, 586, 587, 592, 593, 593, 588, 587, 588,
    593, 594, 594, 589, 588, 590, 595, 596, 596, 591, 590, 591, 596, 597, 597, 592, 591, 592, 597, 598, 598, 593, 592, 593, 598,
    599, 599, 594, 593, 600, 601, 602, 602, 603, 600, 603, 602, 604, 604, 605, 603, 605, 604, 606, 606, 607, 605, 607, 606, 608,
    608, 609, 607, 601, 610, 611, 611, 602, 601, 602, 611, 612, 612, 604, 602, 604, 612, 613, 613, 606, 604, 606, 613, 614, 614,
    608, 606, 610, 615, 616, 616, 611, 610, 611, 616, 617, 617, 612, 611, 612, 617, 618, 618, 613, 612, 613, 618, 619, 619, 614,
    613, 615, 620, 621, 621, 616, 615, 616, 621, 622, 622, 617, 616, 617, 622, 623, 623, 618, 617, 618, 623, 624, 624, 619, 618,
    625, 626, 627, 627, 628, 625, 628, 627, 629, 629, 630, 628, 630, 629, 631, 631, 632, 630, 632, 631, 633, 633, 634, 632, 626,
    635, 636, 636, 627, 626, 627, 636, 637, 637, 629, 627, 629, 637, 638, 638, 631, 629, 631, 638, 639, 639, 633, 631, 635, 640,
    641, 641, 636, 635, 636, 641, 642, 642, 637, 636, 637, 642, 643, 643, 638, 637, 638, 643, 644, 644, 639, 638, 640, 645, 646,
    646, 641, 640, 641, 646, 647, 647, 642, 641, 642, 647, 648, 648, 643, 642, 643, 648, 649, 649, 644, 643, 650, 651, 652, 652,
    653, 650, 653, 652, 654, 654, 655, 653, 655, 654, 656, 656, 657, 655, 657, 656, 658, 658, 659, 657, 651, 660, 661, 661, 652,
    651, 652, 661, 662, 662, 654, 652, 654, 662, 663, 663, 656, 654, 656, 663, 664, 664, 658, 656, 660, 665, 666, 666, 661, 660,
    661, 666, 667, 667, 662, 661, 662, 667, 668, 668, 663, 662, 663, 668, 669, 669, 664, 663, 665, 670, 671, 671, 666, 665, 666,
    671, 672, 672, 667, 666, 667, 672, 673, 673, 668, 667, 668, 673, 674, 674, 669, 668, 675, 676, 677, 677, 678, 675, 678, 677,
    679, 679, 680, 678, 680, 679, 681, 681, 682, 680, 682, 681, 683, 683, 684, 682, 676, 685, 686, 686, 677, 676, 677, 686, 687,
    687, 679, 677, 679, 687, 688, 688, 681, 679, 681, 688, 689, 689, 683, 681, 685, 690, 691, 691, 686, 685, 686, 691, 692, 692,
    687, 686, 687, 692, 693, 693, 688, 687, 688, 693, 694, 694, 689, 688, 690, 695, 696, 696, 691, 690, 691, 696, 697, 697, 692,
    691, 692, 697, 698, 698, 693, 692, 693, 698, 699, 699, 694, 693, 700, 701, 702, 702, 703, 700, 703, 702, 704, 704, 705, 703,
    705, 704, 706, 706, 707, 705, 707, 706, 708, 708, 709, 707, 701, 710, 711, 711, 702, 701, 702, 711, 712, 712, 704, 702, 704,
    712, 713, 713, 706, 704, 706, 713, 714, 714, 708, 706, 710, 715, 716, 716, 711, 710, 711, 716, 717, 717, 712, 711, 712, 717,
    718, 718, 713, 712, 713, 718, 719, 719, 714, 713, 715, 720, 721, 721, 716, 715, 716, 721, 722, 722, 717, 716, 717, 722, 723,
    723, 718, 717, 718, 723, 724, 724, 719, 718, 725, 726, 727, 727, 728, 725, 728, 727, 729, 729, 730, 728, 730, 729, 731, 731,
    732, 730, 732, 731, 733, 733, 734, 732, 726, 735, 736, 736, 727, 726, 727, 736, 737, 737, 729, 727, 729, 737, 738, 738, 731,
    729, 731, 738, 739, 739, 733, 731, 735, 740, 741, 741, 736, 735, 736, 741, 742, 742, 737, 736, 737, 742, 743, 743, 738, 737,
    738, 743, 744, 744, 739, 738, 740, 745, 746, 746, 741, 740, 741, 746, 747, 747, 742, 741, 742, 747, 748, 748, 743, 742, 743,
    748, 749, 749, 744, 743, 750, 751, 752, 752, 753, 750, 753, 752, 754, 754, 755, 753, 755, 754, 756, 756, 757, 755, 757, 756,
    758, 758, 759, 757, 751, 760, 761, 761, 752, 751, 752, 761, 762, 762, 754, 752, 754, 762, 763, 763, 756, 754, 756, 763, 764,
    764, 758, 756, 760, 765, 766, 766, 761, 760, 761, 766, 767, 767, 762, 761, 762, 767, 768, 768, 763, 762, 763, 768, 769, 769,
    764, 763, 765, 770, 771, 771, 766, 765, 766, 771, 772, 772, 767, 766, 767, 772, 773, 773, 768, 767, 768, 773, 774, 774, 769,
    768, 775, 776, 777, 777, 778, 775, 778, 777, 779, 779, 780, 778, 780, 779, 781, 781, 782, 780, 782, 781, 783, 783, 784, 782,
    776, 785, 786, 786, 777, 776, 777, 786, 787, 787, 779, 777, 779, 787, 788, 788, 781, 779, 781, 788, 789, 789, 783, 781, 785,
    790, 791, 791, 786, 785, 786, 791, 792, 792, 787, 786, 787, 792, 793, 793, 788, 787, 788, 793, 794, 794, 789, 788, 790, 795,
    796, 796, 791, 790, 791, 796, 797, 797, 792, 791, 792, 797, 798, 798, 793, 792, 793, 798, 799, 799, 794, 793,
};
