/*****************************************************************************
 Copyright (c) 2023, Intel Corporation

 Redistribution and use in source and binary forms, with or without
 modification, are permitted provided that the following conditions are met:

     * Redistributions of source code must retain the above copyright notice,
       this list of conditions and the following disclaimer.
     * Redistributions in binary form must reproduce the above copyright
       notice, this list of conditions and the following disclaimer in the
       documentation and/or other materials provided with the distribution.
     * Neither the name of Intel Corporation nor the names of its contributors
       may be used to endorse or promote products derived from this software
       without specific prior written permission.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
 FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*****************************************************************************/

/* DES */
#include "cipher_test.h"

const struct cipher_test des_test_json[] = {
        /* CM-SP-SECv3.1-I07-170111 I.7 */
        { 64, 64, 1, "\xe6\x60\x0f\xd8\x85\x2e\xf5\xab", "\x81\x0e\x52\x8e\x1c\x5f\xda\x1a",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x88\x41\x65\x06",
          "\x0d\xda\x5a\xcb\xd0\x5e\x55\x67\x9f\x04\xd1\xb6\x41\x3d\x4e\xed", 1, 128 },
        { 64, 64, 2, "\x3b\x38\x98\x37\x15\x20\xf7\x5e", "\x02\xa8\x11\x77\x4d\xcd\xe1\x3b",
          "\x05\xef\xf7\x00\xe9\xa1\x3a\xe5\xca\x0b\xcb\xd0\x48\x47\x64\xbd\x1f\x23"
          "\x1e\xa8\x1c\x7b\x64\xc5\x14\x73\x5a\xc5\x5e\x4b\x79\x63\x3b\x70\x64\x24"
          "\x11\x9e\x09\xdc\xaa\xd4\xac\xf2\x1b\x10\xaf\x3b\x33\xcd\xe3\x50\x48\x47"
          "\x15\x5c\xbb\x6f\x22\x19\xba\x9b\x7d\xf5",
          "\xf3\x31\x8d\x01\x19\x4d\xa8\x00\xa4\x2c\x10\xb5\x33\xd6\xbc\x11\x97\x59"
          "\x2d\xcc\x9b\x5d\x35\x9a\xc3\x04\x5d\x07\x4c\x86\xbf\x72\xe5\x1a\x72\x25"
          "\x82\x22\x54\x03\xde\x8b\x7a\x58\x5c\x6c\x28\xdf\x41\x0e\x38\xd6\x2a\x86"
          "\xe3\x4f\xa2\x7c\x22\x39\x60\x06\x03\x6f",
          1, 512 },
        { 0, 0, 0, NULL, NULL, NULL, NULL, 0, 0 }
};

const struct cipher_test des_docsis_test_json[] = {
        /* CM-SP-SECv3.1-I07-170111 I.7 */
        { 64, 64, 1, "\xe6\x60\x0f\xd8\x85\x2e\xf5\xab", "\x81\x0e\x52\x8e\x1c\x5f\xda\x1a",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x88\x41\x65\x06",
          "\x0d\xda\x5a\xcb\xd0\x5e\x55\x67\x9f\x04\xd1\xb6\x41\x3d\x4e\xed", 1, 128 },
        { 64, 64, 2, "\xe6\x60\x0f\xd8\x85\x2e\xf5\xab", "\x81\x0e\x52\x8e\x1c\x5f\xda\x1a",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x91\xd2\xd1"
          "\x9f",
          "\x0d\xda\x5a\xcb\xd0\x5e\x55\x67\x51\x47\x46\x86\x8a\x71\xe5\x77\xef\xac"
          "\x88",
          1, 152 },
        { 64, 64, 3, "\xe6\x60\x0f\xd8\x85\x2e\xf5\xab", "\x51\x47\x46\x86\x8a\x71\xe5\x77",
          "\xd2\xd1\x9f", "\xef\xac\x88", 1, 24 },
        { 0, 0, 0, NULL, NULL, NULL, NULL, 0, 0 }
};

const struct cipher_test des_cfb_test_json[] = {
        /* CM-SP-SECv3.1-I07-170111 I.7 */
        { 64, 64, 1, "\xe6\x60\x0f\xd8\x85\x2e\xf5\xab", "\x51\x47\x46\x86\x8a\x71\xe5\x77",
          "\xd2\xd1\x9f", "\xef\xac\x88", 1, 24 },
        { 0, 0, 0, NULL, NULL, NULL, NULL, 0, 0 }
};

const struct cipher_test des3_test_json[] = {
        { 64, 192, 1,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x00\x01"
          "\x02\x03\x04\x05\x06\x07",
          "\x00\x01\x02\x03\x04\x05\x06\x07", "\x00\x00\x00\x00\x00\x00\x00\x00",
          "\xdf\x0b\x6c\x9c\x31\xcd\x0c\xe4", 1, 64 },
        { 64, 192, 2,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x00\x01"
          "\x02\x03\x04\x05\x06\x07",
          "\x00\x01\x02\x03\x04\x05\x06\x07",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f",
          "\xdd\xad\xa1\x61\xe8\xd7\x96\x73\xed\x75\x32\xe5\x92\x23\xcd\x0d", 1, 128 },
        { 64, 192, 3,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10\x11"
          "\x12\x13\x14\x15\x16\x17",
          "\x00\x01\x02\x03\x04\x05\x06\x07", "\x00\x00\x00\x00\x00\x00\x00\x00",
          "\x58\xed\x24\x8f\x77\xf6\xb1\x9e", 1, 64 },
        { 64, 192, 4,
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10\x11"
          "\x12\x13\x14\x15\x16\x17",
          "\x00\x01\x02\x03\x04\x05\x06\x07",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f",
          "\x89\x4b\xc3\x08\x54\x26\xa4\x41\xf2\x7f\x73\xae\x26\xab\xbf\x74", 1, 128 },
        { 0, 0, 0, NULL, NULL, NULL, NULL, 0, 0 }
};
